/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.feature;

import com.okta.commons.http.HttpHeaders;
import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.common.EnabledStatus;
import com.okta.sdk.resource.feature.Feature;
import com.okta.sdk.resource.feature.FeatureList;
import com.okta.sdk.resource.feature.FeatureStage;
import com.okta.sdk.resource.feature.FeatureType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultFeature
extends AbstractInstanceResource<Feature>
implements Feature {
    private static final MapProperty linksProperty = new MapProperty("_links");
    private static final StringProperty descriptionProperty = new StringProperty("description");
    private static final StringProperty idProperty = new StringProperty("id");
    private static final StringProperty nameProperty = new StringProperty("name");
    private static final ResourceReference<FeatureStage> stageProperty = new ResourceReference<FeatureStage>("stage", FeatureStage.class, false);
    private static final EnumProperty<EnabledStatus> statusProperty = new EnumProperty<EnabledStatus>("status", EnabledStatus.class);
    private static final EnumProperty<FeatureType> typeProperty = new EnumProperty<FeatureType>("type", FeatureType.class);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultFeature.createPropertyDescriptorMap(linksProperty, descriptionProperty, idProperty, nameProperty, stageProperty, statusProperty, typeProperty);

    public DefaultFeature(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultFeature(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return Feature.class;
    }

    public Map<String, Object> getLinks() {
        return this.getMap(linksProperty);
    }

    public String getDescription() {
        return this.getString(descriptionProperty);
    }

    public Feature setDescription(String description) {
        this.setProperty(descriptionProperty, (Object)description);
        return this;
    }

    public String getId() {
        return this.getString(idProperty);
    }

    public String getName() {
        return this.getString(nameProperty);
    }

    public Feature setName(String name) {
        this.setProperty(nameProperty, (Object)name);
        return this;
    }

    public FeatureStage getStage() {
        return this.getResourceProperty(stageProperty);
    }

    public Feature setStage(FeatureStage stage) {
        this.setProperty(stageProperty, (Object)stage);
        return this;
    }

    public EnabledStatus getStatus() {
        return this.getEnumProperty(statusProperty);
    }

    public Feature setStatus(EnabledStatus status) {
        this.setProperty(statusProperty, (Object)status);
        return this;
    }

    public FeatureType getType() {
        return this.getEnumProperty(typeProperty);
    }

    public Feature setType(FeatureType type) {
        this.setProperty(typeProperty, (Object)type);
        return this;
    }

    public Feature updateLifecycle(String lifecycle, String mode) {
        String featureId = this.getId();
        Assert.hasText((String)featureId, (String)"'featureId' is required and cannot be null or empty.");
        Assert.hasText((String)lifecycle, (String)"'lifecycle' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (mode != null) {
            queryArgs.put("mode", mode);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/features/" + featureId + "/" + lifecycle + "", new DefaultVoidResource(this.getDataStore()), this, Feature.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Feature updateLifecycle(String lifecycle) {
        String featureId = this.getId();
        Assert.hasText((String)featureId, (String)"'featureId' is required and cannot be null or empty.");
        Assert.hasText((String)lifecycle, (String)"'lifecycle' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/features/" + featureId + "/" + lifecycle + "", new DefaultVoidResource(this.getDataStore()), this, Feature.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public FeatureList getDependencies() {
        String featureId = this.getId();
        Assert.hasText((String)featureId, (String)"'featureId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/features/" + featureId + "/dependencies", FeatureList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public FeatureList getDependents() {
        String featureId = this.getId();
        Assert.hasText((String)featureId, (String)"'featureId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/features/" + featureId + "/dependents", FeatureList.class, queryArgs, (Map<String, List<String>>)headers);
    }
}

