/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.impl;

import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.pm.ResetPasswordManagementProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.pm.PasswordManagementQuery;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.PasswordResetUrlBuilder;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.ticket.TransientSessionTicketFactory;
import org.apereo.cas.ticket.expiration.HardTimeoutExpirationPolicy;
import org.apereo.cas.ticket.expiration.MultiTimeUseOrTimeoutExpirationPolicy;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriUtils;

public class DefaultPasswordResetUrlBuilder
implements PasswordResetUrlBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPasswordResetUrlBuilder.class);
    protected final PasswordManagementService passwordManagementService;
    protected final TicketRegistry ticketRegistry;
    protected final TicketFactory ticketFactory;
    protected final CasConfigurationProperties casProperties;

    @Override
    public URL build(String username, WebApplicationService service) throws Exception {
        Object query = ((PasswordManagementQuery.PasswordManagementQueryBuilder)PasswordManagementQuery.builder().username(username)).build();
        LOGGER.debug("Creating password reset URL designed for [{}]", (Object)username);
        String token = this.passwordManagementService.createToken((PasswordManagementQuery)query);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            TransientSessionTicketFactory transientFactory = (TransientSessionTicketFactory)this.ticketFactory.get(TransientSessionTicket.class);
            Map properties = CollectionUtils.wrap((String)"token", (Object)token, (String)ExpirationPolicy.class.getName(), (Object)this.computeExpirationPolicy());
            TransientSessionTicket ticket = transientFactory.create((Service)service, properties);
            this.ticketRegistry.addTicket((Ticket)ticket);
            StringBuilder resetUrl = new StringBuilder(this.casProperties.getServer().getPrefix()).append('/').append("login").append('?').append("pswdrst").append('=').append(ticket.getId());
            if (service != null) {
                String encodeServiceUrl = UriUtils.encode((String)service.getOriginalUrl(), (Charset)StandardCharsets.UTF_8);
                resetUrl.append('&').append("service").append('=').append(encodeServiceUrl);
            }
            String url = resetUrl.toString();
            LOGGER.debug("Final password reset URL designed for [{}] is [{}]", (Object)username, (Object)url);
            return new URL(url);
        }
        LOGGER.error("Could not create password reset url since no reset token could be generated");
        return null;
    }

    protected ExpirationPolicy computeExpirationPolicy() {
        ResetPasswordManagementProperties reset = this.casProperties.getAuthn().getPm().getReset();
        int numberOfUses = reset.getNumberOfUses();
        long seconds = Beans.newDuration((String)reset.getExpiration()).toSeconds();
        if (numberOfUses >= 1) {
            LOGGER.debug("Password reset URL shall expire after [{}] uses and [{}] second(s)", (Object)numberOfUses, (Object)seconds);
            return new MultiTimeUseOrTimeoutExpirationPolicy((long)numberOfUses, seconds);
        }
        LOGGER.debug("Password reset URL shall expire in [{}] second(s)", (Object)seconds);
        return HardTimeoutExpirationPolicy.builder().timeToKillInSeconds(seconds).build();
    }

    @Generated
    public DefaultPasswordResetUrlBuilder(PasswordManagementService passwordManagementService, TicketRegistry ticketRegistry, TicketFactory ticketFactory, CasConfigurationProperties casProperties) {
        this.passwordManagementService = passwordManagementService;
        this.ticketRegistry = ticketRegistry;
        this.ticketFactory = ticketFactory;
        this.casProperties = casProperties;
    }
}

