/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.core;

import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.JQueryAbstractBehavior;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.utils.JQueryUtils;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Generics;

public class JQueryBehavior
extends JQueryAbstractBehavior {
    private static final long serialVersionUID = 1L;
    protected String selector = null;
    protected final String method;
    protected final Options options;
    private List<String> events = null;

    public JQueryBehavior(String selector) {
        this(selector, "");
    }

    public JQueryBehavior(String selector, String method) {
        this(selector, method, new Options());
    }

    public JQueryBehavior(String selector, String method, Options options) {
        this.method = (String)Args.notNull((Object)method, (String)"method");
        this.options = (Options)Args.notNull((Object)options, (String)"options");
        this.selector = selector;
    }

    @Override
    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        if (this.events != null) {
            StringBuilder statements = new StringBuilder();
            for (String event : this.events) {
                statements.append(event);
            }
            this.renderOnDomReadyScript(statements.toString(), response);
        }
    }

    public void detach(IPartialPageRequestHandler handler) {
        handler.prependJavaScript((CharSequence)JQueryUtils.detach(this.selector));
    }

    public void remove(IPartialPageRequestHandler handler) {
        handler.prependJavaScript((CharSequence)JQueryUtils.remove(this.selector));
    }

    public String getSelector() {
        return this.selector;
    }

    protected void setSelector(String selector) {
        this.selector = selector;
    }

    public String getMethod() {
        return this.method;
    }

    public <T> T getOption(String key) {
        return this.options.get(key);
    }

    public JQueryBehavior setOption(String key, Object value) {
        this.options.set(key, value);
        return this;
    }

    public JQueryBehavior setOption(String key, Object ... values) {
        this.options.set(key, values);
        return this;
    }

    public JQueryBehavior setOption(String key, List<?> values) {
        this.options.set(key, values);
        return this;
    }

    public Options getOptions() {
        return this.options;
    }

    public void setOptions(Options options) {
        for (Map.Entry<String, Object> option : options.entries()) {
            this.setOption(option.getKey(), option.getValue());
        }
    }

    protected void on(String event, String callback) {
        this.on(this.selector, event, callback);
    }

    protected void on(String selector, String event, String callback) {
        this.register(String.format("jQuery('%s').on('%s', %s);", selector, event, callback));
    }

    protected void off(String selector, String event) {
        this.register(String.format("jQuery('%s').off('%s');", selector, event));
    }

    protected void register(String statement) {
        if (this.events == null) {
            this.events = Generics.newArrayList();
        }
        this.events.add(statement);
    }

    @Override
    protected String $() {
        return JQueryBehavior.$(this.selector, this.method, this.options.toString());
    }

    public String $(String options) {
        return JQueryBehavior.$(this.selector, this.method, options);
    }

    public String $(Options options) {
        return JQueryBehavior.$(this.selector, this.method, options.toString());
    }

    public String $(Object ... options) {
        return JQueryBehavior.$(this.selector, this.method, Options.fromArray(options));
    }

    private static String $(String selector, String method, String options) {
        return String.format("jQuery('%s').%s(%s);", selector, method, options);
    }

    public void onConfigure(Component component) {
        super.onConfigure(component);
        if (component instanceof IJQueryWidget) {
            ((IJQueryWidget)component).onConfigure(this);
        }
    }

    public void beforeRender(Component component) {
        super.beforeRender(component);
        if (component instanceof IJQueryWidget) {
            ((IJQueryWidget)component).onBeforeRender(this);
        }
    }
}

