/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Function;
import com.google.gxp.com.google.common.collect.Lists;
import com.google.gxp.compiler.base.AbbrExpression;
import com.google.gxp.compiler.base.AttrBundleParam;
import com.google.gxp.compiler.base.AttrBundleReference;
import com.google.gxp.compiler.base.BooleanConstant;
import com.google.gxp.compiler.base.Call;
import com.google.gxp.compiler.base.CollapseExpression;
import com.google.gxp.compiler.base.Concatenation;
import com.google.gxp.compiler.base.Conditional;
import com.google.gxp.compiler.base.ConstructedConstant;
import com.google.gxp.compiler.base.ConvertibleToContent;
import com.google.gxp.compiler.base.EscapeExpression;
import com.google.gxp.compiler.base.ExampleExpression;
import com.google.gxp.compiler.base.ExceptionExpression;
import com.google.gxp.compiler.base.ExhaustiveRootVisitor;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.ExtractedMessage;
import com.google.gxp.compiler.base.IsXmlExpression;
import com.google.gxp.compiler.base.LoopExpression;
import com.google.gxp.compiler.base.NativeExpression;
import com.google.gxp.compiler.base.NoMessage;
import com.google.gxp.compiler.base.ObjectConstant;
import com.google.gxp.compiler.base.OutputElement;
import com.google.gxp.compiler.base.PlaceholderEnd;
import com.google.gxp.compiler.base.PlaceholderNode;
import com.google.gxp.compiler.base.PlaceholderStart;
import com.google.gxp.compiler.base.StringConstant;
import com.google.gxp.compiler.base.UnextractedMessage;
import com.google.gxp.compiler.base.Util;
import com.google.gxp.compiler.reparent.Attribute;
import java.util.ArrayList;

public abstract class ExhaustiveExpressionVisitor
extends ExhaustiveRootVisitor {
    private final Function<Attribute, Attribute> attrFunction = new Function<Attribute, Attribute>(){

        @Override
        public Attribute apply(Attribute attr) {
            return ExhaustiveExpressionVisitor.this.visitAttribute(attr);
        }
    };

    @Override
    public Expression apply(Expression value) {
        return value.acceptVisitor(this);
    }

    protected Expression postProcess(Expression value) {
        return value;
    }

    @Override
    public Expression visitAttrBundleParam(AttrBundleParam bundle) {
        return this.postProcess(bundle.transform(this));
    }

    @Override
    public Expression visitAttrBundleReference(AttrBundleReference value) {
        return this.postProcess(value);
    }

    @Override
    public Expression visitExceptionExpression(ExceptionExpression value) {
        return this.postProcess(value);
    }

    @Override
    public Expression visitStringConstant(StringConstant value) {
        return this.postProcess(value);
    }

    @Override
    public Expression visitBooleanConstant(BooleanConstant value) {
        return this.postProcess(value);
    }

    @Override
    public Expression visitObjectConstant(ObjectConstant value) {
        return this.postProcess(value);
    }

    @Override
    public Expression visitConstructedConstant(ConstructedConstant value) {
        return this.postProcess(value);
    }

    @Override
    public Expression visitEscapeExpression(EscapeExpression value) {
        return this.postProcess(value.withSubexpression(this.apply(value.getSubexpression())));
    }

    @Override
    public Expression visitExampleExpression(ExampleExpression value) {
        return this.postProcess(value.withSubexpression(this.apply(value.getSubexpression())));
    }

    @Override
    public Expression visitCollapseExpression(CollapseExpression value) {
        return this.postProcess(value.withSubexpression(this.apply(value.getSubexpression())));
    }

    @Override
    public Expression visitNativeExpression(NativeExpression value) {
        return this.postProcess(value);
    }

    @Override
    public Expression visitNoMessage(NoMessage value) {
        return this.postProcess(value.withSubexpression(this.apply(value.getSubexpression())));
    }

    @Override
    public Expression visitConvertibleToContent(ConvertibleToContent value) {
        return this.postProcess(value.withSubexpression(this.apply(value.getSubexpression())));
    }

    @Override
    public Expression visitConcatenation(Concatenation value) {
        return this.postProcess(value.withValues(Util.map(value.getValues(), this)));
    }

    protected Attribute visitAttribute(Attribute attr) {
        Expression newValue = this.apply(attr.getValue());
        Expression newCondition = attr.getCondition();
        if (newCondition != null) {
            newCondition = this.apply(newCondition);
        }
        return attr.withValue(newValue).withCondition(newCondition);
    }

    protected final Function<Attribute, Attribute> getAttributeFunction() {
        return this.attrFunction;
    }

    @Override
    public Expression visitOutputElement(OutputElement element) {
        return this.postProcess(element.withAttributesAndContent(Util.map(element.getAttributes(), this.getAttributeFunction()), this.apply(element.getContent())));
    }

    public Conditional.Clause visitClause(Conditional.Clause clause) {
        return clause.withExpression(this.apply(clause.getExpression()));
    }

    @Override
    public Expression visitConditional(Conditional conditional) {
        ArrayList<Conditional.Clause> clauses = Lists.newArrayList();
        for (Conditional.Clause clause : conditional.getClauses()) {
            clauses.add(this.visitClause(clause));
        }
        Expression elseExpression = this.apply(conditional.getElseExpression());
        return this.postProcess(conditional.withClauses(clauses, elseExpression));
    }

    @Override
    public Expression visitLoopExpression(LoopExpression loop) {
        return this.postProcess(loop.withSubexpressionAndDelimiter(this.apply(loop.getSubexpression()), this.apply(loop.getDelimiter())));
    }

    @Override
    public Expression visitAbbrExpression(AbbrExpression abbr) {
        return this.postProcess(abbr.withValueAndContent(this.apply(abbr.getValue()), this.apply(abbr.getContent())));
    }

    @Override
    public Expression visitCall(Call call) {
        return this.postProcess(call.transformParams(this));
    }

    @Override
    public Expression visitUnextractedMessage(UnextractedMessage msg) {
        return this.postProcess(msg.withContent(this.apply(msg.getContent())));
    }

    @Override
    public Expression visitExtractedMessage(ExtractedMessage msg) {
        return this.postProcess(msg.transformParams(this));
    }

    @Override
    public Expression visitPlaceholderStart(PlaceholderStart phStart) {
        return this.postProcess(phStart);
    }

    @Override
    public Expression visitPlaceholderEnd(PlaceholderEnd phEnd) {
        return this.postProcess(phEnd);
    }

    @Override
    public Expression visitPlaceholderNode(PlaceholderNode ph) {
        return this.postProcess(ph.withContent(this.apply(ph.getContent())));
    }

    @Override
    public Expression visitIsXmlExpression(IsXmlExpression value) {
        return value;
    }
}

