/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum TransactionState {
    ONGOING("Ongoing"),
    PREPARE_ABORT("PrepareAbort"),
    PREPARE_COMMIT("PrepareCommit"),
    COMPLETE_ABORT("CompleteAbort"),
    COMPLETE_COMMIT("CompleteCommit"),
    EMPTY("Empty"),
    PREPARE_EPOCH_FENCE("PrepareEpochFence"),
    UNKNOWN("Unknown");

    private static final Map<String, TransactionState> NAME_TO_ENUM;
    private final String name;

    private TransactionState(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static TransactionState parse(String name) {
        return NAME_TO_ENUM.getOrDefault(name, UNKNOWN);
    }

    static {
        NAME_TO_ENUM = Arrays.stream(TransactionState.values()).collect(Collectors.toMap(state -> state.name, Function.identity()));
    }
}

