/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.logging;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.config.package$;
import org.apache.spark.util.IntParam$;
import org.apache.spark.util.logging.FileAppender;
import org.apache.spark.util.logging.RollingFileAppender;
import org.apache.spark.util.logging.RollingFileAppender$;
import org.apache.spark.util.logging.SizeBasedRollingPolicy;
import org.apache.spark.util.logging.SizeBasedRollingPolicy$;
import org.apache.spark.util.logging.TimeBasedRollingPolicy;
import org.apache.spark.util.logging.TimeBasedRollingPolicy$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class FileAppender$
implements Logging {
    public static final FileAppender$ MODULE$ = new FileAppender$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int $lessinit$greater$default$3() {
        return 8192;
    }

    public boolean $lessinit$greater$default$4() {
        return false;
    }

    public FileAppender apply(InputStream inputStream, File file, SparkConf conf, boolean closeStreams) {
        String rollingStrategy = conf.get(package$.MODULE$.EXECUTOR_LOGS_ROLLING_STRATEGY());
        String rollingSizeBytes = conf.get(package$.MODULE$.EXECUTOR_LOGS_ROLLING_MAX_SIZE());
        String rollingInterval = conf.get(package$.MODULE$.EXECUTOR_LOGS_ROLLING_TIME_INTERVAL());
        String string = rollingStrategy;
        switch (string == null ? 0 : string.hashCode()) {
            case 0: {
                if (!"".equals(string)) break;
                InputStream x$1 = inputStream;
                File x$2 = file;
                boolean x$3 = closeStreams;
                int x$4 = this.$lessinit$greater$default$3();
                return new FileAppender(x$1, x$2, x$4, x$3);
            }
            case 3530753: {
                if (!"size".equals(string)) break;
                return this.createSizeBasedAppender$1(rollingSizeBytes, file, inputStream, conf, closeStreams);
            }
            case 3560141: {
                if (!"time".equals(string)) break;
                return this.createTimeBasedAppender$1(rollingInterval, file, inputStream, conf, closeStreams);
            }
        }
        this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal strategy [", "] for "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.STRATEGY, rollingStrategy)})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"rolling executor logs, rolling logs not enabled"}))).log((Seq)Nil$.MODULE$))));
        InputStream x$5 = inputStream;
        File x$6 = file;
        boolean x$7 = closeStreams;
        int x$8 = this.$lessinit$greater$default$3();
        return new FileAppender(x$5, x$6, x$8, x$7);
    }

    public boolean apply$default$4() {
        return false;
    }

    private final FileAppender createTimeBasedAppender$1(String rollingInterval$1, File file$1, InputStream inputStream$1, SparkConf conf$1, boolean closeStreams$1) {
        Option<Object> option;
        Some some;
        String string = rollingInterval$1;
        if ("daily".equals(string)) {
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Rolling executor logs enabled for ", " with daily rolling"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.FILE_NAME, file$1)}))));
            some = new Some((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)86400000L), (Object)"--yyyy-MM-dd"));
        } else if ("hourly".equals(string)) {
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Rolling executor logs enabled for ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.FILE_NAME, file$1)})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" with hourly rolling"}))).log((Seq)Nil$.MODULE$))));
            some = new Some((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3600000L), (Object)"--yyyy-MM-dd--HH"));
        } else if ("minutely".equals(string)) {
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Rolling executor logs enabled for ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.FILE_NAME, file$1)})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" with rolling every minute"}))).log((Seq)Nil$.MODULE$))));
            some = new Some((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)60000L), (Object)"--yyyy-MM-dd--HH-mm"));
        } else if (string != null && !(option = IntParam$.MODULE$.unapply(string)).isEmpty()) {
            int seconds = BoxesRunTime.unboxToInt((Object)option.get());
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Rolling executor logs enabled for ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.FILE_NAME, file$1)})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" with rolling ", " seconds"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.TIME_UNITS, BoxesRunTime.boxToInteger((int)seconds))})))));
            some = new Some((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)((long)seconds * 1000L)), (Object)"--yyyy-MM-dd--HH-mm-ss"));
        } else {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal interval for rolling executor logs ["}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "], "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.TIME_UNITS, rollingInterval$1)}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"rolling logs not enabled"}))).log((Seq)Nil$.MODULE$))));
            some = None$.MODULE$;
        }
        Some validatedParams = some;
        return (FileAppender)validatedParams.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long interval = tuple2._1$mcJ$sp();
                String pattern = (String)tuple2._2();
                InputStream x$1 = inputStream$1;
                File x$2 = file$1;
                TimeBasedRollingPolicy x$3 = new TimeBasedRollingPolicy(interval, pattern, TimeBasedRollingPolicy$.MODULE$.$lessinit$greater$default$3());
                SparkConf x$4 = conf$1;
                boolean x$5 = closeStreams$1;
                int x$6 = RollingFileAppender$.MODULE$.$lessinit$greater$default$5();
                return new RollingFileAppender(x$1, x$2, x$3, x$4, x$6, x$5);
            }
            throw new MatchError((Object)tuple2);
        }).getOrElse((Function0 & Serializable)() -> {
            InputStream x$7 = inputStream$1;
            File x$8 = file$1;
            boolean x$9 = closeStreams$1;
            int x$10 = MODULE$.$lessinit$greater$default$3();
            return new FileAppender(x$7, x$8, x$10, x$9);
        });
    }

    private final FileAppender createSizeBasedAppender$1(String rollingSizeBytes$1, File file$1, InputStream inputStream$1, SparkConf conf$1, boolean closeStreams$1) {
        Option<Object> option;
        String string = rollingSizeBytes$1;
        if (string != null && !(option = IntParam$.MODULE$.unapply(string)).isEmpty()) {
            int bytes = BoxesRunTime.unboxToInt((Object)option.get());
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Rolling executor logs enabled for ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.FILE_NAME, file$1)})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" with rolling every ", " bytes"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.NUM_BYTES, BoxesRunTime.boxToInteger((int)bytes))})))));
            InputStream x$1 = inputStream$1;
            File x$2 = file$1;
            SizeBasedRollingPolicy x$3 = new SizeBasedRollingPolicy(bytes, SizeBasedRollingPolicy$.MODULE$.$lessinit$greater$default$2());
            SparkConf x$4 = conf$1;
            boolean x$5 = closeStreams$1;
            int x$6 = RollingFileAppender$.MODULE$.$lessinit$greater$default$5();
            return new RollingFileAppender(x$1, x$2, x$3, x$4, x$6, x$5);
        }
        this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal size [", "] "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.NUM_BYTES, rollingSizeBytes$1)})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"for rolling executor logs, rolling logs not enabled"}))).log((Seq)Nil$.MODULE$))));
        InputStream x$7 = inputStream$1;
        File x$8 = file$1;
        boolean x$9 = closeStreams$1;
        int x$10 = this.$lessinit$greater$default$3();
        return new FileAppender(x$7, x$8, x$10, x$9);
    }

    private FileAppender$() {
    }
}

