/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.types.pojo;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.Collections2;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.util.CallBack;

public class FieldType {
    private final boolean nullable;
    private final ArrowType type;
    private final DictionaryEncoding dictionary;
    private final Map<String, String> metadata;

    public static FieldType nullable(ArrowType type) {
        return new FieldType(true, type, null, null);
    }

    public static FieldType notNullable(ArrowType type) {
        return new FieldType(false, type, null, null);
    }

    public FieldType(boolean nullable, ArrowType type, DictionaryEncoding dictionary) {
        this(nullable, type, dictionary, null);
    }

    public FieldType(boolean nullable, ArrowType type, DictionaryEncoding dictionary, Map<String, String> metadata) {
        this.nullable = nullable;
        this.type = (ArrowType)Preconditions.checkNotNull((Object)type);
        this.dictionary = dictionary;
        if (type instanceof ArrowType.ExtensionType) {
            HashMap<String, String> extensionMetadata = new HashMap<String, String>();
            extensionMetadata.put("ARROW:extension:name", ((ArrowType.ExtensionType)type).extensionName());
            extensionMetadata.put("ARROW:extension:metadata", ((ArrowType.ExtensionType)type).serialize());
            if (metadata != null) {
                extensionMetadata.putAll(metadata);
            }
            this.metadata = Collections.unmodifiableMap(extensionMetadata);
        } else {
            this.metadata = metadata == null ? Collections.emptyMap() : Collections2.immutableMapCopy(metadata);
        }
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public ArrowType getType() {
        return this.type;
    }

    public DictionaryEncoding getDictionary() {
        return this.dictionary;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public FieldVector createNewSingleVector(String name, BufferAllocator allocator, CallBack schemaCallBack) {
        Types.MinorType minorType = Types.getMinorTypeForArrowType(this.type);
        return minorType.getNewVector(name, this, allocator, schemaCallBack);
    }

    public FieldVector createNewSingleVector(Field field, BufferAllocator allocator, CallBack schemaCallBack) {
        Types.MinorType minorType = Types.getMinorTypeForArrowType(this.type);
        return minorType.getNewVector(field, allocator, schemaCallBack);
    }

    public int hashCode() {
        return Objects.hash(this.nullable, this.type, this.dictionary, this.metadata);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FieldType)) {
            return false;
        }
        FieldType that = (FieldType)obj;
        return this.isNullable() == that.isNullable() && Objects.equals(this.getType(), that.getType()) && Objects.equals(this.getDictionary(), that.getDictionary()) && Objects.equals(this.getMetadata(), that.getMetadata());
    }
}

