/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.TimeDiff$;
import org.apache.spark.sql.catalyst.expressions.TimeExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyTimeType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(unit, start, end) - Gets the difference between the times in the specified units.\n  ", arguments="\n    Arguments:\n      * unit - the unit of the difference between the given times\n          - \"HOUR\"\n          - \"MINUTE\"\n          - \"SECOND\"\n          - \"MILLISECOND\"\n          - \"MICROSECOND\"\n      * start - a starting TIME expression\n      * end - an ending TIME expression\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('HOUR', TIME'20:30:29', TIME'21:30:28');\n       0\n      > SELECT _FUNC_('HOUR', TIME'20:30:29', TIME'21:30:29');\n       1\n      > SELECT _FUNC_('HOUR', TIME'20:30:29', TIME'12:00:00');\n       -8\n  ", group="datetime_funcs", since="4.1.0")
@ScalaSignature(bytes="\u0006\u0005\u0005Uh\u0001\u0002\u0012$\u0001BB\u0001\u0002\u0015\u0001\u0003\u0016\u0004%\t!\u0015\u0005\t+\u0002\u0011\t\u0012)A\u0005%\"Aa\u000b\u0001BK\u0002\u0013\u0005\u0011\u000b\u0003\u0005X\u0001\tE\t\u0015!\u0003S\u0011!A\u0006A!f\u0001\n\u0003\t\u0006\u0002C-\u0001\u0005#\u0005\u000b\u0011\u0002*\t\u000bi\u0003A\u0011A.\t\u000b\u0001\u0004A\u0011I)\t\u000b\u0005\u0004A\u0011I)\t\u000b\t\u0004A\u0011I)\t\u000b\r\u0004A\u0011\t3\t\u000b9\u0004A\u0011I8\t\u000bM\u0004A\u0011\t;\t\u000bu\u0004A\u0011\u000b@\t\r\u0005-\u0001\u0001\"\u0011R\u0011%\ti\u0001AA\u0001\n\u0003\ty\u0001C\u0005\u0002\u0018\u0001\t\n\u0011\"\u0001\u0002\u001a!I\u0011q\u0006\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0004\u0005\n\u0003c\u0001\u0011\u0013!C\u0001\u00033A\u0011\"a\r\u0001\u0003\u0003%\t%!\u000e\t\u0013\u0005\u0015\u0003!!A\u0005\u0002\u0005\u001d\u0003\"CA(\u0001\u0005\u0005I\u0011AA)\u0011%\ti\u0006AA\u0001\n\u0003\ny\u0006C\u0005\u0002n\u0001\t\t\u0011\"\u0001\u0002p!I\u0011\u0011\u0010\u0001\u0002\u0002\u0013\u0005\u00131\u0010\u0005\n\u0003\u007f\u0002\u0011\u0011!C!\u0003\u0003;\u0011\"a+$\u0003\u0003E\t!!,\u0007\u0011\t\u001a\u0013\u0011!E\u0001\u0003_CaA\u0017\u000f\u0005\u0002\u0005\u001d\u0007\"CAe9\u0005\u0005IQIAf\u0011%\ti\rHA\u0001\n\u0003\u000by\rC\u0005\u0002Xr\t\t\u0011\"!\u0002Z\"I\u00111\u001e\u000f\u0002\u0002\u0013%\u0011Q\u001e\u0002\t)&lW\rR5gM*\u0011A%J\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002'O\u0005A1-\u0019;bYf\u001cHO\u0003\u0002)S\u0005\u00191/\u001d7\u000b\u0005)Z\u0013!B:qCJ\\'B\u0001\u0017.\u0003\u0019\t\u0007/Y2iK*\ta&A\u0002pe\u001e\u001c\u0001aE\u0004\u0001cUB4H\u0010#\u0011\u0005I\u001aT\"A\u0012\n\u0005Q\u001a#!\u0005+fe:\f'/_#yaJ,7o]5p]B\u0011!GN\u0005\u0003o\r\u0012!CU;oi&lWMU3qY\u0006\u001cW-\u00192mKB\u0011!'O\u0005\u0003u\r\u0012a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003eqJ!!P\u0012\u0003\u001dQKW.Z#yaJ,7o]5p]B\u0011qHQ\u0007\u0002\u0001*\t\u0011)A\u0003tG\u0006d\u0017-\u0003\u0002D\u0001\n9\u0001K]8ek\u000e$\bCA#N\u001d\t15J\u0004\u0002H\u00156\t\u0001J\u0003\u0002J_\u00051AH]8pizJ\u0011!Q\u0005\u0003\u0019\u0002\u000bq\u0001]1dW\u0006<W-\u0003\u0002O\u001f\na1+\u001a:jC2L'0\u00192mK*\u0011A\nQ\u0001\u0005k:LG/F\u0001S!\t\u00114+\u0003\u0002UG\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u000bUt\u0017\u000e\u001e\u0011\u0002\u000bM$\u0018M\u001d;\u0002\rM$\u0018M\u001d;!\u0003\r)g\u000eZ\u0001\u0005K:$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u00059vsv\f\u0005\u00023\u0001!)\u0001k\u0002a\u0001%\")ak\u0002a\u0001%\")\u0001l\u0002a\u0001%\u0006)a-\u001b:ti\u000611/Z2p]\u0012\fQ\u0001\u001e5je\u0012\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005)\u0007cA#gQ&\u0011qm\u0014\u0002\u0004'\u0016\f\bCA5m\u001b\u0005Q'BA6(\u0003\u0015!\u0018\u0010]3t\u0013\ti'N\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-F\u0001q!\tI\u0017/\u0003\u0002sU\nAA)\u0019;b)f\u0004X-\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012!\u001e\t\u0003mjt!a\u001e=\u0011\u0005\u001d\u0003\u0015BA=A\u0003\u0019\u0001&/\u001a3fM&\u00111\u0010 \u0002\u0007'R\u0014\u0018N\\4\u000b\u0005e\u0004\u0015aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u0019av0a\u0001\u0002\b!1\u0011\u0011\u0001\bA\u0002I\u000bqA\\3x+:LG\u000f\u0003\u0004\u0002\u00069\u0001\rAU\u0001\t]\u0016<8\u000b^1si\"1\u0011\u0011\u0002\bA\u0002I\u000baA\\3x\u000b:$\u0017a\u0003:fa2\f7-Z7f]R\fAaY8qsR9A,!\u0005\u0002\u0014\u0005U\u0001b\u0002)\u0011!\u0003\u0005\rA\u0015\u0005\b-B\u0001\n\u00111\u0001S\u0011\u001dA\u0006\u0003%AA\u0002I\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u001c)\u001a!+!\b,\u0005\u0005}\u0001\u0003BA\u0011\u0003Wi!!a\t\u000b\t\u0005\u0015\u0012qE\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u000bA\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003[\t\u0019CA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t9\u0004\u0005\u0003\u0002:\u0005\rSBAA\u001e\u0015\u0011\ti$a\u0010\u0002\t1\fgn\u001a\u0006\u0003\u0003\u0003\nAA[1wC&\u001910a\u000f\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005%\u0003cA \u0002L%\u0019\u0011Q\n!\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005M\u0013\u0011\f\t\u0004\u007f\u0005U\u0013bAA,\u0001\n\u0019\u0011I\\=\t\u0013\u0005mc#!AA\u0002\u0005%\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002bA1\u00111MA5\u0003'j!!!\u001a\u000b\u0007\u0005\u001d\u0004)\u0001\u0006d_2dWm\u0019;j_:LA!a\u001b\u0002f\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\t(a\u001e\u0011\u0007}\n\u0019(C\u0002\u0002v\u0001\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0002\\a\t\t\u00111\u0001\u0002T\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t9$! \t\u0013\u0005m\u0013$!AA\u0002\u0005%\u0013AB3rk\u0006d7\u000f\u0006\u0003\u0002r\u0005\r\u0005\"CA.5\u0005\u0005\t\u0019AA*Q]\u0001\u0011qQAG\u0003\u001f\u000b\u0019*!&\u0002\u001a\u0006m\u0015qTAQ\u0003K\u000b9\u000bE\u00023\u0003\u0013K1!a#$\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!%\u0002A*\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015v]&$H\u0006I:uCJ$H\u0006I3oI&\u0002S\u0006I$fiN\u0004C\u000f[3!I&4g-\u001a:f]\u000e,\u0007EY3uo\u0016,g\u000e\t;iK\u0002\"\u0018.\\3tA%t\u0007\u0005\u001e5fAM\u0004XmY5gS\u0016$\u0007%\u001e8jiNt#\u0002\t\u0011\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018EAAL\u0003\tE\"\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011v]&$\b%\f\u0011uQ\u0016\u0004SO\\5uA=4\u0007\u0005\u001e5fA\u0011LgMZ3sK:\u001cW\r\t2fi^,WM\u001c\u0011uQ\u0016\u0004s-\u001b<f]\u0002\"\u0018.\\3t\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\f\u0011#\u0011>+&K\t\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j\u0003EI'J\u001dV#VI\t\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j\u0003EI*F\u0007>sEI\t\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j\u0003EI'J\u00192K5+R\"P\u001d\u0012\u0013#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011![\u0001\u0012S*S\"S\u001fN+5i\u0014(EE)\u0001\u0003\u0005\t\u0011!A)\u00023\u000f^1si\u0002j\u0003%\u0019\u0011ti\u0006\u0014H/\u001b8hAQKU*\u0012\u0011fqB\u0014Xm]:j_:T\u0001\u0005\t\u0011!A\u0001R\u0003%\u001a8eA5\u0002\u0013M\u001c\u0011f]\u0012Lgn\u001a\u0011U\u00136+\u0005%\u001a=qe\u0016\u001c8/[8o\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005u\u0015!!6\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001dBu*\u0016*(Y\u0001\"\u0016*T#(eAR4\u0007\r\u001e3s\u001db\u0003\u0005V%N\u000b\u001e\u0012\u0014GO\u001a1uIBt%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!a)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs\u0005S(V%\u001eb\u0003\u0005V%N\u000b\u001e\u0012\u0004GO\u001a1uIJt\u0005\f\u0011U\u00136+uEM\u0019;gAR$'O\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\n$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014I\u001fV\u0013v\u0005\f\u0011U\u00136+uE\r\u0019;gAR$'O\u0014-AQKU*R\u00142ei\u0002\u0004G\u000f\u00191O%Z$\u0002\t\u0011!A\u0001\u0002\u0003%\f\u001d\u000bA\u0001\nQa\u001a:pkB\f#!a)\u0002\u001d\u0011\fG/\u001a;j[\u0016|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012\u0011\u0011V\u0001\u0006i9\nd\u0006M\u0001\t)&lW\rR5gMB\u0011!\u0007H\n\u00069\u0005E\u0016Q\u0018\t\t\u0003g\u000bIL\u0015*S96\u0011\u0011Q\u0017\u0006\u0004\u0003o\u0003\u0015a\u0002:v]RLW.Z\u0005\u0005\u0003w\u000b)LA\tBEN$(/Y2u\rVt7\r^5p]N\u0002B!a0\u0002F6\u0011\u0011\u0011\u0019\u0006\u0005\u0003\u0007\fy$\u0001\u0002j_&\u0019a*!1\u0015\u0005\u00055\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005]\u0012!B1qa2LHc\u0002/\u0002R\u0006M\u0017Q\u001b\u0005\u0006!~\u0001\rA\u0015\u0005\u0006-~\u0001\rA\u0015\u0005\u00061~\u0001\rAU\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\tY.a:\u0011\u000b}\ni.!9\n\u0007\u0005}\u0007I\u0001\u0004PaRLwN\u001c\t\u0007\u007f\u0005\r(K\u0015*\n\u0007\u0005\u0015\bI\u0001\u0004UkBdWm\r\u0005\t\u0003S\u0004\u0013\u0011!a\u00019\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005=\b\u0003BA\u001d\u0003cLA!a=\u0002<\t1qJ\u00196fGR\u0004")
public class TimeDiff
extends TernaryExpression
implements RuntimeReplaceable,
ImplicitCastInputTypes,
TimeExpression,
Serializable {
    private final Expression unit;
    private final Expression start;
    private final Expression end;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(TimeDiff x$0) {
        return TimeDiff$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, TimeDiff> tupled() {
        return TimeDiff$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, TimeDiff>>> curried() {
        return TimeDiff$.MODULE$.curried();
    }

    @Override
    public /* synthetic */ TypeCheckResult org$apache$spark$sql$catalyst$expressions$TimeExpression$$super$checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return TimeExpression.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        TimeDiff timeDiff = this;
        synchronized (timeDiff) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if (!this.bitmap$0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression unit() {
        return this.unit;
    }

    public Expression start() {
        return this.start;
    }

    public Expression end() {
        return this.end;
    }

    @Override
    public Expression first() {
        return this.unit();
    }

    @Override
    public Expression second() {
        return this.start();
    }

    @Override
    public Expression third() {
        return this.end();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)new .colon.colon((Object)AnyTimeType$.MODULE$, (List)new .colon.colon((Object)AnyTimeType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "time_diff";
    }

    @Override
    public TimeDiff withNewChildrenInternal(Expression newUnit, Expression newStart, Expression newEnd) {
        return this.copy(newUnit, newStart, newEnd);
    }

    @Override
    public Expression replacement() {
        return new StaticInvoke(DateTimeUtils$.class, this.dataType(), "timeDiff", (Seq<Expression>)new .colon.colon((Object)this.unit(), (List)new .colon.colon((Object)this.start(), (List)new .colon.colon((Object)this.end(), (List)Nil$.MODULE$))), (Seq<AbstractDataType>)new .colon.colon((Object)this.unit().dataType(), (List)new .colon.colon((Object)this.start().dataType(), (List)new .colon.colon((Object)this.end().dataType(), (List)Nil$.MODULE$))), StaticInvoke$.MODULE$.apply$default$6(), StaticInvoke$.MODULE$.apply$default$7(), StaticInvoke$.MODULE$.apply$default$8(), StaticInvoke$.MODULE$.apply$default$9());
    }

    public TimeDiff copy(Expression unit, Expression start, Expression end) {
        return new TimeDiff(unit, start, end);
    }

    public Expression copy$default$1() {
        return this.unit();
    }

    public Expression copy$default$2() {
        return this.start();
    }

    public Expression copy$default$3() {
        return this.end();
    }

    @Override
    public String productPrefix() {
        return "TimeDiff";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.unit();
            }
            case 1: {
                return this.start();
            }
            case 2: {
                return this.end();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TimeDiff;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "unit";
            }
            case 1: {
                return "start";
            }
            case 2: {
                return "end";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TimeDiff)) return false;
        boolean bl = true;
        if (!bl) return false;
        TimeDiff timeDiff = (TimeDiff)x$1;
        Expression expression = this.unit();
        Expression expression2 = timeDiff.unit();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.start();
        Expression expression4 = timeDiff.start();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.end();
        Expression expression6 = timeDiff.end();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!timeDiff.canEqual(this)) return false;
        return true;
    }

    public TimeDiff(Expression unit, Expression start, Expression end) {
        this.unit = unit;
        this.start = start;
        this.end = end;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
        TimeExpression.$init$(this);
        Statics.releaseFence();
    }
}

