/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.clustering.GaussianMixtureModel$;
import org.apache.spark.ml.clustering.GaussianMixtureModel$GaussianMixtureModelReader$;
import org.apache.spark.ml.clustering.GaussianMixtureModel$GaussianMixtureModelWriter$;
import org.apache.spark.ml.clustering.GaussianMixtureParams;
import org.apache.spark.ml.clustering.GaussianMixtureSummary;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.param.shared.HasProbabilityCol;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.stat.distribution.MultivariateGaussian;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.HasTrainingSummary;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.ReadWriteUtils$;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.SizeEstimator$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.hashing.MurmurHash3$;

@ScalaSignature(bytes="\u0006\u0005\r\u0005h\u0001\u0002%J\u0001QC\u0001B\u001b\u0001\u0003\u0006\u0004%\te\u001b\u0005\n\u0003\u000b\u0001!\u0011!Q\u0001\n1D!\"!\u0003\u0001\u0005\u000b\u0007I\u0011AA\u0006\u0011)\ti\u0002\u0001B\u0001B\u0003%\u0011Q\u0002\u0005\u000b\u0003C\u0001!Q1A\u0005\u0002\u0005\r\u0002BCA\u001d\u0001\t\u0005\t\u0015!\u0003\u0002&!A\u0011Q\b\u0001\u0005\u0002-\u000by\u0004\u0003\u0005\u0002>\u0001!\taSA'\u0011)\ty\u0005\u0001EC\u0002\u0013\u0005\u0011\u0011\u000b\u0005\b\u0003?\u0002A\u0011AA1\u0011\u001d\ty\u0007\u0001C\u0001\u0003cBq!a\u001e\u0001\t\u0003\tI\bC\u0004\u0002\u0000\u0001!\t%!!\t\u000f\u0005U\u0005\u0001\"\u0011\u0002\u0018\"9\u0011\u0011\u001d\u0001\u0005B\u0005\r\bbBA|\u0001\u0011\u0005\u0011\u0011 \u0005\b\u0005\u001b\u0001A\u0011\u0001B\b\u0011\u001d\u0011)\u0002\u0001C\u0001\u0005/AqAa\u0007\u0001\t\u0003\u0012i\u0002C\u0004\u0003(\u0001!\tE!\u000b\t\u000f\t5\u0002\u0001\"\u0011\u00030!A!1\u0007\u0001\u0005B5\u0013)\u0004\u0003\u0005\u0003>\u0001!\t!\u0014B \u0011!\u0011\u0019\u0006\u0001C!\u001b\nU\u0003\u0002\u0003B.\u0001\u0011\u0005SJ!\u0018\b\u000f\t\u0015\u0014\n#\u0001\u0003h\u00191\u0001*\u0013E\u0001\u0005SBq!!\u0010\u001c\t\u0003\u00119IB\u0004\u0003\nn\u00015Ja#\t\u0015\u0005%QD!f\u0001\n\u0003\tY\u0001\u0003\u0006\u0002\u001eu\u0011\t\u0012)A\u0005\u0003\u001bA!B!)\u001e\u0005+\u0007I\u0011\u0001BR\u0011)\u0011\u0019,\bB\tB\u0003%!Q\u0015\u0005\u000b\u0005kk\"Q3A\u0005\u0002\t]\u0006B\u0003Ba;\tE\t\u0015!\u0003\u0003:\"9\u0011QH\u000f\u0005\u0002\t\r\u0007\"CA@;\u0005\u0005I\u0011\u0001Bh\u0011%\u00119.HI\u0001\n\u0003\u0011I\u000eC\u0005\u0003nv\t\n\u0011\"\u0001\u0003p\"I!1_\u000f\u0012\u0002\u0013\u0005!Q\u001f\u0005\n\u0005sl\u0012\u0011!C!\u0005wD\u0011ba\u0002\u001e\u0003\u0003%\t!!\u0015\t\u0013\r%Q$!A\u0005\u0002\r-\u0001\"CB\t;\u0005\u0005I\u0011IB\n\u0011%\u0019\t#HA\u0001\n\u0003\u0019\u0019\u0003C\u0005\u0004.u\t\t\u0011\"\u0011\u00040!I11G\u000f\u0002\u0002\u0013\u00053Q\u0007\u0005\n\u0005Oi\u0012\u0011!C!\u0007oA\u0011b!\u000f\u001e\u0003\u0003%\tea\u000f\b\u0015\r}2$!A\t\u0002-\u001b\tE\u0002\u0006\u0003\nn\t\t\u0011#\u0001L\u0007\u0007Bq!!\u00104\t\u0003\u0019\t\u0006C\u0005\u0003(M\n\t\u0011\"\u0012\u00048!I11K\u001a\u0002\u0002\u0013\u00055Q\u000b\u0005\n\u0007;\u001a\u0014\u0011!CA\u0007?B\u0011b!\u001d4\u0003\u0003%Iaa\u001d\t\u0011\rm4\u0004\"\u0001L\u0007{B\u0001b!$\u001c\t\u0003Y5q\u0012\u0005\b\u00077[B\u0011IBO\u0011\u001d\u00199k\u0007C!\u0007S3qaa,\u001c\u0001m\u0019\t\fC\u0005\u00044v\u0012\t\u0011)A\u00053\"9\u0011QH\u001f\u0005\u0002\rU\u0006bBB^{\u0011E3Q\u0018\u0004\u0007\u0007\u0003\\Baa1\t\u000f\u0005u\u0012\t\"\u0001\u0004F\"I1\u0011Z!C\u0002\u0013%!1 \u0005\t\u0007\u0017\f\u0005\u0015!\u0003\u0003~\"91qU!\u0005B\r5\u0007\u0002CBi7\u0011\u0005\u0011ja5\t\u0013\rE4$!A\u0005\n\rM$\u0001F$bkN\u001c\u0018.\u00198NSb$XO]3N_\u0012,GN\u0003\u0002K\u0017\u0006Q1\r\\;ti\u0016\u0014\u0018N\\4\u000b\u00051k\u0015AA7m\u0015\tqu*A\u0003ta\u0006\u00148N\u0003\u0002Q#\u00061\u0011\r]1dQ\u0016T\u0011AU\u0001\u0004_J<7\u0001A\n\u0006\u0001U[f\f\u001a\t\u0004-^KV\"A&\n\u0005a[%!B'pI\u0016d\u0007C\u0001.\u0001\u001b\u0005I\u0005C\u0001.]\u0013\ti\u0016JA\u000bHCV\u001c8/[1o\u001b&DH/\u001e:f!\u0006\u0014\u0018-\\:\u0011\u0005}\u0013W\"\u00011\u000b\u0005\u0005\\\u0015\u0001B;uS2L!a\u00191\u0003\u00155cuK]5uC\ndW\rE\u0002`K\u001eL!A\u001a1\u0003%!\u000b7\u000f\u0016:bS:LgnZ*v[6\f'/\u001f\t\u00035\"L!![%\u0003-\u001d\u000bWo]:jC:l\u0015\u000e\u001f;ve\u0016\u001cV/\\7bef\f1!^5e+\u0005a\u0007CA7w\u001d\tqG\u000f\u0005\u0002pe6\t\u0001O\u0003\u0002r'\u00061AH]8pizR\u0011a]\u0001\u0006g\u000e\fG.Y\u0005\u0003kJ\fa\u0001\u0015:fI\u00164\u0017BA<y\u0005\u0019\u0019FO]5oO*\u0011QO\u001d\u0015\u0005\u0003i\f\t\u0001\u0005\u0002|}6\tAP\u0003\u0002~\u001b\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005}d(!B*j]\u000e,\u0017EAA\u0002\u0003\u0015\u0011d\u0006\r\u00181\u0003\u0011)\u0018\u000e\u001a\u0011)\t\tQ\u0018\u0011A\u0001\bo\u0016Lw\r\u001b;t+\t\ti\u0001\u0005\u0004\u0002\u0010\u0005E\u0011QC\u0007\u0002e&\u0019\u00111\u0003:\u0003\u000b\u0005\u0013(/Y=\u0011\t\u0005=\u0011qC\u0005\u0004\u00033\u0011(A\u0002#pk\ndW\r\u000b\u0003\u0004u\u0006\u0005\u0011\u0001C<fS\u001eDGo\u001d\u0011)\t\u0011Q\u0018\u0011A\u0001\nO\u0006,8o]5b]N,\"!!\n\u0011\r\u0005=\u0011\u0011CA\u0014!\u0011\tI#a\r\u000e\u0005\u0005-\"\u0002BA\u0017\u0003_\tA\u0002Z5tiJL'-\u001e;j_:T1!!\rL\u0003\u0011\u0019H/\u0019;\n\t\u0005U\u00121\u0006\u0002\u0015\u001bVdG/\u001b<be&\fG/Z$bkN\u001c\u0018.\u00198)\t\u0015Q\u0018\u0011A\u0001\u000bO\u0006,8o]5b]N\u0004\u0003\u0006\u0002\u0004{\u0003\u0003\ta\u0001P5oSRtDcB-\u0002B\u0005\u0015\u0013\u0011\n\u0005\u0006U\u001e\u0001\r\u0001\u001c\u0015\u0006\u0003\u0003R\u0018\u0011\u0001\u0005\b\u0003\u00139\u0001\u0019AA\u0007Q\u0015\t)E_A\u0001\u0011\u001d\t\tc\u0002a\u0001\u0003KAS!!\u0013{\u0003\u0003!\u0012!W\u0001\f]Vlg)Z1ukJ,7/\u0006\u0002\u0002TA!\u0011qBA+\u0013\r\t9F\u001d\u0002\u0004\u0013:$\b\u0006B\u0005{\u00037\n#!!\u0018\u0002\u000bMr\u0003G\f\u0019\u0002\u001dM,GOR3biV\u0014Xm]\"pYR!\u00111MA3\u001b\u0005\u0001\u0001BBA4\u0015\u0001\u0007A.A\u0003wC2,X\r\u000b\u0003\u000bu\u0006-\u0014EAA7\u0003\u0015\u0011d&\r\u00181\u0003A\u0019X\r\u001e)sK\u0012L7\r^5p]\u000e{G\u000e\u0006\u0003\u0002d\u0005M\u0004BBA4\u0017\u0001\u0007A\u000e\u000b\u0003\fu\u0006-\u0014!E:fiB\u0013xNY1cS2LG/_\"pYR!\u00111MA>\u0011\u0019\t9\u0007\u0004a\u0001Y\"\"AB_A6\u0003\u0011\u0019w\u000e]=\u0015\u0007e\u000b\u0019\tC\u0004\u0002\u00066\u0001\r!a\"\u0002\u000b\u0015DHO]1\u0011\t\u0005%\u0015qR\u0007\u0003\u0003\u0017S1!!$L\u0003\u0015\u0001\u0018M]1n\u0013\u0011\t\t*a#\u0003\u0011A\u000b'/Y7NCBDC!\u0004>\u0002\u0002\u0005IAO]1og\u001a|'/\u001c\u000b\u0005\u00033\u000bY\f\u0005\u0003\u0002\u001c\u0006Uf\u0002BAO\u0003_sA!a(\u0002,:!\u0011\u0011UAU\u001d\u0011\t\u0019+a*\u000f\u0007=\f)+C\u0001S\u0013\t\u0001\u0016+\u0003\u0002O\u001f&\u0019\u0011QV'\u0002\u0007M\fH.\u0003\u0003\u00022\u0006M\u0016a\u00029bG.\fw-\u001a\u0006\u0004\u0003[k\u0015\u0002BA\\\u0003s\u0013\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\t\u0005E\u00161\u0017\u0005\b\u0003{s\u0001\u0019AA`\u0003\u001d!\u0017\r^1tKR\u0004D!!1\u0002NB1\u00111YAc\u0003\u0013l!!a-\n\t\u0005\u001d\u00171\u0017\u0002\b\t\u0006$\u0018m]3u!\u0011\tY-!4\r\u0001\u0011a\u0011qZA^\u0003\u0003\u0005\tQ!\u0001\u0002R\n\u0019q\fJ\u0019\u0012\t\u0005M\u0017\u0011\u001c\t\u0005\u0003\u001f\t).C\u0002\u0002XJ\u0014qAT8uQ&tw\r\u0005\u0003\u0002\u0010\u0005m\u0017bAAoe\n\u0019\u0011I\\=)\t9Q\u0018\u0011A\u0001\u0010iJ\fgn\u001d4pe6\u001c6\r[3nCR!\u0011Q]Ay!\u0011\t9/!<\u000e\u0005\u0005%(\u0002BAv\u0003g\u000bQ\u0001^=qKNLA!a<\u0002j\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000f\u0005Mx\u00021\u0001\u0002f\u000611o\u00195f[\u0006DCa\u0004>\u0002\u0002\u00059\u0001O]3eS\u000e$H\u0003BA*\u0003wDq!!@\u0011\u0001\u0004\ty0\u0001\u0005gK\u0006$XO]3t!\u0011\u0011\tAa\u0002\u000e\u0005\t\r!b\u0001B\u0003\u0017\u00061A.\u001b8bY\u001eLAA!\u0003\u0003\u0004\t1a+Z2u_JDC\u0001\u0005>\u0002\\\u0005\u0011\u0002O]3eS\u000e$\bK]8cC\nLG.\u001b;z)\u0011\tyP!\u0005\t\u000f\u0005u\u0018\u00031\u0001\u0002\u0000\"\"\u0011C_A.\u0003-9\u0017-^:tS\u0006t7\u000f\u0012$\u0016\u0005\u0005e\u0005\u0006\u0002\n{\u0003\u0003\tQa\u001e:ji\u0016,\"Aa\b\u0011\u0007}\u0013\t#C\u0002\u0003$\u0001\u0014\u0001\"\u0014'Xe&$XM\u001d\u0015\u0005'i\f\t!\u0001\u0005u_N#(/\u001b8h)\u0005a\u0007\u0006\u0002\u000b{\u00037\nqa];n[\u0006\u0014\u00180F\u0001hQ\u0011)\"0!\u0001\u0002\u001b\u0015\u001cH/[7bi\u0016$7+\u001b>f+\t\u00119\u0004\u0005\u0003\u0002\u0010\te\u0012b\u0001B\u001ee\n!Aj\u001c8h\u00035\u0019'/Z1uKN+X.\\1ssRA!\u0011\tB$\u0005\u0017\u0012y\u0005\u0005\u0003\u0002\u0010\t\r\u0013b\u0001B#e\n!QK\\5u\u0011\u001d\u0011Ie\u0006a\u0001\u00033\u000b1\u0002\u001d:fI&\u001cG/[8og\"9!QJ\fA\u0002\u0005U\u0011!\u00047pO2K7.\u001a7jQ>|G\rC\u0004\u0003R]\u0001\r!a\u0015\u0002\u0013%$XM]1uS>t\u0017aC:bm\u0016\u001cV/\\7bef$BA!\u0011\u0003X!1!\u0011\f\rA\u00021\fA\u0001]1uQ\u0006YAn\\1e'VlW.\u0019:z)\u0019\u0011\tEa\u0018\u0003b!1!\u0011L\rA\u00021Dq!!0\u001a\u0001\u0004\tI\n\u000b\u0003\u0001u\u0006\u0005\u0011\u0001F$bkN\u001c\u0018.\u00198NSb$XO]3N_\u0012,G\u000e\u0005\u0002[7M91Da\u001b\u0003r\t]\u0004\u0003BA\b\u0005[J1Aa\u001cs\u0005\u0019\te.\u001f*fMB!qLa\u001dZ\u0013\r\u0011)\b\u0019\u0002\u000b\u001b2\u0013V-\u00193bE2,\u0007\u0003\u0002B=\u0005\u0007k!Aa\u001f\u000b\t\tu$qP\u0001\u0003S>T!A!!\u0002\t)\fg/Y\u0005\u0005\u0005\u000b\u0013YH\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0003h\t!A)\u0019;b'\u001di\"1\u000eBG\u0005'\u0003B!a\u0004\u0003\u0010&\u0019!\u0011\u0013:\u0003\u000fA\u0013x\u000eZ;diB!!Q\u0013BO\u001d\u0011\u00119Ja'\u000f\u0007=\u0014I*C\u0001t\u0013\r\t\tL]\u0005\u0005\u0005\u000b\u0013yJC\u0002\u00022J\f1!\\;t+\t\u0011)\u000b\u0005\u0004\u0002\u0010\u0005E!q\u0015\t\u0005\u0005S\u0013\t,\u0004\u0002\u0003,*!!Q\u0001BW\u0015\r\u0011y+T\u0001\u0006[2d\u0017NY\u0005\u0005\u0005\u0013\u0011Y+\u0001\u0003nkN\u0004\u0013AB:jO6\f7/\u0006\u0002\u0003:B1\u0011qBA\t\u0005w\u0003BA!+\u0003>&!!q\u0018BV\u0005\u0019i\u0015\r\u001e:jq\u000691/[4nCN\u0004C\u0003\u0003Bc\u0005\u0013\u0014YM!4\u0011\u0007\t\u001dW$D\u0001\u001c\u0011\u001d\tI\u0001\na\u0001\u0003\u001bAqA!)%\u0001\u0004\u0011)\u000bC\u0004\u00036\u0012\u0002\rA!/\u0015\u0011\t\u0015'\u0011\u001bBj\u0005+D\u0011\"!\u0003&!\u0003\u0005\r!!\u0004\t\u0013\t\u0005V\u0005%AA\u0002\t\u0015\u0006\"\u0003B[KA\u0005\t\u0019\u0001B]\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"Aa7+\t\u00055!Q\\\u0016\u0003\u0005?\u0004BA!9\u0003j6\u0011!1\u001d\u0006\u0005\u0005K\u00149/A\u0005v]\u000eDWmY6fI*\u0011QP]\u0005\u0005\u0005W\u0014\u0019OA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003r*\"!Q\u0015Bo\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"Aa>+\t\te&Q\\\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\tu\b\u0003\u0002B\u0000\u0007\u000bi!a!\u0001\u000b\t\r\r!qP\u0001\u0005Y\u0006tw-C\u0002x\u0007\u0003\tA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002Z\u000e5\u0001\"CB\bW\u0005\u0005\t\u0019AA*\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u00111Q\u0003\t\u0007\u0007/\u0019i\"!7\u000e\u0005\re!bAB\u000ee\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\r}1\u0011\u0004\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0004&\r-\u0002\u0003BA\b\u0007OI1a!\u000bs\u0005\u001d\u0011un\u001c7fC:D\u0011ba\u0004.\u0003\u0003\u0005\r!!7\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0005{\u001c\t\u0004C\u0005\u0004\u00109\n\t\u00111\u0001\u0002T\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002TQ\u0011!Q`\u0001\u0007KF,\u0018\r\\:\u0015\t\r\u00152Q\b\u0005\n\u0007\u001f\t\u0014\u0011!a\u0001\u00033\fA\u0001R1uCB\u0019!qY\u001a\u0014\u000bM\u001a)Ea\u001e\u0011\u0019\r\u001d3QJA\u0007\u0005K\u0013IL!2\u000e\u0005\r%#bAB&e\u00069!/\u001e8uS6,\u0017\u0002BB(\u0007\u0013\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84)\t\u0019\t%A\u0003baBd\u0017\u0010\u0006\u0005\u0003F\u000e]3\u0011LB.\u0011\u001d\tIA\u000ea\u0001\u0003\u001bAqA!)7\u0001\u0004\u0011)\u000bC\u0004\u00036Z\u0002\rA!/\u0002\u000fUt\u0017\r\u001d9msR!1\u0011MB7!\u0019\tyaa\u0019\u0004h%\u00191Q\r:\u0003\r=\u0003H/[8o!)\tya!\u001b\u0002\u000e\t\u0015&\u0011X\u0005\u0004\u0007W\u0012(A\u0002+va2,7\u0007C\u0005\u0004p]\n\t\u00111\u0001\u0003F\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\rU\u0004\u0003\u0002B\u0000\u0007oJAa!\u001f\u0004\u0002\t1qJ\u00196fGR\fQb]3sS\u0006d\u0017N_3ECR\fGC\u0002B!\u0007\u007f\u001a\u0019\tC\u0004\u0004\u0002f\u0002\rA!2\u0002\t\u0011\fG/\u0019\u0005\b\u0007\u000bK\u0004\u0019ABD\u0003\r!wn\u001d\t\u0005\u0005s\u001aI)\u0003\u0003\u0004\f\nm$\u0001\u0005#bi\u0006|U\u000f\u001e9viN#(/Z1n\u0003=!Wm]3sS\u0006d\u0017N_3ECR\fG\u0003\u0002Bc\u0007#Cqaa%;\u0001\u0004\u0019)*A\u0002eSN\u0004BA!\u001f\u0004\u0018&!1\u0011\u0014B>\u0005=!\u0015\r^1J]B,Ho\u0015;sK\u0006l\u0017\u0001\u0002:fC\u0012,\"aa(\u0011\t}\u001b\t+W\u0005\u0004\u0007G\u0003'\u0001C'M%\u0016\fG-\u001a:)\tmR\u0018\u0011A\u0001\u0005Y>\fG\rF\u0002Z\u0007WCaA!\u0017=\u0001\u0004a\u0007\u0006\u0002\u001f{\u0003\u0003\u0011!dR1vgNL\u0017M\\'jqR,(/Z'pI\u0016dwK]5uKJ\u001c2!\u0010B\u0010\u0003!Ign\u001d;b]\u000e,G\u0003BB\\\u0007s\u00032Aa2>\u0011\u0019\u0019\u0019l\u0010a\u00013\u0006A1/\u0019<f\u00136\u0004H\u000e\u0006\u0003\u0003B\r}\u0006B\u0002B-\u0001\u0002\u0007AN\u0001\u000eHCV\u001c8/[1o\u001b&DH/\u001e:f\u001b>$W\r\u001c*fC\u0012,'oE\u0002B\u0007?#\"aa2\u0011\u0007\t\u001d\u0017)A\u0005dY\u0006\u001c8OT1nK\u0006Q1\r\\1tg:\u000bW.\u001a\u0011\u0015\u0007e\u001by\r\u0003\u0004\u0003Z\u0015\u0003\r\u0001\\\u0001\u0015G>l\u0007/\u001e;f!J|'-\u00192jY&$\u0018.Z:\u0015\u0011\u000551Q[Bl\u00077Dq!!@G\u0001\u0004\ty\u0010C\u0004\u0004Z\u001a\u0003\r!!\n\u0002\u000b\u0011L7\u000f^:\t\u000f\u0005%a\t1\u0001\u0002\u000e!\"1D_A\u0001Q\u0011Q\"0!\u0001")
public class GaussianMixtureModel
extends Model<GaussianMixtureModel>
implements GaussianMixtureParams,
MLWritable,
HasTrainingSummary<GaussianMixtureSummary> {
    private int numFeatures;
    private final String uid;
    private final double[] weights;
    private final MultivariateGaussian[] gaussians;
    private Option<GaussianMixtureSummary> trainingSummary;
    private IntParam k;
    private IntParam aggregationDepth;
    private DoubleParam tol;
    private Param<String> probabilityCol;
    private Param<String> weightCol;
    private Param<String> predictionCol;
    private LongParam seed;
    private Param<String> featuresCol;
    private IntParam maxIter;
    private volatile boolean bitmap$0;

    public static GaussianMixtureModel load(String path) {
        return GaussianMixtureModel$.MODULE$.load(path);
    }

    public static MLReader<GaussianMixtureModel> read() {
        return GaussianMixtureModel$.MODULE$.read();
    }

    @Override
    public boolean hasSummary() {
        return HasTrainingSummary.hasSummary$(this);
    }

    @Override
    public HasTrainingSummary<GaussianMixtureSummary> setSummary(Option<GaussianMixtureSummary> summary) {
        return HasTrainingSummary.setSummary$(this, summary);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public int getK() {
        return GaussianMixtureParams.getK$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return GaussianMixtureParams.validateAndTransformSchema$(this, schema);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final String getProbabilityCol() {
        return HasProbabilityCol.getProbabilityCol$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol.getFeaturesCol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final Option<GaussianMixtureSummary> trainingSummary() {
        return this.trainingSummary;
    }

    @Override
    public final void trainingSummary_$eq(Option<GaussianMixtureSummary> x$1) {
        this.trainingSummary = x$1;
    }

    @Override
    public final IntParam k() {
        return this.k;
    }

    @Override
    public final void org$apache$spark$ml$clustering$GaussianMixtureParams$_setter_$k_$eq(IntParam x$1) {
        this.k = x$1;
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final Param<String> probabilityCol() {
        return this.probabilityCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasProbabilityCol$_setter_$probabilityCol_$eq(Param<String> x$1) {
        this.probabilityCol = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param<String> x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public double[] weights() {
        return this.weights;
    }

    public MultivariateGaussian[] gaussians() {
        return this.gaussians;
    }

    private int numFeatures$lzycompute() {
        GaussianMixtureModel gaussianMixtureModel = this;
        synchronized (gaussianMixtureModel) {
            if (!this.bitmap$0) {
                this.numFeatures = ((MultivariateGaussian)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])this.gaussians()))).mean().size();
                this.bitmap$0 = true;
            }
        }
        return this.numFeatures;
    }

    public int numFeatures() {
        if (!this.bitmap$0) {
            return this.numFeatures$lzycompute();
        }
        return this.numFeatures;
    }

    public GaussianMixtureModel setFeaturesCol(String value) {
        return (GaussianMixtureModel)this.set(this.featuresCol(), value);
    }

    public GaussianMixtureModel setPredictionCol(String value) {
        return (GaussianMixtureModel)this.set(this.predictionCol(), value);
    }

    public GaussianMixtureModel setProbabilityCol(String value) {
        return (GaussianMixtureModel)this.set(this.probabilityCol(), value);
    }

    @Override
    public GaussianMixtureModel copy(ParamMap extra) {
        GaussianMixtureModel copied = this.copyValues(new GaussianMixtureModel(this.uid(), this.weights(), this.gaussians()), extra);
        return (GaussianMixtureModel)((Model)((Object)copied.setSummary(this.trainingSummary()))).setParent(this.parent());
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        Dataset outputData;
        block4: {
            StructType outputSchema = this.transformSchema(dataset.schema(), true);
            Column vectorCol = DatasetUtils$.MODULE$.columnToVector(dataset, this.$(this.featuresCol()));
            outputData = dataset;
            int numColsOutput = 0;
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.probabilityCol())))) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModel.class.getClassLoader());
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModel.class.getClassLoader());
                public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$1(GaussianMixtureModel $outer) {
                    }
                }
                public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator2$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator2$1(GaussianMixtureModel $outer) {
                    }
                }
                UserDefinedFunction probUDF = functions$.MODULE$.udf((Function1 & Serializable)vector -> this.predictProbability((org.apache.spark.ml.linalg.Vector)vector), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator2$1(null)));
                outputData = outputData.withColumn(this.$(this.probabilityCol()), probUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{vectorCol})), outputSchema.apply(this.$(this.probabilityCol())).metadata());
                ++numColsOutput;
            }
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.predictionCol())))) {
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.probabilityCol())))) {
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModel.class.getClassLoader());
                    public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator3$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                        }

                        public Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator3$1(GaussianMixtureModel $outer) {
                        }
                    }
                    UserDefinedFunction predUDF = functions$.MODULE$.udf((Function1 & Serializable)vector -> BoxesRunTime.boxToInteger((int)vector.argmax()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator3$1(null)));
                    outputData = outputData.withColumn(this.$(this.predictionCol()), predUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.probabilityCol()))})), outputSchema.apply(this.$(this.predictionCol())).metadata());
                } else {
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModel.class.getClassLoader());
                    public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator4$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                        }

                        public Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator4$1(GaussianMixtureModel $outer) {
                        }
                    }
                    UserDefinedFunction predUDF = functions$.MODULE$.udf((Function1 & Serializable)vector -> BoxesRunTime.boxToInteger((int)this.predict(vector)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator4$1(null)));
                    outputData = outputData.withColumn(this.$(this.predictionCol()), predUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{vectorCol})), outputSchema.apply(this.$(this.predictionCol())).metadata());
                }
                ++numColsOutput;
            }
            if (numColsOutput != false) break block4;
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ": GaussianMixtureModel.transform() does "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.UUID, this.uid())})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"nothing because no output columns were set."}))).log((Seq)Nil$.MODULE$))));
        }
        return outputData.toDF();
    }

    @Override
    public StructType transformSchema(StructType schema) {
        StructType outputSchema;
        block1: {
            outputSchema = this.validateAndTransformSchema(schema);
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.predictionCol())))) {
                outputSchema = SchemaUtils$.MODULE$.updateNumValues(outputSchema, this.$(this.predictionCol()), this.weights().length);
            }
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.probabilityCol())))) break block1;
            outputSchema = SchemaUtils$.MODULE$.updateAttributeGroupSize(outputSchema, this.$(this.probabilityCol()), this.weights().length);
        }
        return outputSchema;
    }

    public int predict(org.apache.spark.ml.linalg.Vector features) {
        org.apache.spark.ml.linalg.Vector r = this.predictProbability(features);
        return r.argmax();
    }

    public org.apache.spark.ml.linalg.Vector predictProbability(org.apache.spark.ml.linalg.Vector features) {
        double[] probs = GaussianMixtureModel$.MODULE$.computeProbabilities(features, this.gaussians(), this.weights());
        return org.apache.spark.ml.linalg.Vectors$.MODULE$.dense(probs);
    }

    public Dataset<Row> gaussiansDF() {
        ArraySeq modelGaussians = ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.gaussians()), (Function1 & Serializable)gaussian -> new Tuple2((Object)Vectors$.MODULE$.fromML(gaussian.mean()), (Object)Matrices$.MODULE$.fromML(gaussian.cov())), ClassTag$.MODULE$.apply(Tuple2.class))).toImmutableArraySeq();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModel.class.getClassLoader());
        public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.mllib.linalg.Vector").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.mllib.linalg.Matrix").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$2(GaussianMixtureModel $outer) {
            }
        }
        return SparkSession$.MODULE$.builder().getOrCreate().createDataFrame((Seq)modelGaussians, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$2(null))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"mean", "cov"}));
    }

    @Override
    public MLWriter write() {
        return new GaussianMixtureModelWriter(this);
    }

    @Override
    public String toString() {
        return "GaussianMixtureModel: uid=" + this.uid() + ", k=" + this.weights().length + ", numFeatures=" + this.numFeatures();
    }

    @Override
    public GaussianMixtureSummary summary() {
        return (GaussianMixtureSummary)HasTrainingSummary.summary$(this);
    }

    @Override
    public long estimatedSize() {
        return SizeEstimator$.MODULE$.estimate((Object)new Tuple2((Object)this.weights(), (Object)this.gaussians()));
    }

    public void createSummary(Dataset<Row> predictions, double logLikelihood, int iteration) {
        GaussianMixtureSummary summary = new GaussianMixtureSummary(predictions, this.$(this.predictionCol()), this.$(this.probabilityCol()), this.$(this.featuresCol()), BoxesRunTime.unboxToInt((Object)this.$(this.k())), logLikelihood, iteration);
        this.setSummary((Option<GaussianMixtureSummary>)new Some((Object)summary));
    }

    @Override
    public void saveSummary(String path) {
        public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$3
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$3(GaussianMixtureModel $outer) {
            }
        }
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModel.class.getClassLoader());
        ReadWriteUtils$.MODULE$.saveObjectToLocal(path, new Tuple2.mcDI.sp(this.summary().logLikelihood(), this.summary().numIter()), (Function2 & Serializable)(data, dos) -> {
            GaussianMixtureModel.$anonfun$saveSummary$1(data, dos);
            return BoxedUnit.UNIT;
        }, ClassTag$.MODULE$.apply(Tuple2.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$3(null)));
    }

    @Override
    public void loadSummary(String path, Dataset<Row> dataset) {
        double d;
        int numIter;
        block3: {
            Tuple2 tuple2;
            block2: {
                public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$4
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$4(GaussianMixtureModel $outer) {
                    }
                }
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModel.class.getClassLoader());
                tuple2 = (Tuple2)ReadWriteUtils$.MODULE$.loadObjectFromLocal(path, (Function1 & Serializable)dis -> {
                    double logLikelihood = dis.readDouble();
                    int numIter = dis.readInt();
                    return new Tuple2.mcDI.sp(logLikelihood, numIter);
                }, ClassTag$.MODULE$.apply(Tuple2.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$4(null)));
                if (tuple2 == null) break block2;
                double logLikelihood = tuple2._1$mcD$sp();
                numIter = tuple2._2$mcI$sp();
                if (!true) break block2;
                d = logLikelihood;
                if (true) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        int n = numIter;
        Tuple2.mcDI.sp sp2 = new Tuple2.mcDI.sp(d, n);
        double logLikelihood = sp2._1$mcD$sp();
        int numIter2 = sp2._2$mcI$sp();
        this.createSummary(dataset, logLikelihood, numIter2);
    }

    public static final /* synthetic */ void $anonfun$saveSummary$1(Tuple2 data, DataOutputStream dos) {
        dos.writeDouble(data._1$mcD$sp());
        dos.writeInt(data._2$mcI$sp());
    }

    public GaussianMixtureModel(String uid, double[] weights, MultivariateGaussian[] gaussians) {
        this.uid = uid;
        this.weights = weights;
        this.gaussians = gaussians;
        HasMaxIter.$init$(this);
        HasFeaturesCol.$init$(this);
        HasSeed.$init$(this);
        HasPredictionCol.$init$(this);
        HasWeightCol.$init$(this);
        HasProbabilityCol.$init$(this);
        HasTol.$init$(this);
        HasAggregationDepth.$init$(this);
        GaussianMixtureParams.$init$(this);
        MLWritable.$init$(this);
        HasTrainingSummary.$init$(this);
        Statics.releaseFence();
    }

    public GaussianMixtureModel() {
        this("", Array$.MODULE$.emptyDoubleArray(), (MultivariateGaussian[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(MultivariateGaussian.class)));
    }

    public static class Data
    implements Product,
    Serializable {
        private final double[] weights;
        private final Vector[] mus;
        private final Matrix[] sigmas;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public double[] weights() {
            return this.weights;
        }

        public Vector[] mus() {
            return this.mus;
        }

        public Matrix[] sigmas() {
            return this.sigmas;
        }

        public Data copy(double[] weights, Vector[] mus, Matrix[] sigmas) {
            return new Data(weights, mus, sigmas);
        }

        public double[] copy$default$1() {
            return this.weights();
        }

        public Vector[] copy$default$2() {
            return this.mus();
        }

        public Matrix[] copy$default$3() {
            return this.sigmas();
        }

        public String productPrefix() {
            return "Data";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.weights();
                }
                case 1: {
                    return this.mus();
                }
                case 2: {
                    return this.sigmas();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Data;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "weights";
                }
                case 1: {
                    return "mus";
                }
                case 2: {
                    return "sigmas";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 45109845, true);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Data)) return false;
            boolean bl = true;
            if (!bl) return false;
            Data data = (Data)x$1;
            if (this.weights() != data.weights()) return false;
            if (this.mus() != data.mus()) return false;
            if (this.sigmas() != data.sigmas()) return false;
            if (!data.canEqual(this)) return false;
            return true;
        }

        public Data(double[] weights, Vector[] mus, Matrix[] sigmas) {
            this.weights = weights;
            this.mus = mus;
            this.sigmas = sigmas;
            Product.$init$((Product)this);
        }
    }

    private static class GaussianMixtureModelReader
    extends MLReader<GaussianMixtureModel> {
        private final String className = GaussianMixtureModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public GaussianMixtureModel load(String path) {
            Data data;
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sparkSession(), this.className());
            String dataPath = new Path(path, "data").toString();
            if (BoxesRunTime.unboxToBoolean((Object)ReadWriteUtils$.MODULE$.localSavingModeState().get())) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModelReader.class.getClassLoader());
                public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$GaussianMixtureModelReader$$typecreator1$6
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.clustering.GaussianMixtureModel.Data").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_clustering_GaussianMixtureModel$GaussianMixtureModelReader$$typecreator1$6(GaussianMixtureModelReader $outer) {
                    }
                }
                data = (Data)ReadWriteUtils$.MODULE$.loadObjectFromLocal(dataPath, (Function1 & Serializable)dis -> GaussianMixtureModel$.MODULE$.deserializeData((DataInputStream)dis), ClassTag$.MODULE$.apply(Data.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$GaussianMixtureModelReader$$typecreator1$6(null)));
            } else {
                Row row = (Row)this.sparkSession().read().parquet(dataPath).select("weights", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"mus", "sigmas"})).head();
                data = new Data((double[])row.getSeq(0).toArray((ClassTag)ClassTag$.MODULE$.Double()), (Vector[])row.getSeq(1).toArray(ClassTag$.MODULE$.apply(Vector.class)), (Matrix[])row.getSeq(2).toArray(ClassTag$.MODULE$.apply(Matrix.class)));
            }
            Data data2 = data;
            Predef$.MODULE$.require(data2.mus().length == data2.sigmas().length, (Function0 & Serializable)() -> "Length of Mu and Sigma array must match");
            Predef$.MODULE$.require(data2.mus().length == data2.weights().length, (Function0 & Serializable)() -> "Length of weight and Gaussian array must match");
            MultivariateGaussian[] gaussians = (MultivariateGaussian[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])data2.mus()), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])data2.sigmas()))), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Vector mu = (Vector)tuple2._1();
                    Matrix sigma = (Matrix)tuple2._2();
                    return new MultivariateGaussian(mu.asML(), sigma.asML());
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(MultivariateGaussian.class));
            GaussianMixtureModel model = new GaussianMixtureModel(metadata.uid(), data2.weights(), gaussians);
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class GaussianMixtureModelWriter
    extends MLWriter {
        private final GaussianMixtureModel instance;

        @Override
        public void saveImpl(String path) {
            public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$GaussianMixtureModelWriter$$typecreator1$5
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.clustering.GaussianMixtureModel.Data").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_clustering_GaussianMixtureModel$GaussianMixtureModelWriter$$typecreator1$5(GaussianMixtureModelWriter $outer) {
                }
            }
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sparkSession());
            double[] weights = this.instance.weights();
            MultivariateGaussian[] gaussians = this.instance.gaussians();
            Vector[] mus = (Vector[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])gaussians), (Function1 & Serializable)g -> Vectors$.MODULE$.fromML(g.mean()), ClassTag$.MODULE$.apply(Vector.class));
            Matrix[] sigmas = (Matrix[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])gaussians), (Function1 & Serializable)c -> Matrices$.MODULE$.fromML(c.cov()), ClassTag$.MODULE$.apply(Matrix.class));
            Data data2 = new Data(weights, mus, sigmas);
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModelWriter.class.getClassLoader());
            ReadWriteUtils$.MODULE$.saveObject(dataPath, data2, this.sparkSession(), (Function2 & Serializable)(data, dos) -> {
                GaussianMixtureModel$.MODULE$.serializeData(data, dos);
                return BoxedUnit.UNIT;
            }, ClassTag$.MODULE$.apply(Data.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$GaussianMixtureModelWriter$$typecreator1$5(null)));
        }

        public GaussianMixtureModelWriter(GaussianMixtureModel instance) {
            this.instance = instance;
        }
    }
}

