/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.GBTClassificationModel$;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasStepSize;
import org.apache.spark.ml.param.shared.HasValidationIndicatorCol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.DecisionTreeParams;
import org.apache.spark.ml.tree.EnsembleModelReadWrite$;
import org.apache.spark.ml.tree.GBTClassifierParams;
import org.apache.spark.ml.tree.GBTParams;
import org.apache.spark.ml.tree.HasVarianceImpurity;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.TreeEnsembleClassifierParams;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.ml.tree.TreeEnsembleModel$;
import org.apache.spark.ml.tree.TreeEnsembleParams;
import org.apache.spark.ml.tree.impl.GradientBoostedTrees$;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.loss.ClassificationLoss;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.json4s.DefaultFormats$;
import org.json4s.ExtractableJsonAstNode$;
import org.json4s.Formats;
import org.json4s.JObject;
import org.json4s.JsonDSL$;
import org.json4s.MonadicJValue$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r\u0015c\u0001\u0002\u001e<\u0001\u0019C\u0001\"\u001e\u0001\u0003\u0006\u0004%\tE\u001e\u0005\n\u0003#\u0001!\u0011!Q\u0001\n]D!\"!\u0006\u0001\u0005\u000b\u0007I\u0011BA\f\u0011)\t\t\u0003\u0001B\u0001B\u0003%\u0011\u0011\u0004\u0005\u000b\u0003G\u0001!Q1A\u0005\n\u0005\u0015\u0002BCA\u0018\u0001\t\u0005\t\u0015!\u0003\u0002(!Q\u0011\u0011\u0007\u0001\u0003\u0006\u0004%\t%a\r\t\u0015\u0005u\u0002A!A!\u0002\u0013\t)\u0004\u0003\u0006\u0002B\u0001\u0011)\u0019!C!\u0003gA!\"!\u0013\u0001\u0005\u0003\u0005\u000b\u0011BA\u001b\u0011!\ti\u0005\u0001C\u0001{\u0005=\u0003\u0002CA'\u0001\u0011\u0005Q(!\u0019\t\u000f\u00055\u0003\u0001\"\u0001\u0002l!A\u0011Q\n\u0001\u0005\u0002u\n)\b\u0003\u0005\u0002x\u0001!\tePA=\u0011\u001d\t\t\t\u0001C!\u0003/A\u0011\"!#\u0001\u0005\u0004%\t!a\r\t\u0011\u0005E\u0005\u0001)A\u0005\u0003kAq!!&\u0001\t\u0003\n)\u0003C\u0004\u0002\u001a\u0002!\t%a'\t\u000f\u0005M\u0006\u0001\"\u0011\u00026\"9\u0011q\u001f\u0001\u0005B\u0005e\bbBA\u0000\u0001\u0011\u0005#\u0011\u0001\u0005\b\u0005\u0017\u0001A\u0011\u000bB\u0007\u0011\u001d\u0011\u0019\u0002\u0001C!\u0005+AqA!\u000b\u0001\t\u0003\u0012Y\u0003\u0003\u0006\u00030\u0001A)\u0019!C\u0001\u0005cAqA!\u000e\u0001\t\u0013\u00119\u0004\u0003\u0005\u0003<\u0001!\t!\u0010B\u001f\u0011%\u0011\t\u0006\u0001b\u0001\n\u0013\u0011\u0019\u0006\u0003\u0005\u0003`\u0001\u0001\u000b\u0011\u0002B+\u0011\u001d\u0011\t\u0007\u0001C\u0001\u0005GBqAa\u001e\u0001\t\u0003\u0012IhB\u0004\u0003\u0006nB\tAa\"\u0007\riZ\u0004\u0012\u0001BE\u0011\u001d\tie\tC\u0001\u0005KC\u0001Ba*$\u0005\u0004%IA\u001e\u0005\b\u0005S\u001b\u0003\u0015!\u0003x\u0011!\u0011Yk\tb\u0001\n\u00131\bb\u0002BWG\u0001\u0006Ia\u001e\u0005\b\u0005_\u001bC\u0011\tBY\u0011\u001d\u0011Yl\tC!\u0005{3qA!2$\u0001\r\u00129\rC\u0005\u0003J.\u0012\t\u0011)A\u0005#\"9\u0011QJ\u0016\u0005\u0002\t-\u0007b\u0002BjW\u0011E#Q\u001b\u0004\u0007\u0005?\u001cCA!9\t\u000f\u00055s\u0006\"\u0001\u0003d\"I!q]\u0018C\u0002\u0013%!\u0011\u001e\u0005\t\u0005k|\u0003\u0015!\u0003\u0003l\"I!q_\u0018C\u0002\u0013%!\u0011\u001e\u0005\t\u0005s|\u0003\u0015!\u0003\u0003l\"9!1X\u0018\u0005B\tm\b\u0002\u0003B\u0000G\u0011\u0005Qh!\u0001\t\u0015\r}1%%A\u0005\u0002u\u001a\t\u0003\u0003\u0006\u00046\r\n\n\u0011\"\u0001>\u0007CA\u0011ba\u000e$\u0003\u0003%Ia!\u000f\u0003-\u001d\u0013Ek\u00117bgNLg-[2bi&|g.T8eK2T!\u0001P\u001f\u0002\u001d\rd\u0017m]:jM&\u001c\u0017\r^5p]*\u0011ahP\u0001\u0003[2T!\u0001Q!\u0002\u000bM\u0004\u0018M]6\u000b\u0005\t\u001b\u0015AB1qC\u000eDWMC\u0001E\u0003\ry'oZ\u0002\u0001'\u0019\u0001qI\u0015-bOB!\u0001*S&R\u001b\u0005Y\u0014B\u0001&<\u0005\u0001\u0002&o\u001c2bE&d\u0017n\u001d;jG\u000ec\u0017m]:jM&\u001c\u0017\r^5p]6{G-\u001a7\u0011\u00051{U\"A'\u000b\u00059k\u0014A\u00027j]\u0006dw-\u0003\u0002Q\u001b\n1a+Z2u_J\u0004\"\u0001\u0013\u0001\u0011\u0005M3V\"\u0001+\u000b\u0005Uk\u0014\u0001\u0002;sK\u0016L!a\u0016+\u0003'\u001d\u0013Ek\u00117bgNLg-[3s!\u0006\u0014\u0018-\\:\u0011\u0007MK6,\u0003\u0002[)\n\tBK]3f\u000b:\u001cX-\u001c2mK6{G-\u001a7\u0011\u0005q{V\"A/\u000b\u0005yk\u0014A\u0003:fOJ,7o]5p]&\u0011\u0001-\u0018\u0002\u001c\t\u0016\u001c\u0017n]5p]R\u0013X-\u001a*fOJ,7o]5p]6{G-\u001a7\u0011\u0005\t,W\"A2\u000b\u0005\u0011l\u0014\u0001B;uS2L!AZ2\u0003\u00155cuK]5uC\ndW\r\u0005\u0002ie:\u0011\u0011n\u001c\b\u0003U6l\u0011a\u001b\u0006\u0003Y\u0016\u000ba\u0001\u0010:p_Rt\u0014\"\u00018\u0002\u000bM\u001c\u0017\r\\1\n\u0005A\f\u0018a\u00029bG.\fw-\u001a\u0006\u0002]&\u00111\u000f\u001e\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003aF\f1!^5e+\u00059\bC\u0001=}\u001d\tI(\u0010\u0005\u0002kc&\u001110]\u0001\u0007!J,G-\u001a4\n\u0005ut(AB*ue&twM\u0003\u0002|c\"*\u0011!!\u0001\u0002\u000eA!\u00111AA\u0005\u001b\t\t)AC\u0002\u0002\b}\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY!!\u0002\u0003\u000bMKgnY3\"\u0005\u0005=\u0011!B\u0019/m9\u0002\u0014\u0001B;jI\u0002BSAAA\u0001\u0003\u001b\taa\u0018;sK\u0016\u001cXCAA\r!\u0015\tY\"!\b\\\u001b\u0005\t\u0018bAA\u0010c\n)\u0011I\u001d:bs\u00069q\f\u001e:fKN\u0004\u0013\u0001D0ue\u0016,w+Z5hQR\u001cXCAA\u0014!\u0019\tY\"!\b\u0002*A!\u00111DA\u0016\u0013\r\ti#\u001d\u0002\u0007\t>,(\r\\3\u0002\u001b}#(/Z3XK&<\u0007\u000e^:!\u0003-qW/\u001c$fCR,(/Z:\u0016\u0005\u0005U\u0002\u0003BA\u000e\u0003oI1!!\u000fr\u0005\rIe\u000e\u001e\u0015\u0006\u000f\u0005\u0005\u0011QB\u0001\r]Vlg)Z1ukJ,7\u000f\t\u0015\u0006\u0011\u0005\u0005\u0011QB\u0001\u000b]Vl7\t\\1tg\u0016\u001c\b&B\u0005\u0002\u0002\u0005\u0015\u0013EAA$\u0003\u0015\u0011dF\r\u00181\u0003-qW/\\\"mCN\u001cXm\u001d\u0011)\u000b)\t\t!!\u0012\u0002\rqJg.\u001b;?)-\t\u0016\u0011KA+\u0003/\nI&!\u0018\t\u000bU\\\u0001\u0019A<)\r\u0005E\u0013\u0011AA\u0007\u0011\u001d\t)b\u0003a\u0001\u00033Aq!a\t\f\u0001\u0004\t9\u0003C\u0004\u00022-\u0001\r!!\u000e)\r\u0005e\u0013\u0011AA\u0007\u0011\u001d\t\te\u0003a\u0001\u0003kAc!!\u0018\u0002\u0002\u0005\u0015C#C)\u0002d\u0005\u0015\u0014qMA5\u0011\u0015)H\u00021\u0001x\u0011\u001d\t)\u0002\u0004a\u0001\u00033Aq!a\t\r\u0001\u0004\t9\u0003C\u0004\u000221\u0001\r!!\u000e\u0015\u000fE\u000bi'a\u001c\u0002r!)Q/\u0004a\u0001o\"9\u0011QC\u0007A\u0002\u0005e\u0001bBA\u0012\u001b\u0001\u0007\u0011q\u0005\u0015\u0006\u001b\u0005\u0005\u0011Q\u0002\u000b\u0002#\u0006iQm\u001d;j[\u0006$X\rZ*ju\u0016,\"!a\u001f\u0011\t\u0005m\u0011QP\u0005\u0004\u0003\u007f\n(\u0001\u0002'p]\u001e\fQ\u0001\u001e:fKNDS\u0001EA\u0001\u0003\u000b\u000b#!a\"\u0002\u000bErCG\f\u0019\u0002\u0017\u001d,GOT;n)J,Wm\u001d\u0015\u0006#\u0005\u0005\u0011QR\u0011\u0003\u0003\u001f\u000bQA\r\u00181]A\nAbZ3u\u001dVlGK]3fg\u0002BSAEA\u0001\u0003\u001b\u000b1\u0002\u001e:fK^+\u0017n\u001a5ug\"*1#!\u0001\u0002\u0006\u0006yAO]1og\u001a|'/\\*dQ\u0016l\u0017\r\u0006\u0003\u0002\u001e\u00065\u0006\u0003BAP\u0003Sk!!!)\u000b\t\u0005\r\u0016QU\u0001\u0006if\u0004Xm\u001d\u0006\u0004\u0003O{\u0014aA:rY&!\u00111VAQ\u0005)\u0019FO];diRK\b/\u001a\u0005\b\u0003_#\u0002\u0019AAO\u0003\u0019\u00198\r[3nC\"*A#!\u0001\u0002\u000e\u0005IAO]1og\u001a|'/\u001c\u000b\u0005\u0003o\u000b\u0019\u000e\u0005\u0003\u0002:\u00065g\u0002BA^\u0003\u0017tA!!0\u0002J:!\u0011qXAd\u001d\u0011\t\t-!2\u000f\u0007)\f\u0019-C\u0001E\u0013\t\u00115)\u0003\u0002A\u0003&\u0019\u0011qU \n\u0007A\f)+\u0003\u0003\u0002P\u0006E'!\u0003#bi\u00064%/Y7f\u0015\r\u0001\u0018Q\u0015\u0005\b\u0003+,\u0002\u0019AAl\u0003\u001d!\u0017\r^1tKR\u0004D!!7\u0002fB1\u00111\\Ao\u0003Cl!!!*\n\t\u0005}\u0017Q\u0015\u0002\b\t\u0006$\u0018m]3u!\u0011\t\u0019/!:\r\u0001\u0011a\u0011q]Aj\u0003\u0003\u0005\tQ!\u0001\u0002j\n\u0019q\f\n\u001a\u0012\t\u0005-\u0018\u0011\u001f\t\u0005\u00037\ti/C\u0002\u0002pF\u0014qAT8uQ&tw\r\u0005\u0003\u0002\u001c\u0005M\u0018bAA{c\n\u0019\u0011I\\=\u0002\u000fA\u0014X\rZ5diR!\u0011\u0011FA~\u0011\u0019\tiP\u0006a\u0001\u0017\u0006Aa-Z1ukJ,7/\u0001\u0006qe\u0016$\u0017n\u0019;SC^$2a\u0013B\u0002\u0011\u0019\tip\u0006a\u0001\u0017\"*q#!\u0001\u0003\b\u0005\u0012!\u0011B\u0001\u0006g9\u0002d\u0006M\u0001\u0017e\u0006<(\u0007\u001d:pE\u0006\u0014\u0017\u000e\\5us&s\u0007\u000b\\1dKR\u00191Ja\u0004\t\r\tE\u0001\u00041\u0001L\u00035\u0011\u0018m\u001e)sK\u0012L7\r^5p]\u0006!1m\u001c9z)\r\t&q\u0003\u0005\b\u00053I\u0002\u0019\u0001B\u000e\u0003\u0015)\u0007\u0010\u001e:b!\u0011\u0011iBa\t\u000e\u0005\t}!b\u0001B\u0011{\u0005)\u0001/\u0019:b[&!!Q\u0005B\u0010\u0005!\u0001\u0016M]1n\u001b\u0006\u0004\b&B\r\u0002\u0002\u0005\u0015\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003]DSAGA\u0001\u0003\u000b\u000b!CZ3biV\u0014X-S7q_J$\u0018M\\2fgV\t1\nK\u0003\u001c\u0003\u0003\ti)\u0001\u0004nCJ<\u0017N\u001c\u000b\u0005\u0003S\u0011I\u0004\u0003\u0004\u0002~r\u0001\raS\u0001\u0006i>|E\u000eZ\u000b\u0003\u0005\u007f\u0001BA!\u0011\u0003N5\u0011!1\t\u0006\u0005\u0005\u000b\u00129%A\u0003n_\u0012,GNC\u0002V\u0005\u0013R1Aa\u0013@\u0003\u0015iG\u000e\\5c\u0013\u0011\u0011yEa\u0011\u00033\u001d\u0013\u0018\rZ5f]R\u0014un\\:uK\u0012$&/Z3t\u001b>$W\r\\\u0001\u0005Y>\u001c8/\u0006\u0002\u0003VA!!q\u000bB.\u001b\t\u0011IF\u0003\u0003\u0003R\t\u001d\u0013\u0002\u0002B/\u00053\u0012!c\u00117bgNLg-[2bi&|g\u000eT8tg\u0006)An\\:tA\u0005)RM^1mk\u0006$X-R1dQ&#XM]1uS>tG\u0003BA\u0014\u0005KBq!!6!\u0001\u0004\u00119\u0007\r\u0003\u0003j\t5\u0004CBAn\u0003;\u0014Y\u0007\u0005\u0003\u0002d\n5D\u0001\u0004B8\u0005K\n\t\u0011!A\u0003\u0002\u0005%(aA0%g!*\u0001%!\u0001\u0003t\u0005\u0012!QO\u0001\u0006e9\"d\u0006M\u0001\u0006oJLG/Z\u000b\u0003\u0005w\u00022A\u0019B?\u0013\r\u0011yh\u0019\u0002\t\u001b2;&/\u001b;fe\"*\u0011%!\u0001\u0002\u000e\"*\u0001!!\u0001\u0002\u000e\u00051rI\u0011+DY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8N_\u0012,G\u000e\u0005\u0002IGM91Ea#\u0003\u0012\n]\u0005\u0003BA\u000e\u0005\u001bK1Aa$r\u0005\u0019\te.\u001f*fMB!!Ma%R\u0013\r\u0011)j\u0019\u0002\u000b\u001b2\u0013V-\u00193bE2,\u0007\u0003\u0002BM\u0005Gk!Aa'\u000b\t\tu%qT\u0001\u0003S>T!A!)\u0002\t)\fg/Y\u0005\u0004g\nmEC\u0001BD\u00039qW/\u001c$fCR,(/Z:LKf\fqB\\;n\r\u0016\fG/\u001e:fg.+\u0017\u0010I\u0001\f]VlGK]3fg.+\u00170\u0001\u0007ok6$&/Z3t\u0017\u0016L\b%\u0001\u0003sK\u0006$WC\u0001BZ!\u0011\u0011'QW)\n\u0007\t]6M\u0001\u0005N\u0019J+\u0017\rZ3sQ\u0015I\u0013\u0011AAG\u0003\u0011aw.\u00193\u0015\u0007E\u0013y\f\u0003\u0004\u0003B*\u0002\ra^\u0001\u0005a\u0006$\b\u000eK\u0003+\u0003\u0003\tiI\u0001\u000fH\u0005R\u001bE.Y:tS\u001aL7-\u0019;j_:lu\u000eZ3m/JLG/\u001a:\u0014\u0007-\u0012Y(\u0001\u0005j]N$\u0018M\\2f)\u0011\u0011iM!5\u0011\u0007\t=7&D\u0001$\u0011\u0019\u0011I-\fa\u0001#\u0006A1/\u0019<f\u00136\u0004H\u000e\u0006\u0003\u0003X\nu\u0007\u0003BA\u000e\u00053L1Aa7r\u0005\u0011)f.\u001b;\t\r\t\u0005g\u00061\u0001x\u0005q9%\tV\"mCN\u001c\u0018NZ5dCRLwN\\'pI\u0016d'+Z1eKJ\u001c2a\fBZ)\t\u0011)\u000fE\u0002\u0003P>\n\u0011b\u00197bgNt\u0015-\\3\u0016\u0005\t-\b\u0003\u0002Bw\u0005gl!Aa<\u000b\t\tE(qT\u0001\u0005Y\u0006tw-C\u0002~\u0005_\f!b\u00197bgNt\u0015-\\3!\u00035!(/Z3DY\u0006\u001c8OT1nK\u0006qAO]3f\u00072\f7o\u001d(b[\u0016\u0004CcA)\u0003~\"1!\u0011Y\u001bA\u0002]\fqA\u001a:p[>cG\rF\u0006R\u0007\u0007\u00199a!\u0005\u0004\u001c\ru\u0001bBB\u0003m\u0001\u0007!qH\u0001\t_2$Wj\u001c3fY\"91\u0011\u0002\u001cA\u0002\r-\u0011A\u00029be\u0016tG\u000fE\u0002I\u0007\u001bI1aa\u0004<\u000559%\tV\"mCN\u001c\u0018NZ5fe\"911\u0003\u001cA\u0002\rU\u0011aE2bi\u0016<wN]5dC24U-\u0019;ve\u0016\u001c\bc\u0002=\u0004\u0018\u0005U\u0012QG\u0005\u0004\u00073q(aA'ba\"I\u0011\u0011\u0007\u001c\u0011\u0002\u0003\u0007\u0011Q\u0007\u0005\n\u0003\u00032\u0004\u0013!a\u0001\u0003k\t\u0011C\u001a:p[>cG\r\n3fM\u0006,H\u000e\u001e\u00135+\t\u0019\u0019C\u000b\u0003\u00026\r\u00152FAB\u0014!\u0011\u0019Ic!\r\u000e\u0005\r-\"\u0002BB\u0017\u0007_\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001d\u0011/\u0003\u0003\u00044\r-\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\tbM]8n\u001f2$G\u0005Z3gCVdG\u000fJ\u001b\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\rm\u0002\u0003\u0002Bw\u0007{IAaa\u0010\u0003p\n1qJ\u00196fGRDSaIA\u0001\u0003\u001bCSAIA\u0001\u0003\u001b\u0003")
public class GBTClassificationModel
extends ProbabilisticClassificationModel<Vector, GBTClassificationModel>
implements GBTClassifierParams,
TreeEnsembleModel<DecisionTreeRegressionModel>,
MLWritable {
    private Vector featureImportances;
    private final String uid;
    private final DecisionTreeRegressionModel[] _trees;
    private final double[] _treeWeights;
    private final int numFeatures;
    private final int numClasses;
    private final int getNumTrees;
    private final ClassificationLoss loss;
    private int totalNumNodes;
    private Param<String> lossType;
    private Param<String> impurity;
    private DoubleParam validationTol;
    private DoubleParam stepSize;
    private Param<String> validationIndicatorCol;
    private IntParam maxIter;
    private DoubleParam subsamplingRate;
    private Param<String> featureSubsetStrategy;
    private Param<String> leafCol;
    private IntParam maxDepth;
    private IntParam maxBins;
    private IntParam minInstancesPerNode;
    private DoubleParam minWeightFractionPerNode;
    private DoubleParam minInfoGain;
    private IntParam maxMemoryInMB;
    private BooleanParam cacheNodeIds;
    private Param<String> weightCol;
    private LongParam seed;
    private IntParam checkpointInterval;
    private volatile byte bitmap$0;

    public static GBTClassificationModel load(String path) {
        return GBTClassificationModel$.MODULE$.load(path);
    }

    public static MLReader<GBTClassificationModel> read() {
        return GBTClassificationModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public DecisionTreeModel getTree(int i) {
        return TreeEnsembleModel.getTree$(this, i);
    }

    @Override
    public Vector javaTreeWeights() {
        return TreeEnsembleModel.javaTreeWeights$(this);
    }

    @Override
    public String toDebugString() {
        return TreeEnsembleModel.toDebugString$(this);
    }

    @Override
    public Vector predictLeaf(Vector features) {
        return TreeEnsembleModel.predictLeaf$(this, features);
    }

    @Override
    public StructField getLeafField(String leafCol) {
        return TreeEnsembleModel.getLeafField$(this, leafCol);
    }

    @Override
    public long getEstimatedSize() {
        return TreeEnsembleModel.getEstimatedSize$(this);
    }

    @Override
    public String getLossType() {
        return GBTClassifierParams.getLossType$(this);
    }

    @Override
    public ClassificationLoss getOldLossType() {
        return GBTClassifierParams.getOldLossType$(this);
    }

    @Override
    public final String getImpurity() {
        return HasVarianceImpurity.getImpurity$(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return HasVarianceImpurity.getOldImpurity$(this);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$tree$TreeEnsembleClassifierParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ProbabilisticClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return TreeEnsembleClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$GBTParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final double getValidationTol() {
        return GBTParams.getValidationTol$(this);
    }

    @Override
    public BoostingStrategy getOldBoostingStrategy(Map<Object, Object> categoricalFeatures, Enumeration.Value oldAlgo) {
        return GBTParams.getOldBoostingStrategy$(this, categoricalFeatures, oldAlgo);
    }

    @Override
    public final String getValidationIndicatorCol() {
        return HasValidationIndicatorCol.getValidationIndicatorCol$(this);
    }

    @Override
    public final double getStepSize() {
        return HasStepSize.getStepSize$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$TreeEnsembleParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final double getSubsamplingRate() {
        return TreeEnsembleParams.getSubsamplingRate$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final String getFeatureSubsetStrategy() {
        return TreeEnsembleParams.getFeatureSubsetStrategy$(this);
    }

    @Override
    public final DecisionTreeParams setLeafCol(String value) {
        return DecisionTreeParams.setLeafCol$(this, value);
    }

    @Override
    public final String getLeafCol() {
        return DecisionTreeParams.getLeafCol$(this);
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams.getMaxDepth$(this);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams.getMaxBins$(this);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams.getMinInstancesPerNode$(this);
    }

    @Override
    public final double getMinWeightFractionPerNode() {
        return DecisionTreeParams.getMinWeightFractionPerNode$(this);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams.getMinInfoGain$(this);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams.getMaxMemoryInMB$(this);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams.getCacheNodeIds$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval.getCheckpointInterval$(this);
    }

    private int totalNumNodes$lzycompute() {
        GBTClassificationModel gBTClassificationModel = this;
        synchronized (gBTClassificationModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.totalNumNodes = TreeEnsembleModel.totalNumNodes$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.totalNumNodes;
    }

    @Override
    public int totalNumNodes() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.totalNumNodes$lzycompute();
        }
        return this.totalNumNodes;
    }

    @Override
    public Param<String> lossType() {
        return this.lossType;
    }

    @Override
    public void org$apache$spark$ml$tree$GBTClassifierParams$_setter_$lossType_$eq(Param<String> x$1) {
        this.lossType = x$1;
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$HasVarianceImpurity$_setter_$impurity_$eq(Param<String> x$1) {
        this.impurity = x$1;
    }

    @Override
    public final DoubleParam validationTol() {
        return this.validationTol;
    }

    @Override
    public final DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public final void org$apache$spark$ml$tree$GBTParams$_setter_$validationTol_$eq(DoubleParam x$1) {
        this.validationTol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$GBTParams$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final Param<String> validationIndicatorCol() {
        return this.validationIndicatorCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasValidationIndicatorCol$_setter_$validationIndicatorCol_$eq(Param<String> x$1) {
        this.validationIndicatorCol = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public final Param<String> featureSubsetStrategy() {
        return this.featureSubsetStrategy;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$featureSubsetStrategy_$eq(Param<String> x$1) {
        this.featureSubsetStrategy = x$1;
    }

    @Override
    public final Param<String> leafCol() {
        return this.leafCol;
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minWeightFractionPerNode() {
        return this.minWeightFractionPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$leafCol_$eq(Param<String> x$1) {
        this.leafCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minWeightFractionPerNode_$eq(DoubleParam x$1) {
        this.minWeightFractionPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    private DecisionTreeRegressionModel[] _trees() {
        return this._trees;
    }

    private double[] _treeWeights() {
        return this._treeWeights;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    @Override
    public long estimatedSize() {
        return this.getEstimatedSize();
    }

    public DecisionTreeRegressionModel[] trees() {
        return this._trees();
    }

    public int getNumTrees() {
        return this.getNumTrees;
    }

    @Override
    public double[] treeWeights() {
        return this._treeWeights();
    }

    @Override
    public StructType transformSchema(StructType schema) {
        StructType outputSchema;
        block0: {
            outputSchema = super.transformSchema(schema);
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.leafCol())))) break block0;
            outputSchema = SchemaUtils$.MODULE$.updateField(outputSchema, this.getLeafField(this.$(this.leafCol())), SchemaUtils$.MODULE$.updateField$default$3());
        }
        return outputSchema;
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        StructType outputSchema = this.transformSchema(dataset.schema(), true);
        Dataset<Row> outputData = super.transform(dataset);
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.leafCol())))) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GBTClassificationModel.class.getClassLoader());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(GBTClassificationModel.class.getClassLoader());
            public final class Org_apache_spark_ml_classification_GBTClassificationModel$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_classification_GBTClassificationModel$$typecreator1$1(GBTClassificationModel $outer) {
                }
            }
            public final class Org_apache_spark_ml_classification_GBTClassificationModel$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_classification_GBTClassificationModel$$typecreator2$1(GBTClassificationModel $outer) {
                }
            }
            UserDefinedFunction leafUDF = functions$.MODULE$.udf((Function1 & Serializable)features -> this.predictLeaf((Vector)features), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_GBTClassificationModel$$typecreator1$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_classification_GBTClassificationModel$$typecreator2$1(null)));
            return outputData.withColumn(this.$(this.leafCol()), leafUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})), outputSchema.apply(this.$(this.leafCol())).metadata());
        }
        return outputData;
    }

    @Override
    public double predict(Vector features) {
        if (this.isDefined(this.thresholds())) {
            return super.predict(features);
        }
        if (this.margin(features) > 0.0) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public Vector predictRaw(Vector features) {
        double prediction = this.margin(features);
        return Vectors$.MODULE$.dense(new double[]{-prediction, prediction});
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        Vector vector = rawPrediction;
        if (vector instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector;
            denseVector.values()[0] = this.loss().computeProbability(denseVector.values()[0]);
            denseVector.values()[1] = 1.0 - denseVector.values()[0];
            return denseVector;
        }
        if (vector instanceof SparseVector) {
            throw new RuntimeException("Unexpected error in GBTClassificationModel: raw2probabilityInPlace encountered SparseVector");
        }
        throw new MatchError((Object)vector);
    }

    @Override
    public GBTClassificationModel copy(ParamMap extra) {
        return (GBTClassificationModel)((Model)this.copyValues(new GBTClassificationModel(this.uid(), this._trees(), this._treeWeights(), this.numFeatures(), this.numClasses()), extra)).setParent(this.parent());
    }

    @Override
    public String toString() {
        return "GBTClassificationModel: uid = " + this.uid() + ", numTrees=" + this.getNumTrees() + ", numClasses=" + this.numClasses() + ", numFeatures=" + this.numFeatures();
    }

    private Vector featureImportances$lzycompute() {
        GBTClassificationModel gBTClassificationModel = this;
        synchronized (gBTClassificationModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.featureImportances = TreeEnsembleModel$.MODULE$.featureImportances(this.trees(), this.numFeatures(), false);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.featureImportances;
    }

    public Vector featureImportances() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.featureImportances$lzycompute();
        }
        return this.featureImportances;
    }

    private double margin(Vector features) {
        double[] treePredictions = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this._trees()), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToDouble((double)GBTClassificationModel.$anonfun$margin$1(features, x$4)), (ClassTag)ClassTag$.MODULE$.Double());
        return BLAS$.MODULE$.nativeBLAS().ddot(this.getNumTrees(), treePredictions, 1, this._treeWeights(), 1);
    }

    public GradientBoostedTreesModel toOld() {
        return new GradientBoostedTreesModel(Algo$.MODULE$.Classification(), (org.apache.spark.mllib.tree.model.DecisionTreeModel[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this._trees()), (Function1 & Serializable)x$5 -> x$5.toOld(), ClassTag$.MODULE$.apply(org.apache.spark.mllib.tree.model.DecisionTreeModel.class)), this._treeWeights());
    }

    private ClassificationLoss loss() {
        return this.loss;
    }

    public double[] evaluateEachIteration(Dataset<?> dataset) {
        RDD<Instance> data = DatasetUtils$.MODULE$.extractInstances(this, dataset, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
        return GradientBoostedTrees$.MODULE$.evaluateEachIteration(data, this.trees(), this.treeWeights(), this.loss(), Algo$.MODULE$.Classification());
    }

    @Override
    public MLWriter write() {
        return new GBTClassificationModelWriter(this);
    }

    public static final /* synthetic */ double $anonfun$margin$1(Vector features$1, DecisionTreeRegressionModel x$4) {
        return x$4.rootNode().predictImpl(features$1).prediction();
    }

    public GBTClassificationModel(String uid, DecisionTreeRegressionModel[] _trees, double[] _treeWeights, int numFeatures, int numClasses) {
        this.uid = uid;
        this._trees = _trees;
        this._treeWeights = _treeWeights;
        this.numFeatures = numFeatures;
        this.numClasses = numClasses;
        HasCheckpointInterval.$init$(this);
        HasSeed.$init$(this);
        HasWeightCol.$init$(this);
        DecisionTreeParams.$init$(this);
        TreeEnsembleParams.$init$(this);
        HasMaxIter.$init$(this);
        HasStepSize.$init$(this);
        HasValidationIndicatorCol.$init$(this);
        GBTParams.$init$(this);
        TreeEnsembleClassifierParams.$init$(this);
        HasVarianceImpurity.$init$(this);
        GBTClassifierParams.$init$(this);
        TreeEnsembleModel.$init$(this);
        MLWritable.$init$(this);
        Predef$.MODULE$.require(ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])_trees)), (Function0 & Serializable)() -> "GBTClassificationModel requires at least 1 tree.");
        Predef$.MODULE$.require(_trees.length == _treeWeights.length, (Function0 & Serializable)() -> "GBTClassificationModel given trees, treeWeights of non-matching lengths (" + this._trees().length + ", " + this._treeWeights().length + ", respectively).");
        this.getNumTrees = this.trees().length;
        this.loss = this.getOldLossType();
        Statics.releaseFence();
    }

    public GBTClassificationModel(String uid, DecisionTreeRegressionModel[] _trees, double[] _treeWeights, int numFeatures) {
        this(uid, _trees, _treeWeights, numFeatures, 2);
    }

    public GBTClassificationModel(String uid, DecisionTreeRegressionModel[] _trees, double[] _treeWeights) {
        this(uid, _trees, _treeWeights, -1, 2);
    }

    public GBTClassificationModel() {
        this("", (DecisionTreeRegressionModel[])((Object[])new DecisionTreeRegressionModel[]{new DecisionTreeRegressionModel()}), new double[]{Double.NaN}, -1, -1);
    }

    private static class GBTClassificationModelReader
    extends MLReader<GBTClassificationModel> {
        private final String className = GBTClassificationModel.class.getName();
        private final String treeClassName = DecisionTreeRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        private String treeClassName() {
            return this.treeClassName;
        }

        @Override
        public GBTClassificationModel load(String path) {
            Tuple2[] tuple2Array;
            DefaultParamsReader.Metadata metadata;
            double[] treeWeights;
            DefaultFormats$ format;
            block3: {
                Tuple3<DefaultParamsReader.Metadata, Tuple2<DefaultParamsReader.Metadata, Node>[], double[]> tuple3;
                block2: {
                    format = DefaultFormats$.MODULE$;
                    tuple3 = EnsembleModelReadWrite$.MODULE$.loadImpl(path, this.sparkSession(), this.className(), this.treeClassName());
                    if (tuple3 == null) break block2;
                    DefaultParamsReader.Metadata metadata2 = (DefaultParamsReader.Metadata)tuple3._1();
                    Tuple2[] treesData = (Tuple2[])tuple3._2();
                    treeWeights = (double[])tuple3._3();
                    if (metadata2 == null) break block2;
                    metadata = metadata2;
                    if (treesData == null) break block2;
                    tuple2Array = treesData;
                    if (treeWeights != null) break block3;
                }
                throw new MatchError(tuple3);
            }
            double[] dArray = treeWeights;
            Tuple3 tuple3 = new Tuple3((Object)metadata, (Object)tuple2Array, (Object)dArray);
            DefaultParamsReader.Metadata metadata3 = (DefaultParamsReader.Metadata)tuple3._1();
            Tuple2[] treesData = (Tuple2[])tuple3._2();
            double[] treeWeights2 = (double[])tuple3._3();
            int numFeatures = BoxesRunTime.unboxToInt((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(metadata3.metadata()), GBTClassificationModel$.MODULE$.org$apache$spark$ml$classification$GBTClassificationModel$$numFeaturesKey())), (Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            int numTrees = BoxesRunTime.unboxToInt((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(metadata3.metadata()), GBTClassificationModel$.MODULE$.org$apache$spark$ml$classification$GBTClassificationModel$$numTreesKey())), (Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            DecisionTreeRegressionModel[] trees = (DecisionTreeRegressionModel[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])treesData), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    DefaultParamsReader.Metadata treeMetadata = (DefaultParamsReader.Metadata)tuple2._1();
                    Node root = (Node)tuple2._2();
                    DecisionTreeRegressionModel tree = new DecisionTreeRegressionModel(treeMetadata.uid(), root, numFeatures);
                    treeMetadata.getAndSetParams(tree, treeMetadata.getAndSetParams$default$2());
                    return tree;
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(DecisionTreeRegressionModel.class));
            Predef$.MODULE$.require(numTrees == trees.length, (Function0 & Serializable)() -> "GBTClassificationModel.load expected " + numTrees + " trees based on metadata but found " + trees.length + " trees.");
            GBTClassificationModel model = new GBTClassificationModel(metadata3.uid(), trees, treeWeights2, numFeatures);
            metadata3.getAndSetParams(model, (Option<List<String>>)new Some((Object)new .colon.colon((Object)"impurity", (List)Nil$.MODULE$)));
            return model;
        }
    }

    public static class GBTClassificationModelWriter
    extends MLWriter {
        private final GBTClassificationModel instance;

        @Override
        public void saveImpl(String path) {
            JObject extraMetadata = JsonDSL$.MODULE$.map2jvalue((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)GBTClassificationModel$.MODULE$.org$apache$spark$ml$classification$GBTClassificationModel$$numFeaturesKey()), (Object)BoxesRunTime.boxToInteger((int)this.instance.numFeatures())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)GBTClassificationModel$.MODULE$.org$apache$spark$ml$classification$GBTClassificationModel$$numTreesKey()), (Object)BoxesRunTime.boxToInteger((int)this.instance.getNumTrees()))})), (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)));
            EnsembleModelReadWrite$.MODULE$.saveImpl(this.instance, path, this.sparkSession(), extraMetadata);
        }

        public GBTClassificationModelWriter(GBTClassificationModel instance) {
            this.instance = instance;
        }
    }
}

