/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.avro;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.SchemaFormatter;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.FileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapred.FsInput;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.spark.SparkException;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.avro.AvroCompressionCodec;
import org.apache.spark.sql.avro.AvroOptions;
import org.apache.spark.sql.avro.AvroOptions$;
import org.apache.spark.sql.avro.AvroOutputWriterFactory;
import org.apache.spark.sql.avro.SchemaConverters$;
import org.apache.spark.sql.catalyst.FileSourceOptions;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.VariantType;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class AvroUtils$
implements Logging {
    public static final AvroUtils$ MODULE$ = new AvroUtils$();
    private static final String JSON_INLINE_FORMAT;
    private static final String JSON_PRETTY_FORMAT;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        JSON_INLINE_FORMAT = "json/inline";
        JSON_PRETTY_FORMAT = "json/pretty";
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String JSON_INLINE_FORMAT() {
        return JSON_INLINE_FORMAT;
    }

    public String JSON_PRETTY_FORMAT() {
        return JSON_PRETTY_FORMAT;
    }

    public Option<StructType> inferSchema(SparkSession spark, scala.collection.immutable.Map<String, String> options, Seq<FileStatus> files) {
        Schema avroSchema;
        DataType dataType;
        Configuration conf = spark.sessionState().newHadoopConfWithOptions(options);
        AvroOptions parsedOptions = new AvroOptions(options, conf);
        if (parsedOptions.parameters().contains(AvroOptions$.MODULE$.IGNORE_EXTENSION())) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Option ", " is deprecated. Please use the "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.CONFIG, AvroOptions$.MODULE$.IGNORE_EXTENSION())})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"general data source option pathGlobFilter for filtering file names."}))).log((Seq)Nil$.MODULE$))));
        }
        if ((dataType = SchemaConverters$.MODULE$.toSqlType(avroSchema = (Schema)parsedOptions.schema().getOrElse((Function0 & Serializable)() -> MODULE$.inferAvroSchemaFromFiles(files, conf, parsedOptions.ignoreExtension(), new FileSourceOptions(CaseInsensitiveMap$.MODULE$.apply(options)).ignoreCorruptFiles())), parsedOptions.useStableIdForUnionType(), parsedOptions.stableIdPrefixForUnionType(), parsedOptions.recursiveFieldMaxDepth()).dataType()) instanceof StructType) {
            StructType structType = (StructType)dataType;
            return new Some((Object)structType);
        }
        throw new RuntimeException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Avro schema cannot be converted to a Spark SQL StructType:\n           |\n           |" + SchemaFormatter.format((String)this.JSON_PRETTY_FORMAT(), (Schema)avroSchema) + "\n           |")));
    }

    public boolean supportsDataType(DataType dataType) {
        DataType dataType2;
        while (true) {
            if ((dataType2 = dataType) instanceof VariantType) {
                return false;
            }
            if (dataType2 instanceof AtomicType) {
                return true;
            }
            if (dataType2 instanceof StructType) {
                StructType structType = (StructType)dataType2;
                return structType.forall((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)AvroUtils$.MODULE$.supportsDataType(f.dataType())));
            }
            if (dataType2 instanceof ArrayType) {
                DataType elementType;
                ArrayType arrayType = (ArrayType)dataType2;
                dataType = elementType = arrayType.elementType();
                continue;
            }
            if (dataType2 instanceof MapType) {
                MapType mapType = (MapType)dataType2;
                DataType keyType = mapType.keyType();
                DataType valueType = mapType.valueType();
                if (this.supportsDataType(keyType)) {
                    dataType = valueType;
                    continue;
                }
                return false;
            }
            if (!(dataType2 instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            dataType = userDefinedType.sqlType();
        }
        return dataType2 instanceof NullType;
    }

    public OutputWriterFactory prepareWrite(SQLConf sqlConf, Job job, scala.collection.immutable.Map<String, String> options, StructType dataSchema) {
        AvroOptions parsedOptions = new AvroOptions(options, job.getConfiguration());
        Schema outputAvroSchema = (Schema)parsedOptions.schema().getOrElse((Function0 & Serializable)() -> SchemaConverters$.MODULE$.toAvroType((DataType)dataSchema, false, parsedOptions.recordName(), parsedOptions.recordNamespace()));
        AvroJob.setOutputKeySchema((Job)job, (Schema)outputAvroSchema);
        String string = parsedOptions.compression().toLowerCase(Locale.ROOT);
        switch (string == null ? 0 : string.hashCode()) {
            default: 
        }
        if (ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])AvroCompressionCodec.values()), (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)AvroUtils$.$anonfun$prepareWrite$2(string, c)))) {
            Configuration jobConf = job.getConfiguration();
            AvroCompressionCodec avroCompressionCodec = AvroCompressionCodec.fromString(string);
            if (((Object)((Object)AvroCompressionCodec.UNCOMPRESSED)).equals((Object)avroCompressionCodec)) {
                jobConf.setBoolean("mapreduce.output.fileoutputformat.compress", false);
            } else {
                jobConf.setBoolean("mapreduce.output.fileoutputformat.compress", true);
                jobConf.set("avro.output.codec", avroCompressionCodec.getCodecName());
                if (avroCompressionCodec.getSupportCompressionLevel()) {
                    Some some;
                    AvroCompressionCodec avroCompressionCodec2 = avroCompressionCodec;
                    if (((Object)((Object)AvroCompressionCodec.DEFLATE)).equals((Object)avroCompressionCodec2)) {
                        some = new Some((Object)new Tuple2(sqlConf.getConf(SQLConf$.MODULE$.AVRO_DEFLATE_LEVEL()), (Object)string));
                    } else if (((Object)((Object)AvroCompressionCodec.XZ)).equals((Object)avroCompressionCodec2)) {
                        some = new Some((Object)new Tuple2(sqlConf.getConf(SQLConf$.MODULE$.AVRO_XZ_LEVEL()), (Object)string));
                    } else if (((Object)((Object)AvroCompressionCodec.ZSTANDARD)).equals((Object)avroCompressionCodec2)) {
                        jobConf.setBoolean("avro.mapred.zstd.bufferpool", BoxesRunTime.unboxToBoolean((Object)sqlConf.getConf(SQLConf$.MODULE$.AVRO_ZSTANDARD_BUFFER_POOL_ENABLED())));
                        some = new Some((Object)new Tuple2(sqlConf.getConf(SQLConf$.MODULE$.AVRO_ZSTANDARD_LEVEL()), (Object)"zstd"));
                    } else {
                        some = None$.MODULE$;
                    }
                    Some levelAndCodecName = some;
                    levelAndCodecName.foreach((Function1 & Serializable)x0$1 -> {
                        AvroUtils$.$anonfun$prepareWrite$3(string, jobConf, x0$1);
                        return BoxedUnit.UNIT;
                    });
                } else {
                    this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Compressing Avro output using the ", " codec"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.CODEC_NAME, string)}))));
                }
            }
        } else {
            throw new SparkIllegalArgumentException("CODEC_SHORT_NAME_NOT_FOUND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"codecName"), (Object)string)})));
        }
        return new AvroOutputWriterFactory(dataSchema, outputAvroSchema.toString(), parsedOptions.positionalFieldMatching());
    }

    private Schema inferAvroSchemaFromFiles(Seq<FileStatus> files, Configuration conf, boolean ignoreExtension, boolean ignoreCorruptFiles) {
        Option avroReader = files.iterator().map((Function1 & Serializable)f -> {
            Path path = f.getPath();
            if (!ignoreExtension && !path.getName().endsWith(".avro")) {
                return None$.MODULE$;
            }
            return (Option)Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> new FsInput(path, conf), (Function1 & Serializable)in -> {
                Some some;
                try {
                    some = new Some((Object)DataFileReader.openReader((SeekableInput)in, (DatumReader)new GenericDatumReader()));
                }
                catch (IOException e) {
                    if (ignoreCorruptFiles) {
                        MODULE$.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Skipped the footer in the corrupted file: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.PATH, path)}))), (Throwable)e);
                        some = None$.MODULE$;
                    }
                    throw new SparkException("Could not read file: " + path, (Throwable)e);
                }
                return some;
            });
        }).collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Option<FileReader<GenericRecord>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Some) {
                    Some some = (Some)A1;
                    FileReader reader = (FileReader)some.value();
                    return (B1)reader;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Option<FileReader<GenericRecord>> x1) {
                Option<FileReader<GenericRecord>> option = x1;
                return option instanceof Some;
            }
        });
        Option option = avroReader;
        if (option instanceof Some) {
            Schema schema;
            Some some = (Some)option;
            try (FileReader reader = (FileReader)some.value();){
                schema = reader.getSchema();
            }
            return schema;
        }
        if (None$.MODULE$.equals(option)) {
            throw new FileNotFoundException("No Avro files found. If files don't have .avro extension, set ignoreExtension to true");
        }
        throw new MatchError((Object)option);
    }

    public String toFieldStr(Seq<String> names) {
        SeqOps seqOps;
        Seq<String> seq = names;
        if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0) == 0) {
            return "top-level record";
        }
        return "field '" + seq.mkString(".") + "'";
    }

    public boolean isNullable(Schema.Field avroField) {
        Schema.Type type = avroField.schema().getType();
        Schema.Type type2 = Schema.Type.UNION;
        return !(type != null ? !type.equals(type2) : type2 != null) && CollectionConverters$.MODULE$.ListHasAsScala(avroField.schema().getTypes()).asScala().exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)AvroUtils$.$anonfun$isNullable$1(x$6)));
    }

    public Seq<Schema> nonNullUnionBranches(Schema avroType) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(avroType.getTypes()).asScala().filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)AvroUtils$.$anonfun$nonNullUnionBranches$1(x$7)))).toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$prepareWrite$2(String x1$1, AvroCompressionCodec c) {
        String string = c.lowerCaseName();
        String string2 = x1$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$prepareWrite$3(String x1$1, Configuration jobConf$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int level = tuple2._1$mcI$sp();
            String mapredCodecName = (String)tuple2._2();
            MODULE$.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Compressing Avro output using the ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.CODEC_NAME, x1$1)})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"codec at level ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.CODEC_LEVEL, BoxesRunTime.boxToInteger((int)level))})))));
            jobConf$1.setInt("avro.mapred." + mapredCodecName + ".level", level);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$isNullable$1(Schema x$6) {
        Schema.Type type = x$6.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return !(type != null ? !type.equals(type2) : type2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$nonNullUnionBranches$1(Schema x$7) {
        Schema.Type type = x$7.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return type == null ? type2 != null : !type.equals(type2);
    }

    private AvroUtils$() {
    }
}

