/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.ui;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.config.Status$;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.service.ExecuteJobTag$;
import org.apache.spark.sql.connect.service.SparkListenerConnectOperationAnalyzed;
import org.apache.spark.sql.connect.service.SparkListenerConnectOperationCanceled;
import org.apache.spark.sql.connect.service.SparkListenerConnectOperationClosed;
import org.apache.spark.sql.connect.service.SparkListenerConnectOperationFailed;
import org.apache.spark.sql.connect.service.SparkListenerConnectOperationFinished;
import org.apache.spark.sql.connect.service.SparkListenerConnectOperationReadyForExecution;
import org.apache.spark.sql.connect.service.SparkListenerConnectOperationStarted;
import org.apache.spark.sql.connect.service.SparkListenerConnectSessionClosed;
import org.apache.spark.sql.connect.service.SparkListenerConnectSessionStarted;
import org.apache.spark.sql.connect.ui.ExecutionInfo;
import org.apache.spark.sql.connect.ui.ExecutionState$;
import org.apache.spark.sql.connect.ui.LiveExecutionData;
import org.apache.spark.sql.connect.ui.LiveSessionData;
import org.apache.spark.sql.connect.ui.SessionInfo;
import org.apache.spark.sql.connect.ui.SparkConnectServerListener$;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionStart;
import org.apache.spark.status.ElementTrackingStore;
import org.apache.spark.status.KVUtils$;
import org.apache.spark.status.LiveEntity;
import org.apache.spark.util.kvstore.KVStoreView;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t=e!B\u0015+\u000112\u0004\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u0011-\u0003!\u0011!Q\u0001\n1C\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006I!\u0015\u0005\u0006/\u0002!\t\u0001\u0017\u0005\b=\u0002\u0011\r\u0011\"\u0003`\u0011\u0019A\b\u0001)A\u0005A\"9\u0011\u0010\u0001b\u0001\n\u0013Q\bBB@\u0001A\u0003%1\u0010\u0003\u0007\u0002\u0002\u0001\u0001\n\u0011aA!\u0002\u0013\t\u0019\u0001C\u0005\u0002\u0010\u0001\u0011\r\u0011\"\u0003\u0002\u0012!A\u00111\u0003\u0001!\u0002\u0013\tI\u0001C\u0005\u0002\u0016\u0001\u0011\r\u0011\"\u0003\u0002\u0012!A\u0011q\u0003\u0001!\u0002\u0013\tI\u0001C\u0005\u0002\u001a\u0001\u0011\r\u0011\"\u0003\u0002\u001c!A\u00111\u0005\u0001!\u0002\u0013\ti\u0002\u0003\u0005\u0002&\u0001!\t\u0001LA\u0014\u0011\u001d\tI\u0003\u0001C!\u0003WAq!!\u0010\u0001\t\u0003\ny\u0004C\u0004\u0002L\u0001!\t!!\u0014\t\u000f\u0005\u0005\u0004\u0001\"\u0003\u0002d!9\u00111\u000f\u0001\u0005\n\u0005U\u0004bBA@\u0001\u0011%\u0011\u0011\u0011\u0005\b\u0003\u0017\u0003A\u0011BAG\u0011\u001d\t9\n\u0001C\u0005\u00033Cq!a)\u0001\t\u0013\t)\u000bC\u0004\u00020\u0002!I!!-\t\u000f\u0005m\u0006\u0001\"\u0003\u0002>\"9\u0011q\u0019\u0001\u0005\n\u0005%\u0007bBAj\u0001\u0011\u0005\u0011Q\u001b\u0005\b\u0003\u007f\u0004A\u0011\u0001B\u0001\u0011%\u0011)\u0002AI\u0001\n\u0003\u00119\u0002C\u0004\u00032\u0001!IAa\r\t\u000f\t\u0005\u0003\u0001\"\u0003\u0003D!9!Q\r\u0001\u0005\n\t\u001d\u0004b\u0002B7\u0001\u0011%!q\u000e\u0005\b\u0005g\u0002A\u0011\u0002B;\u000f)\u0011yHKA\u0001\u0012\u0003a#\u0011\u0011\u0004\nS)\n\t\u0011#\u0001-\u0005\u0007Caa\u0016\u0014\u0005\u0002\t-\u0005\"\u0003BGME\u0005I\u0011\u0001B\r\u0005i\u0019\u0006/\u0019:l\u0007>tg.Z2u'\u0016\u0014h/\u001a:MSN$XM\\3s\u0015\tYC&\u0001\u0002vS*\u0011QFL\u0001\bG>tg.Z2u\u0015\ty\u0003'A\u0002tc2T!!\r\u001a\u0002\u000bM\u0004\u0018M]6\u000b\u0005M\"\u0014AB1qC\u000eDWMC\u00016\u0003\ry'oZ\n\u0004\u0001]j\u0004C\u0001\u001d<\u001b\u0005I$B\u0001\u001e1\u0003%\u00198\r[3ek2,'/\u0003\u0002=s\ti1\u000b]1sW2K7\u000f^3oKJ\u0004\"AP!\u000e\u0003}R!\u0001\u0011\u0019\u0002\u0011%tG/\u001a:oC2L!AQ \u0003\u000f1{wmZ5oO\u000691N^:u_J,7\u0001\u0001\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011B\naa\u001d;biV\u001c\u0018B\u0001&H\u0005Q)E.Z7f]R$&/Y2lS:<7\u000b^8sK\u0006I1\u000f]1sW\u000e{gN\u001a\t\u0003\u001b:k\u0011\u0001M\u0005\u0003\u001fB\u0012\u0011b\u00159be.\u001cuN\u001c4\u0002\t1Lg/\u001a\t\u0003%Vk\u0011a\u0015\u0006\u0002)\u0006)1oY1mC&\u0011ak\u0015\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Q!\u0011l\u0017/^!\tQ\u0006!D\u0001+\u0011\u0015\u0019E\u00011\u0001F\u0011\u0015YE\u00011\u0001M\u0011\u001d\u0001F\u0001%AA\u0002E\u000b1b]3tg&|g\u000eT5tiV\t\u0001\r\u0005\u0003bQ*,X\"\u00012\u000b\u0005\r$\u0017AC2p]\u000e,(O]3oi*\u0011QMZ\u0001\u0005kRLGNC\u0001h\u0003\u0011Q\u0017M^1\n\u0005%\u0014'!D\"p]\u000e,(O]3oi6\u000b\u0007\u000f\u0005\u0002le:\u0011A\u000e\u001d\t\u0003[Nk\u0011A\u001c\u0006\u0003_\u0012\u000ba\u0001\u0010:p_Rt\u0014BA9T\u0003\u0019\u0001&/\u001a3fM&\u00111\u000f\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005E\u001c\u0006C\u0001.w\u0013\t9(FA\bMSZ,7+Z:tS>tG)\u0019;b\u00031\u0019Xm]:j_:d\u0015n\u001d;!\u00035)\u00070Z2vi&|g\u000eT5tiV\t1\u0010\u0005\u0003bQ*d\bC\u0001.~\u0013\tq(FA\tMSZ,W\t_3dkRLwN\u001c#bi\u0006\fa\"\u001a=fGV$\u0018n\u001c8MSN$\b%A\u0002yIE\u0002rAUA\u0003\u0003\u0013\tI!C\u0002\u0002\bM\u0013a\u0001V;qY\u0016\u0014\u0004c\u0001*\u0002\f%\u0019\u0011QB*\u0003\u0007%sG/\u0001\nsKR\f\u0017N\\3e'R\fG/Z7f]R\u001cXCAA\u0005\u0003M\u0011X\r^1j]\u0016$7\u000b^1uK6,g\u000e^:!\u0003A\u0011X\r^1j]\u0016$7+Z:tS>t7/A\tsKR\f\u0017N\\3e'\u0016\u001c8/[8og\u0002\n!\u0003\\5wKV\u0003H-\u0019;f!\u0016\u0014\u0018n\u001c3OgV\u0011\u0011Q\u0004\t\u0004%\u0006}\u0011bAA\u0011'\n!Aj\u001c8h\u0003Ma\u0017N^3Va\u0012\fG/\u001a)fe&|GMT:!\u0003)qw\u000eT5wK\u0012\u000bG/\u0019\u000b\u0002#\u0006QqN\u001c&pEN#\u0018M\u001d;\u0015\t\u00055\u00121\u0007\t\u0004%\u0006=\u0012bAA\u0019'\n!QK\\5u\u0011\u001d\t)$\u0005a\u0001\u0003o\t\u0001B[8c'R\f'\u000f\u001e\t\u0004q\u0005e\u0012bAA\u001es\t)2\u000b]1sW2K7\u000f^3oKJTuNY*uCJ$\u0018\u0001D8o\u001fRDWM]#wK:$H\u0003BA\u0017\u0003\u0003Bq!a\u0011\u0013\u0001\u0004\t)%A\u0003fm\u0016tG\u000fE\u00029\u0003\u000fJ1!!\u0013:\u0005I\u0019\u0006/\u0019:l\u0019&\u001cH/\u001a8fe\u00163XM\u001c;\u0002'=t7+\u0015'Fq\u0016\u001cW\u000f^5p]N#\u0018M\u001d;\u0015\t\u00055\u0012q\n\u0005\b\u0003#\u001a\u0002\u0019AA*\u0003\u0005)\u0007\u0003BA+\u0003;j!!a\u0016\u000b\u0007-\nIFC\u0002\u0002\\9\n\u0011\"\u001a=fGV$\u0018n\u001c8\n\t\u0005}\u0013q\u000b\u0002\u001f'B\f'o\u001b'jgR,g.\u001a:T#2+\u00050Z2vi&|gn\u0015;beR\f!c\u001c8Pa\u0016\u0014\u0018\r^5p]N#\u0018M\u001d;fIR!\u0011QFA3\u0011\u001d\t\t\u0006\u0006a\u0001\u0003O\u0002B!!\u001b\u0002p5\u0011\u00111\u000e\u0006\u0004\u0003[b\u0013aB:feZL7-Z\u0005\u0005\u0003c\nYG\u0001\u0013Ta\u0006\u00148\u000eT5ti\u0016tWM]\"p]:,7\r^(qKJ\fG/[8o'R\f'\u000f^3e\u0003Mygn\u00149fe\u0006$\u0018n\u001c8B]\u0006d\u0017P_3e)\u0011\ti#a\u001e\t\u000f\u0005ES\u00031\u0001\u0002zA!\u0011\u0011NA>\u0013\u0011\ti(a\u001b\u0003KM\u0003\u0018M]6MSN$XM\\3s\u0007>tg.Z2u\u001fB,'/\u0019;j_:\fe.\u00197zu\u0016$\u0017\u0001H8o\u001fB,'/\u0019;j_:\u0014V-\u00193z\r>\u0014X\t_3dkRLwN\u001c\u000b\u0005\u0003[\t\u0019\tC\u0004\u0002RY\u0001\r!!\"\u0011\t\u0005%\u0014qQ\u0005\u0005\u0003\u0013\u000bYG\u0001\u0018Ta\u0006\u00148\u000eT5ti\u0016tWM]\"p]:,7\r^(qKJ\fG/[8o%\u0016\fG-\u001f$pe\u0016CXmY;uS>t\u0017aE8o\u001fB,'/\u0019;j_:\u001c\u0015M\\2fY\u0016$G\u0003BA\u0017\u0003\u001fCq!!\u0015\u0018\u0001\u0004\t\t\n\u0005\u0003\u0002j\u0005M\u0015\u0002BAK\u0003W\u0012Qe\u00159be.d\u0015n\u001d;f]\u0016\u00148i\u001c8oK\u000e$x\n]3sCRLwN\\\"b]\u000e,G.\u001a3\u0002#=tw\n]3sCRLwN\u001c$bS2,G\r\u0006\u0003\u0002.\u0005m\u0005bBA)1\u0001\u0007\u0011Q\u0014\t\u0005\u0003S\ny*\u0003\u0003\u0002\"\u0006-$aI*qCJ\\G*[:uK:,'oQ8o]\u0016\u001cGo\u00149fe\u0006$\u0018n\u001c8GC&dW\rZ\u0001\u0014_:|\u0005/\u001a:bi&|gNR5oSNDW\r\u001a\u000b\u0005\u0003[\t9\u000bC\u0004\u0002Re\u0001\r!!+\u0011\t\u0005%\u00141V\u0005\u0005\u0003[\u000bYGA\u0013Ta\u0006\u00148\u000eT5ti\u0016tWM]\"p]:,7\r^(qKJ\fG/[8o\r&t\u0017n\u001d5fI\u0006\trN\\(qKJ\fG/[8o\u00072|7/\u001a3\u0015\u0007q\f\u0019\fC\u0004\u0002Ri\u0001\r!!.\u0011\t\u0005%\u0014qW\u0005\u0005\u0003s\u000bYGA\u0012Ta\u0006\u00148\u000eT5ti\u0016tWM]\"p]:,7\r^(qKJ\fG/[8o\u00072|7/\u001a3\u0002!=t7+Z:tS>t7\u000b^1si\u0016$G\u0003BA\u0017\u0003\u007fCq!!\u0015\u001c\u0001\u0004\t\t\r\u0005\u0003\u0002j\u0005\r\u0017\u0002BAc\u0003W\u0012!e\u00159be.d\u0015n\u001d;f]\u0016\u00148i\u001c8oK\u000e$8+Z:tS>t7\u000b^1si\u0016$\u0017aD8o'\u0016\u001c8/[8o\u00072|7/\u001a3\u0015\u0007U\fY\rC\u0004\u0002Rq\u0001\r!!4\u0011\t\u0005%\u0014qZ\u0005\u0005\u0003#\fYGA\u0011Ta\u0006\u00148\u000eT5ti\u0016tWM]\"p]:,7\r^*fgNLwN\\\"m_N,G-A\u000fva\u0012\fG/Z*u_J,w+\u001b;i)JLwmZ3s\u000b:\f'\r\\3e+\u0011\t9.!;\u0015\t\u0005e\u00171 \u000b\u0005\u0003[\tY\u000eC\u0004\u0002^v\u0001\r!a8\u0002\u000fU\u0004H-\u0019;feB9!+!9\u0002f\u00065\u0012bAAr'\nIa)\u001e8di&|g.\r\t\u0005\u0003O\fI\u000f\u0004\u0001\u0005\u000f\u0005-XD1\u0001\u0002n\n\tA+\u0005\u0003\u0002p\u0006U\bc\u0001*\u0002r&\u0019\u00111_*\u0003\u000f9{G\u000f[5oOB\u0019a)a>\n\u0007\u0005exI\u0001\u0006MSZ,WI\u001c;jifDq!!@\u001e\u0001\u0004\t)/\u0001\u0004f]RLG/_\u0001\u0010kB$\u0017\r^3MSZ,7\u000b^8sKV!!1\u0001B\u0007)\u0019\u0011)Aa\u0004\u0003\u0012Q!\u0011Q\u0006B\u0004\u0011\u001d\tiN\ba\u0001\u0005\u0013\u0001rAUAq\u0005\u0017\ti\u0003\u0005\u0003\u0002h\n5AaBAv=\t\u0007\u0011Q\u001e\u0005\b\u0003{t\u0002\u0019\u0001B\u0006\u0011!\u0011\u0019B\bI\u0001\u0002\u0004\t\u0016a\u0002;sS\u001e<WM]\u0001\u001akB$\u0017\r^3MSZ,7\u000b^8sK\u0012\"WMZ1vYR$#'\u0006\u0003\u0003\u001a\t=RC\u0001B\u000eU\r\t&QD\u0016\u0003\u0005?\u0001BA!\t\u0003,5\u0011!1\u0005\u0006\u0005\u0005K\u00119#A\u0005v]\u000eDWmY6fI*\u0019!\u0011F*\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003.\t\r\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00129\u00111^\u0010C\u0002\u00055\u0018AE4fi>\u00138I]3bi\u0016\u001cVm]:j_:$r!\u001eB\u001b\u0005s\u0011i\u0004\u0003\u0004\u00038\u0001\u0002\rA[\u0001\ng\u0016\u001c8/[8o\u0013\u0012DaAa\u000f!\u0001\u0004Q\u0017\u0001C;tKJt\u0015-\\3\t\u000f\t}\u0002\u00051\u0001\u0002\u001e\u0005I1\u000f^1siRKW.Z\u0001\u0015O\u0016$xJ]\"sK\u0006$X-\u0012=fGV$\u0018n\u001c8\u0015\u001fq\u0014)E!\u0013\u0003N\t=#1\u000bB,\u00057BaAa\u0012\"\u0001\u0004Q\u0017A\u00026pER\u000bw\r\u0003\u0004\u0003L\u0005\u0002\rA[\u0001\ngR\fG/Z7f]RDaAa\u000e\"\u0001\u0004Q\u0007b\u0002B)C\u0001\u0007\u0011QD\u0001\u000fgR\f'\u000f\u001e+j[\u0016\u001cH/Y7q\u0011\u0019\u0011)&\ta\u0001U\u00061Qo]3s\u0013\u0012DaA!\u0017\"\u0001\u0004Q\u0017aC8qKJ\fG/[8o\u0013\u0012DqA!\u0018\"\u0001\u0004\u0011y&\u0001\tta\u0006\u00148nU3tg&|g\u000eV1hgB!1N!\u0019k\u0013\r\u0011\u0019\u0007\u001e\u0002\u0004'\u0016$\u0018!E2mK\u0006tW\u000f]#yK\u000e,H/[8ogR!\u0011Q\u0006B5\u0011\u001d\u0011YG\ta\u0001\u0003;\tQaY8v]R\fab\u00197fC:,\boU3tg&|g\u000e\u0006\u0003\u0002.\tE\u0004b\u0002B6G\u0001\u0007\u0011QD\u0001\u0018G\u0006d7-\u001e7bi\u0016tU/\u001c2feR{'+Z7pm\u0016$b!!\b\u0003x\tm\u0004b\u0002B=I\u0001\u0007\u0011QD\u0001\tI\u0006$\u0018mU5{K\"9!Q\u0010\u0013A\u0002\u0005u\u0011\u0001\u0004:fi\u0006Lg.\u001a3TSj,\u0017AG*qCJ\\7i\u001c8oK\u000e$8+\u001a:wKJd\u0015n\u001d;f]\u0016\u0014\bC\u0001.''\r1#Q\u0011\t\u0004%\n\u001d\u0015b\u0001BE'\n1\u0011I\\=SK\u001a$\"A!!\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0001")
public class SparkConnectServerListener
extends SparkListener
implements Logging {
    private final ElementTrackingStore kvstore;
    private final boolean live;
    private final ConcurrentMap<String, LiveSessionData> sessionList;
    private final ConcurrentMap<String, LiveExecutionData> executionList;
    private final /* synthetic */ Tuple2 x$1;
    private final int retainedStatements;
    private final int retainedSessions;
    private final long liveUpdatePeriodNs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static boolean $lessinit$greater$default$3() {
        return SparkConnectServerListener$.MODULE$.$lessinit$greater$default$3();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ConcurrentMap<String, LiveSessionData> sessionList() {
        return this.sessionList;
    }

    private ConcurrentMap<String, LiveExecutionData> executionList() {
        return this.executionList;
    }

    private int retainedStatements() {
        return this.retainedStatements;
    }

    private int retainedSessions() {
        return this.retainedSessions;
    }

    private long liveUpdatePeriodNs() {
        return this.liveUpdatePeriodNs;
    }

    public boolean noLiveData() {
        return this.sessionList().isEmpty() && this.executionList().isEmpty();
    }

    public void onJobStart(SparkListenerJobStart jobStart) {
        Seq jobTags = (Seq)((SeqOps)((IterableOnceOps)Option$.MODULE$.apply((Object)jobStart.properties()).flatMap((Function1 & Serializable)p -> Option$.MODULE$.apply((Object)p.getProperty(SparkContext$.MODULE$.SPARK_JOB_TAGS()))).map((Function1 & Serializable)x$2 -> Predef$.MODULE$.wrapRefArray((Object[])x$2.split(SparkContext$.MODULE$.SPARK_JOB_TAGS_SEP())).toSet()).getOrElse((Function0 & Serializable)() -> (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$))).toSeq().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectServerListener.$anonfun$onJobStart$4(x$3)))).sorted((Ordering)Ordering.String$.MODULE$);
        Option executeJobTagOpt = jobTags.find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectServerListener.$anonfun$onJobStart$5(x0$1)));
        if (executeJobTagOpt.isEmpty()) {
            return;
        }
        String executeJobTag = (String)executeJobTagOpt.get();
        Option exec2 = Option$.MODULE$.apply(this.executionList().get(executeJobTag));
        if (exec2.nonEmpty()) {
            exec2.foreach((Function1 & Serializable)exec -> {
                this.updateLiveStore(exec, this.updateLiveStore$default$2(), (Function1 & Serializable)exec -> {
                    SparkConnectServerListener.$anonfun$onJobStart$7(jobStart$1, exec);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            return;
        }
        Seq storeExecInfo = KVUtils$.MODULE$.viewToSeq(this.kvstore.view(ExecutionInfo.class), Integer.MAX_VALUE, (Function1 & Serializable)exec -> BoxesRunTime.boxToBoolean((boolean)SparkConnectServerListener.$anonfun$onJobStart$8(executeJobTag, exec)));
        storeExecInfo.foreach((Function1 & Serializable)exec -> {
            LiveExecutionData liveExec2 = this.getOrCreateExecution(exec.jobTag(), exec.statement(), exec.sessionId(), exec.startTimestamp(), exec.userId(), exec.operationId(), exec.sparkSessionTags());
            this.updateStoreWithTriggerEnabled(liveExec2, (Function1 & Serializable)liveExec -> {
                SparkConnectServerListener.$anonfun$onJobStart$10(exec, jobStart, liveExec);
                return BoxedUnit.UNIT;
            });
            return (LiveExecutionData)((Object)((Object)this.executionList().remove(liveExec2.jobTag())));
        });
    }

    public void onOtherEvent(SparkListenerEvent event) {
        SparkListenerEvent sparkListenerEvent = event;
        if (sparkListenerEvent instanceof SparkListenerSQLExecutionStart) {
            SparkListenerSQLExecutionStart sparkListenerSQLExecutionStart = (SparkListenerSQLExecutionStart)sparkListenerEvent;
            this.onSQLExecutionStart(sparkListenerSQLExecutionStart);
            return;
        }
        if (sparkListenerEvent instanceof SparkListenerConnectOperationStarted) {
            SparkListenerConnectOperationStarted sparkListenerConnectOperationStarted = (SparkListenerConnectOperationStarted)sparkListenerEvent;
            this.onOperationStarted(sparkListenerConnectOperationStarted);
            return;
        }
        if (sparkListenerEvent instanceof SparkListenerConnectOperationAnalyzed) {
            SparkListenerConnectOperationAnalyzed sparkListenerConnectOperationAnalyzed = (SparkListenerConnectOperationAnalyzed)sparkListenerEvent;
            this.onOperationAnalyzed(sparkListenerConnectOperationAnalyzed);
            return;
        }
        if (sparkListenerEvent instanceof SparkListenerConnectOperationReadyForExecution) {
            SparkListenerConnectOperationReadyForExecution sparkListenerConnectOperationReadyForExecution = (SparkListenerConnectOperationReadyForExecution)sparkListenerEvent;
            this.onOperationReadyForExecution(sparkListenerConnectOperationReadyForExecution);
            return;
        }
        if (sparkListenerEvent instanceof SparkListenerConnectOperationCanceled) {
            SparkListenerConnectOperationCanceled sparkListenerConnectOperationCanceled = (SparkListenerConnectOperationCanceled)sparkListenerEvent;
            this.onOperationCanceled(sparkListenerConnectOperationCanceled);
            return;
        }
        if (sparkListenerEvent instanceof SparkListenerConnectOperationFailed) {
            SparkListenerConnectOperationFailed sparkListenerConnectOperationFailed = (SparkListenerConnectOperationFailed)sparkListenerEvent;
            this.onOperationFailed(sparkListenerConnectOperationFailed);
            return;
        }
        if (sparkListenerEvent instanceof SparkListenerConnectOperationFinished) {
            SparkListenerConnectOperationFinished sparkListenerConnectOperationFinished = (SparkListenerConnectOperationFinished)sparkListenerEvent;
            this.onOperationFinished(sparkListenerConnectOperationFinished);
            return;
        }
        if (sparkListenerEvent instanceof SparkListenerConnectOperationClosed) {
            SparkListenerConnectOperationClosed sparkListenerConnectOperationClosed = (SparkListenerConnectOperationClosed)sparkListenerEvent;
            this.onOperationClosed(sparkListenerConnectOperationClosed);
            return;
        }
        if (sparkListenerEvent instanceof SparkListenerConnectSessionStarted) {
            SparkListenerConnectSessionStarted sparkListenerConnectSessionStarted = (SparkListenerConnectSessionStarted)sparkListenerEvent;
            this.onSessionStarted(sparkListenerConnectSessionStarted);
            return;
        }
        if (sparkListenerEvent instanceof SparkListenerConnectSessionClosed) {
            SparkListenerConnectSessionClosed sparkListenerConnectSessionClosed = (SparkListenerConnectSessionClosed)sparkListenerEvent;
            this.onSessionClosed(sparkListenerConnectSessionClosed);
            return;
        }
    }

    public void onSQLExecutionStart(SparkListenerSQLExecutionStart e) {
        Option executeJobTagOpt = e.jobTags().find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectServerListener.$anonfun$onSQLExecutionStart$1(x0$1)));
        if (executeJobTagOpt.isEmpty()) {
            return;
        }
        String executeJobTag = (String)executeJobTagOpt.get();
        Option exec2 = Option$.MODULE$.apply(this.executionList().get(executeJobTag));
        if (exec2.nonEmpty()) {
            exec2.foreach((Function1 & Serializable)exec -> {
                this.updateLiveStore(exec, this.updateLiveStore$default$2(), (Function1 & Serializable)exec -> {
                    SparkConnectServerListener.$anonfun$onSQLExecutionStart$3(e$1, exec);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            return;
        }
        Seq storeExecInfo = KVUtils$.MODULE$.viewToSeq(this.kvstore.view(ExecutionInfo.class), Integer.MAX_VALUE, (Function1 & Serializable)exec -> BoxesRunTime.boxToBoolean((boolean)SparkConnectServerListener.$anonfun$onSQLExecutionStart$4(executeJobTag, exec)));
        storeExecInfo.foreach((Function1 & Serializable)exec -> {
            LiveExecutionData liveExec2 = this.getOrCreateExecution(exec.jobTag(), exec.statement(), exec.sessionId(), exec.startTimestamp(), exec.userId(), exec.operationId(), exec.sparkSessionTags());
            this.updateStoreWithTriggerEnabled(liveExec2, (Function1 & Serializable)liveExec -> {
                SparkConnectServerListener.$anonfun$onSQLExecutionStart$6(exec, e, liveExec);
                return BoxedUnit.UNIT;
            });
            return (LiveExecutionData)((Object)((Object)this.executionList().remove(liveExec2.jobTag())));
        });
    }

    private void onOperationStarted(SparkListenerConnectOperationStarted e) {
        LiveExecutionData executionData2 = this.getOrCreateExecution(e.jobTag(), e.statementText(), e.sessionId(), e.eventTime(), e.userId(), e.operationId(), e.sparkSessionTags());
        this.updateLiveStore(executionData2, this.updateLiveStore$default$2(), (Function1 & Serializable)executionData -> {
            executionData.state_$eq(ExecutionState$.MODULE$.STARTED());
            return BoxedUnit.UNIT;
        });
        Option option = Option$.MODULE$.apply(this.sessionList().get(e.sessionId()));
        if (option instanceof Some) {
            Some some = (Some)option;
            LiveSessionData sessionData2 = (LiveSessionData)((Object)some.value());
            this.updateLiveStore(sessionData2, this.updateLiveStore$default$2(), (Function1 & Serializable)sessionData -> {
                sessionData.totalExecution_$eq(sessionData.totalExecution() + 1);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"onOperationStart called with unknown session id: ", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.SESSION_ID, e.sessionId())})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Regardless, the operation has been registered."}))).log((Seq)Nil$.MODULE$))));
            return;
        }
        throw new MatchError((Object)option);
    }

    private void onOperationAnalyzed(SparkListenerConnectOperationAnalyzed e) {
        Option option = Option$.MODULE$.apply(this.executionList().get(e.jobTag()));
        if (option instanceof Some) {
            Some some = (Some)option;
            LiveExecutionData executionData2 = (LiveExecutionData)((Object)some.value());
            this.updateLiveStore(executionData2, this.updateLiveStore$default$2(), (Function1 & Serializable)executionData -> {
                executionData.state_$eq(ExecutionState$.MODULE$.COMPILED());
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"onOperationAnalyzed called with "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"unknown operation id: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.OP_ID, e.jobTag())})))));
            return;
        }
        throw new MatchError((Object)option);
    }

    private void onOperationReadyForExecution(SparkListenerConnectOperationReadyForExecution e) {
        Option option = Option$.MODULE$.apply(this.executionList().get(e.jobTag()));
        if (option instanceof Some) {
            Some some = (Some)option;
            LiveExecutionData executionData2 = (LiveExecutionData)((Object)some.value());
            this.updateLiveStore(executionData2, this.updateLiveStore$default$2(), (Function1 & Serializable)executionData -> {
                executionData.state_$eq(ExecutionState$.MODULE$.READY());
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"onOperationReadyForExecution called with "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"unknown operation id: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.OP_ID, e.jobTag())})))));
            return;
        }
        throw new MatchError((Object)option);
    }

    private void onOperationCanceled(SparkListenerConnectOperationCanceled e) {
        Option option = Option$.MODULE$.apply(this.executionList().get(e.jobTag()));
        if (option instanceof Some) {
            Some some = (Some)option;
            LiveExecutionData executionData2 = (LiveExecutionData)((Object)some.value());
            this.updateLiveStore(executionData2, this.updateLiveStore$default$2(), (Function1 & Serializable)executionData -> {
                SparkConnectServerListener.$anonfun$onOperationCanceled$1(e, executionData);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"onOperationCanceled called with "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"unknown operation id: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.OP_ID, e.jobTag())})))));
            return;
        }
        throw new MatchError((Object)option);
    }

    private void onOperationFailed(SparkListenerConnectOperationFailed e) {
        Option option = Option$.MODULE$.apply(this.executionList().get(e.jobTag()));
        if (option instanceof Some) {
            Some some = (Some)option;
            LiveExecutionData executionData2 = (LiveExecutionData)((Object)some.value());
            this.updateLiveStore(executionData2, this.updateLiveStore$default$2(), (Function1 & Serializable)executionData -> {
                SparkConnectServerListener.$anonfun$onOperationFailed$1(e, executionData);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"onOperationFailed called with "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"unknown operation id: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.OP_ID, e.jobTag())})))));
            return;
        }
        throw new MatchError((Object)option);
    }

    private void onOperationFinished(SparkListenerConnectOperationFinished e) {
        Option option = Option$.MODULE$.apply(this.executionList().get(e.jobTag()));
        if (option instanceof Some) {
            Some some = (Some)option;
            LiveExecutionData executionData2 = (LiveExecutionData)((Object)some.value());
            this.updateLiveStore(executionData2, this.updateLiveStore$default$2(), (Function1 & Serializable)executionData -> {
                SparkConnectServerListener.$anonfun$onOperationFinished$1(e, executionData);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"onOperationFinished called with "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"unknown operation id: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.OP_ID, e.jobTag())})))));
            return;
        }
        throw new MatchError((Object)option);
    }

    private LiveExecutionData onOperationClosed(SparkListenerConnectOperationClosed e) {
        return (LiveExecutionData)this.executionList().compute(e.jobTag(), (x$4, executionData2) -> {
            if (executionData2 != null) {
                this.updateStoreWithTriggerEnabled(executionData2, (Function1 & Serializable)executionData -> {
                    SparkConnectServerListener.$anonfun$onOperationClosed$2(e, executionData);
                    return BoxedUnit.UNIT;
                });
            } else {
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"onOperationClosed called with "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"unknown operation id: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.OP_ID, e.jobTag())})))));
            }
            return null;
        });
    }

    private void onSessionStarted(SparkListenerConnectSessionStarted e) {
        LiveSessionData session = this.getOrCreateSession(e.sessionId(), e.userId(), e.eventTime());
        this.updateLiveStore(session, this.updateLiveStore$default$2(), (Function1 & Serializable)x$5 -> {
            SparkConnectServerListener.$anonfun$onSessionStarted$1(x$5);
            return BoxedUnit.UNIT;
        });
    }

    private LiveSessionData onSessionClosed(SparkListenerConnectSessionClosed e) {
        return (LiveSessionData)this.sessionList().compute(e.sessionId(), (x$6, sessionData2) -> {
            if (sessionData2 != null) {
                this.updateStoreWithTriggerEnabled(sessionData2, (Function1 & Serializable)sessionData -> {
                    sessionData.finishTimestamp_$eq(e.eventTime());
                    return BoxedUnit.UNIT;
                });
            } else {
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"onSessionClosed called with "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"unknown session id: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.SESSION_ID, e.sessionId())})))));
            }
            return null;
        });
    }

    public <T extends LiveEntity> void updateStoreWithTriggerEnabled(T entity, Function1<T, BoxedUnit> updater) {
        T t = entity;
        synchronized (t) {
            updater.apply(entity);
            entity.write(this.kvstore, System.nanoTime(), true);
        }
    }

    public <T extends LiveEntity> void updateLiveStore(T entity, boolean trigger, Function1<T, BoxedUnit> updater) {
        T t = entity;
        synchronized (t) {
            updater.apply(entity);
            long now = System.nanoTime();
            if (this.live && this.liveUpdatePeriodNs() >= 0L && now - entity.lastWriteTime() > this.liveUpdatePeriodNs()) {
                entity.write(this.kvstore, now, trigger);
            }
        }
    }

    public <T extends LiveEntity> boolean updateLiveStore$default$2() {
        return false;
    }

    private LiveSessionData getOrCreateSession(String sessionId, String userName, long startTime) {
        return this.sessionList().computeIfAbsent(sessionId, x$7 -> new LiveSessionData(sessionId, startTime, userName));
    }

    private LiveExecutionData getOrCreateExecution(String jobTag, String statement, String sessionId, long startTimestamp, String userId, String operationId, Set<String> sparkSessionTags) {
        return this.executionList().computeIfAbsent(jobTag, x$8 -> new LiveExecutionData(jobTag, statement, sessionId, startTimestamp, userId, operationId, sparkSessionTags));
    }

    private void cleanupExecutions(long count) {
        long countToDelete = this.calculateNumberToRemove(count, this.retainedStatements());
        if (countToDelete <= 0L) {
            return;
        }
        KVStoreView view = this.kvstore.view(ExecutionInfo.class).index("finishTime").first((Object)BoxesRunTime.boxToLong((long)0L));
        Seq toDelete = KVUtils$.MODULE$.viewToSeq(view, (int)countToDelete, (Function1 & Serializable)j -> BoxesRunTime.boxToBoolean((boolean)SparkConnectServerListener.$anonfun$cleanupExecutions$1(j)));
        toDelete.foreach((Function1 & Serializable)j -> {
            this.kvstore.delete(j.getClass(), (Object)j.jobTag());
            return BoxedUnit.UNIT;
        });
    }

    private void cleanupSession(long count) {
        long countToDelete = this.calculateNumberToRemove(count, this.retainedSessions());
        if (countToDelete <= 0L) {
            return;
        }
        KVStoreView view = this.kvstore.view(SessionInfo.class).index("finishTime").first((Object)BoxesRunTime.boxToLong((long)0L));
        Seq toDelete = KVUtils$.MODULE$.viewToSeq(view, (int)countToDelete, (Function1 & Serializable)j -> BoxesRunTime.boxToBoolean((boolean)SparkConnectServerListener.$anonfun$cleanupSession$1(j)));
        toDelete.foreach((Function1 & Serializable)j -> {
            this.kvstore.delete(j.getClass(), (Object)j.sessionId());
            return BoxedUnit.UNIT;
        });
    }

    private long calculateNumberToRemove(long dataSize, long retainedSize) {
        if (dataSize > retainedSize) {
            return package$.MODULE$.max(retainedSize / 10L, dataSize - retainedSize);
        }
        return 0L;
    }

    public static final /* synthetic */ boolean $anonfun$onJobStart$4(String x$3) {
        return !x$3.isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$onJobStart$5(String x0$1) {
        Option<String> option;
        String string = x0$1;
        return string != null && !(option = ExecuteJobTag$.MODULE$.unapply(string)).isEmpty();
    }

    public static final /* synthetic */ void $anonfun$onJobStart$7(SparkListenerJobStart jobStart$1, LiveExecutionData exec) {
        exec.jobId().$plus$eq((Object)Integer.toString(jobStart$1.jobId()));
    }

    public static final /* synthetic */ boolean $anonfun$onJobStart$8(String executeJobTag$1, ExecutionInfo exec) {
        String string = exec.jobTag();
        String string2 = executeJobTag$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$onJobStart$10(ExecutionInfo exec$1, SparkListenerJobStart jobStart$1, LiveExecutionData liveExec) {
        liveExec.sqlExecId_$eq(exec$1.sqlExecId());
        liveExec.jobId().$plus$eq((Object)Integer.toString(jobStart$1.jobId()));
    }

    public static final /* synthetic */ boolean $anonfun$onSQLExecutionStart$1(String x0$1) {
        Option<String> option;
        String string = x0$1;
        return string != null && !(option = ExecuteJobTag$.MODULE$.unapply(string)).isEmpty();
    }

    public static final /* synthetic */ void $anonfun$onSQLExecutionStart$3(SparkListenerSQLExecutionStart e$1, LiveExecutionData exec) {
        exec.sqlExecId().$plus$eq((Object)Long.toString(e$1.executionId()));
    }

    public static final /* synthetic */ boolean $anonfun$onSQLExecutionStart$4(String executeJobTag$2, ExecutionInfo exec) {
        String string = exec.jobTag();
        String string2 = executeJobTag$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$onSQLExecutionStart$6(ExecutionInfo exec$2, SparkListenerSQLExecutionStart e$1, LiveExecutionData liveExec) {
        liveExec.jobId_$eq(exec$2.jobId());
        liveExec.sqlExecId().$plus$eq((Object)Long.toString(e$1.executionId()));
    }

    public static final /* synthetic */ void $anonfun$onOperationCanceled$1(SparkListenerConnectOperationCanceled e$5, LiveExecutionData executionData) {
        executionData.finishTimestamp_$eq(e$5.eventTime());
        executionData.state_$eq(ExecutionState$.MODULE$.CANCELED());
    }

    public static final /* synthetic */ void $anonfun$onOperationFailed$1(SparkListenerConnectOperationFailed e$6, LiveExecutionData executionData) {
        executionData.finishTimestamp_$eq(e$6.eventTime());
        executionData.detail_$eq(e$6.errorMessage());
        executionData.state_$eq(ExecutionState$.MODULE$.FAILED());
    }

    public static final /* synthetic */ void $anonfun$onOperationFinished$1(SparkListenerConnectOperationFinished e$7, LiveExecutionData executionData) {
        executionData.finishTimestamp_$eq(e$7.eventTime());
        executionData.state_$eq(ExecutionState$.MODULE$.FINISHED());
    }

    public static final /* synthetic */ void $anonfun$onOperationClosed$2(SparkListenerConnectOperationClosed e$8, LiveExecutionData executionData) {
        executionData.closeTimestamp_$eq(e$8.eventTime());
        executionData.state_$eq(ExecutionState$.MODULE$.CLOSED());
    }

    public static final /* synthetic */ void $anonfun$onSessionStarted$1(LiveSessionData x$5) {
    }

    public static final /* synthetic */ boolean $anonfun$cleanupExecutions$1(ExecutionInfo j) {
        return j.finishTimestamp() != 0L;
    }

    public static final /* synthetic */ boolean $anonfun$cleanupSession$1(SessionInfo j) {
        return j.finishTimestamp() != 0L;
    }

    public SparkConnectServerListener(ElementTrackingStore kvstore, SparkConf sparkConf, boolean live) {
        int n;
        int retainedSessions;
        block3: {
            Tuple2.mcII.sp sp2;
            block2: {
                this.kvstore = kvstore;
                this.live = live;
                Logging.$init$((Logging)this);
                this.sessionList = new ConcurrentHashMap<String, LiveSessionData>();
                this.executionList = new ConcurrentHashMap<String, LiveExecutionData>();
                sp2 = new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_UI_STATEMENT_LIMIT())), BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_UI_SESSION_LIMIT())));
                if (sp2 == null) break block2;
                int retainedStatements = sp2._1$mcI$sp();
                retainedSessions = sp2._2$mcI$sp();
                if (!true) break block2;
                n = retainedStatements;
                if (true) break block3;
            }
            throw new MatchError((Object)sp2);
        }
        int n2 = retainedSessions;
        this.x$1 = new Tuple2.mcII.sp(n, n2);
        this.retainedStatements = this.x$1._1$mcI$sp();
        this.retainedSessions = this.x$1._2$mcI$sp();
        this.liveUpdatePeriodNs = live ? BoxesRunTime.unboxToLong((Object)sparkConf.get(Status$.MODULE$.LIVE_ENTITY_UPDATE_PERIOD())) : -1L;
        kvstore.addTrigger(SessionInfo.class, (long)this.retainedSessions(), (Function1)(JFunction1.mcVJ.sp & Serializable)count -> this.cleanupSession(count));
        kvstore.addTrigger(ExecutionInfo.class, (long)this.retainedStatements(), (Function1)(JFunction1.mcVJ.sp & Serializable)count -> this.cleanupExecutions(count));
    }
}

