/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect;

import java.io.Serializable;
import org.apache.spark.annotation.Stable;
import org.apache.spark.connect.proto.Command;
import org.apache.spark.connect.proto.WriteOperation;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.connect.Dataset;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Stable
@ScalaSignature(bytes="\u0006\u0005\u0005\u001df\u0001\u0002\f\u0018\u0005\tB\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\u0007u\u0001!\t!G\u001e\t\u000by\u0002A\u0011I \t\u000by\u0002A\u0011\t$\t\u000bM\u0003A\u0011\t+\t\u000b]\u0003A\u0011\t-\t\u000b]\u0003A\u0011I/\t\u000b]\u0003A\u0011I2\t\u000b]\u0003A\u0011I5\t\u000b=\u0004A\u0011\t9\t\u000b=\u0004A\u0011\t=\t\u000f\u0005\r\u0001\u0001\"\u0011\u0002\u0006!9\u0011q\u0004\u0001\u0005B\u0005\u0005\u0002bBA\u001b\u0001\u0011\u0005\u0013q\u0007\u0005\b\u0003\u007f\u0001A\u0011IA!\u0011\u001d\tI\u0005\u0001C\u0001\u0003\u0017Bq!!\u0013\u0001\t\u0003\t9\u0006C\u0004\u0002Z\u0001!I!a\u0017\t\u000f\u0005\u0015\u0004\u0001\"\u0003\u0002h!9\u0011Q\u0012\u0001\u0005\u0002\u0005=\u0005bBAK\u0001\u0011\u0005\u0011q\u0013\u0002\u0010\t\u0006$\u0018M\u0012:b[\u0016<&/\u001b;fe*\u0011\u0001$G\u0001\bG>tg.Z2u\u0015\tQ2$A\u0002tc2T!\u0001H\u000f\u0002\u000bM\u0004\u0018M]6\u000b\u0005yy\u0012AB1qC\u000eDWMC\u0001!\u0003\ry'oZ\u0002\u0001+\t\u0019\u0013f\u0005\u0002\u0001IA\u0019QEJ\u0014\u000e\u0003eI!AF\r\u0011\u0005!JC\u0002\u0001\u0003\u0006U\u0001\u0011\ra\u000b\u0002\u0002)F\u0011AF\r\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\b\u001d>$\b.\u001b8h!\ti3'\u0003\u00025]\t\u0019\u0011I\\=\u0002\u0005\u0011\u001c\bcA\u001c9O5\tq#\u0003\u0002:/\t9A)\u0019;bg\u0016$\u0018A\u0002\u001fj]&$h\b\u0006\u0002={A\u0019q\u0007A\u0014\t\u000bU\u0012\u0001\u0019\u0001\u001c\u0002\t5|G-\u001a\u000b\u0003\u0001\u0006k\u0011\u0001\u0001\u0005\u0006\u0005\u000e\u0001\raQ\u0001\tg\u00064X-T8eKB\u0011Q\u0005R\u0005\u0003\u000bf\u0011\u0001bU1wK6{G-\u001a\u000b\u0003\u0001\u001eCQA\u0011\u0003A\u0002!\u0003\"!\u0013)\u000f\u0005)s\u0005CA&/\u001b\u0005a%BA'\"\u0003\u0019a$o\\8u}%\u0011qJL\u0001\u0007!J,G-\u001a4\n\u0005E\u0013&AB*ue&twM\u0003\u0002P]\u00051am\u001c:nCR$\"\u0001Q+\t\u000bY+\u0001\u0019\u0001%\u0002\rM|WO]2f\u0003\u0019y\u0007\u000f^5p]R\u0019\u0001)W.\t\u000bi3\u0001\u0019\u0001%\u0002\u0007-,\u0017\u0010C\u0003]\r\u0001\u0007\u0001*A\u0003wC2,X\rF\u0002A=~CQAW\u0004A\u0002!CQ\u0001X\u0004A\u0002\u0001\u0004\"!L1\n\u0005\tt#a\u0002\"p_2,\u0017M\u001c\u000b\u0004\u0001\u0012,\u0007\"\u0002.\t\u0001\u0004A\u0005\"\u0002/\t\u0001\u00041\u0007CA\u0017h\u0013\tAgF\u0001\u0003M_:<Gc\u0001!kW\")!,\u0003a\u0001\u0011\")A,\u0003a\u0001YB\u0011Q&\\\u0005\u0003]:\u0012a\u0001R8vE2,\u0017aB8qi&|gn\u001d\u000b\u0003\u0001FDQa\u001c\u0006A\u0002I\u0004Ba\u001d<I\u00116\tAO\u0003\u0002v]\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005]$(aA'baR\u0011\u0001)\u001f\u0005\u0006_.\u0001\rA\u001f\t\u0006w\u0006\u0005\u0001\nS\u0007\u0002y*\u0011QP`\u0001\u0005kRLGNC\u0001\u0000\u0003\u0011Q\u0017M^1\n\u0005]d\u0018a\u00039beRLG/[8o\u0005f$2\u0001QA\u0004\u0011\u001d\tI\u0001\u0004a\u0001\u0003\u0017\t\u0001bY8m\u001d\u0006lWm\u001d\t\u0005[\u00055\u0001*C\u0002\u0002\u00109\u0012!\u0002\u0010:fa\u0016\fG/\u001a3?Q\ra\u00111\u0003\t\u0005\u0003+\tY\"\u0004\u0002\u0002\u0018)\u0019\u0011\u0011\u0004\u0018\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u001e\u0005]!a\u0002<be\u0006\u0014xm]\u0001\tEV\u001c7.\u001a;CsR9\u0001)a\t\u0002.\u0005E\u0002bBA\u0013\u001b\u0001\u0007\u0011qE\u0001\u000b]Vl')^2lKR\u001c\bcA\u0017\u0002*%\u0019\u00111\u0006\u0018\u0003\u0007%sG\u000f\u0003\u0004\u000205\u0001\r\u0001S\u0001\bG>dg*Y7f\u0011\u001d\tI!\u0004a\u0001\u0003\u0017A3!DA\n\u0003\u0019\u0019xN\u001d;CsR)\u0001)!\u000f\u0002<!1\u0011q\u0006\bA\u0002!Cq!!\u0003\u000f\u0001\u0004\tY\u0001K\u0002\u000f\u0003'\t\u0011b\u00197vgR,'OQ=\u0015\u000b\u0001\u000b\u0019%!\u0012\t\r\u0005=r\u00021\u0001I\u0011\u001d\tIa\u0004a\u0001\u0003\u0017A3aDA\n\u0003\u0011\u0019\u0018M^3\u0015\t\u00055\u00131\u000b\t\u0004[\u0005=\u0013bAA)]\t!QK\\5u\u0011\u0019\t)\u0006\u0005a\u0001\u0011\u0006!\u0001/\u0019;i)\t\ti%\u0001\u0007tCZ,\u0017J\u001c;fe:\fG\u000e\u0006\u0003\u0002N\u0005u\u0003bBA+%\u0001\u0007\u0011q\f\t\u0005[\u0005\u0005\u0004*C\u0002\u0002d9\u0012aa\u00149uS>t\u0017!F3yK\u000e,H/Z,sSR,w\n]3sCRLwN\u001c\u000b\u0005\u0003\u001b\nI\u0007C\u0004\u0002lM\u0001\r!!\u001c\u0002\u0003\u0019\u0004r!LA8\u0003g\ni%C\u0002\u0002r9\u0012\u0011BR;oGRLwN\\\u0019\u0011\t\u0005U\u0014q\u0011\b\u0005\u0003o\n\tI\u0004\u0003\u0002z\u0005uTBAA>\u0015\tA2$\u0003\u0003\u0002\u0000\u0005m\u0014!\u00029s_R|\u0017\u0002BAB\u0003\u000b\u000bab\u0016:ji\u0016|\u0005/\u001a:bi&|gN\u0003\u0003\u0002\u0000\u0005m\u0014\u0002BAE\u0003\u0017\u0013qAQ;jY\u0012,'O\u0003\u0003\u0002\u0004\u0006\u0015\u0015AC5og\u0016\u0014H/\u00138u_R!\u0011QJAI\u0011\u0019\t\u0019\n\u0006a\u0001\u0011\u0006IA/\u00192mK:\u000bW.Z\u0001\fg\u00064X-Q:UC\ndW\r\u0006\u0003\u0002N\u0005e\u0005BBAJ+\u0001\u0007\u0001\nK\u0002\u0001\u0003;\u0003B!a(\u0002$6\u0011\u0011\u0011\u0015\u0006\u0004\u00033Y\u0012\u0002BAS\u0003C\u0013aa\u0015;bE2,\u0007")
public final class DataFrameWriter<T>
extends org.apache.spark.sql.DataFrameWriter<T> {
    private final Dataset<T> ds;

    @Override
    public DataFrameWriter<T> partitionBy(String ... colNames) {
        return this.partitionBy((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])colNames));
    }

    @Override
    public DataFrameWriter<T> bucketBy(int numBuckets, String colName, String ... colNames) {
        return this.bucketBy(numBuckets, colName, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])colNames));
    }

    @Override
    public DataFrameWriter<T> sortBy(String colName, String ... colNames) {
        return this.sortBy(colName, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])colNames));
    }

    @Override
    public DataFrameWriter<T> clusterBy(String colName, String ... colNames) {
        return this.clusterBy(colName, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])colNames));
    }

    @Override
    public DataFrameWriter<T> mode(SaveMode saveMode) {
        return (DataFrameWriter)super.mode(saveMode);
    }

    @Override
    public DataFrameWriter<T> mode(String saveMode) {
        return (DataFrameWriter)super.mode(saveMode);
    }

    @Override
    public DataFrameWriter<T> format(String source) {
        return (DataFrameWriter)super.format(source);
    }

    @Override
    public DataFrameWriter<T> option(String key, String value) {
        return (DataFrameWriter)super.option(key, value);
    }

    @Override
    public DataFrameWriter<T> option(String key, boolean value) {
        return (DataFrameWriter)super.option(key, value);
    }

    @Override
    public DataFrameWriter<T> option(String key, long value) {
        return (DataFrameWriter)super.option(key, value);
    }

    @Override
    public DataFrameWriter<T> option(String key, double value) {
        return (DataFrameWriter)super.option(key, value);
    }

    @Override
    public DataFrameWriter<T> options(Map<String, String> options) {
        return (DataFrameWriter)super.options(options);
    }

    @Override
    public DataFrameWriter<T> options(java.util.Map<String, String> options) {
        return (DataFrameWriter)super.options(options);
    }

    @Override
    public DataFrameWriter<T> partitionBy(scala.collection.immutable.Seq<String> colNames) {
        return (DataFrameWriter)super.partitionBy(colNames);
    }

    @Override
    public DataFrameWriter<T> bucketBy(int numBuckets, String colName, scala.collection.immutable.Seq<String> colNames) {
        return (DataFrameWriter)super.bucketBy(numBuckets, colName, colNames);
    }

    @Override
    public DataFrameWriter<T> sortBy(String colName, scala.collection.immutable.Seq<String> colNames) {
        return (DataFrameWriter)super.sortBy(colName, colNames);
    }

    @Override
    public DataFrameWriter<T> clusterBy(String colName, scala.collection.immutable.Seq<String> colNames) {
        return (DataFrameWriter)super.clusterBy(colName, colNames);
    }

    @Override
    public void save(String path) {
        this.saveInternal((Option<String>)new Some((Object)path));
    }

    @Override
    public void save() {
        this.saveInternal((Option<String>)None$.MODULE$);
    }

    private void saveInternal(Option<String> path) {
        this.executeWriteOperation((Function1<WriteOperation.Builder, BoxedUnit>)(Function1 & Serializable)builder -> {
            path.foreach((Function1 & Serializable)value -> builder.setPath((String)value));
            return BoxedUnit.UNIT;
        });
    }

    private void executeWriteOperation(Function1<WriteOperation.Builder, BoxedUnit> f) {
        WriteOperation.SaveMode saveMode;
        WriteOperation.Builder builder = WriteOperation.newBuilder();
        builder.setInput(this.ds.plan().getRoot());
        f.apply((Object)builder);
        Predef$.MODULE$.require(!builder.hasPath() || !builder.hasTable());
        SaveMode saveMode2 = this.curmode();
        if (((Object)((Object)SaveMode.Append)).equals((Object)saveMode2)) {
            saveMode = WriteOperation.SaveMode.SAVE_MODE_APPEND;
        } else if (((Object)((Object)SaveMode.Overwrite)).equals((Object)saveMode2)) {
            saveMode = WriteOperation.SaveMode.SAVE_MODE_OVERWRITE;
        } else if (((Object)((Object)SaveMode.Ignore)).equals((Object)saveMode2)) {
            saveMode = WriteOperation.SaveMode.SAVE_MODE_IGNORE;
        } else if (((Object)((Object)SaveMode.ErrorIfExists)).equals((Object)saveMode2)) {
            saveMode = WriteOperation.SaveMode.SAVE_MODE_ERROR_IF_EXISTS;
        } else {
            throw new MatchError((Object)saveMode2);
        }
        builder.setMode(saveMode);
        Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.source())) ? builder.setSource(this.source()) : BoxedUnit.UNIT;
        this.sortColumnNames().foreach((Function1 & Serializable)names -> builder.addAllSortColumnNames(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)names).asJava()));
        this.partitioningColumns().foreach((Function1 & Serializable)cols -> builder.addAllPartitioningColumns(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)cols).asJava()));
        this.clusteringColumns().foreach((Function1 & Serializable)cols -> builder.addAllClusteringColumns(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)cols).asJava()));
        this.numBuckets().foreach((Function1 & Serializable)n -> DataFrameWriter.$anonfun$executeWriteOperation$4(this, builder, BoxesRunTime.unboxToInt((Object)n)));
        this.extraOptions().foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return builder.putOptions(k, v);
            }
            throw new MatchError((Object)tuple2);
        });
        this.ds.sparkSession().execute(Command.newBuilder().setWriteOperation(builder).build());
    }

    @Override
    public void insertInto(String tableName) {
        this.executeWriteOperation((Function1<WriteOperation.Builder, BoxedUnit>)(Function1 & Serializable)builder -> {
            builder.setTable(WriteOperation.SaveTable.newBuilder().setTableName(tableName).setSaveMethod(WriteOperation.SaveTable.TableSaveMethod.TABLE_SAVE_METHOD_INSERT_INTO));
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void saveAsTable(String tableName) {
        this.executeWriteOperation((Function1<WriteOperation.Builder, BoxedUnit>)(Function1 & Serializable)builder -> {
            builder.setTable(WriteOperation.SaveTable.newBuilder().setTableName(tableName).setSaveMethod(WriteOperation.SaveTable.TableSaveMethod.TABLE_SAVE_METHOD_SAVE_AS_TABLE));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ WriteOperation.Builder $anonfun$executeWriteOperation$4(DataFrameWriter $this, WriteOperation.Builder builder$2, int n) {
        WriteOperation.BucketBy.Builder bucketBuilder = WriteOperation.BucketBy.newBuilder();
        bucketBuilder.setNumBuckets(n);
        $this.bucketColumnNames().foreach((Function1 & Serializable)names -> bucketBuilder.addAllBucketColumnNames(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)names).asJava()));
        return builder$2.setBucketBy(bucketBuilder);
    }

    public DataFrameWriter(Dataset<T> ds) {
        this.ds = ds;
    }
}

