/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.runtime;

import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.sql.streaming.StreamingQueryProgress;
import org.apache.spark.util.Clock;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.StringContext;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005g\u0001\u0002\u0010 \u00019B\u0001b\u000f\u0001\u0003\u0006\u0004%I\u0001\u0010\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005{!AA\t\u0001BC\u0002\u0013%Q\t\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003G\u0011!i\u0005A!b\u0001\n\u0003q\u0005\u0002\u0003/\u0001\u0005\u0003\u0005\u000b\u0011B(\t\u000bu\u0003A\u0011\u00010\t\u000f\u0011\u0004\u0001\u0019!C\u0001K\"9\u0011\u000e\u0001a\u0001\n\u0003Q\u0007B\u00029\u0001A\u0003&a\rC\u0004r\u0001\t\u0007I\u0011\u0001:\t\ry\u0004\u0001\u0015!\u0003t\u0011!y\bA1A\u0005\n\u0005\u0005\u0001\u0002CA\u000f\u0001\u0001\u0006I!a\u0001\t\u0011\u0005}\u0001A1A\u0005\u0002\u0015Dq!!\t\u0001A\u0003%a\rC\u0005\u0002$\u0001\u0011\r\u0011\"\u0001\u0002&!A\u0011Q\u0006\u0001!\u0002\u0013\t9\u0003C\u0005\u00020\u0001\u0011\r\u0011\"\u0001\u00022!A\u0011q\b\u0001!\u0002\u0013\t\u0019\u0004C\u0005\u0002B\u0001\u0011\r\u0011\"\u0003\u0002D!A\u0011Q\u000b\u0001!\u0002\u0013\t)\u0005C\u0004\u0002X\u0001!\t!!\u0017\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002d!9\u0011Q\r\u0001\u0005\u0002\u0005\u001d\u0004bBA7\u0001\u0011%\u0011q\u000e\u0005\b\u0003g\u0002A\u0011AA;\u0011\u001d\ti\t\u0001C\u0005\u0003\u001fCq!a)\u0001\t\u0003\t)K\u0001\tQe><'/Z:t%\u0016\u0004xN\u001d;fe*\u0011\u0001%I\u0001\beVtG/[7f\u0015\t\u00113%A\u0005tiJ,\u0017-\\5oO*\u0011A%J\u0001\nKb,7-\u001e;j_:T!AJ\u0014\u0002\u0007M\fHN\u0003\u0002)S\u0005)1\u000f]1sW*\u0011!fK\u0001\u0007CB\f7\r[3\u000b\u00031\n1a\u001c:h\u0007\u0001\u00192\u0001A\u00186!\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0005\u0019\te.\u001f*fMB\u0011a'O\u0007\u0002o)\u0011\u0001hJ\u0001\tS:$XM\u001d8bY&\u0011!h\u000e\u0002\b\u0019><w-\u001b8h\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o+\u0005i\u0004C\u0001 B\u001b\u0005y$B\u0001!&\u0003\u001d\u0019G.Y:tS\u000eL!AQ \u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\u001bM\u0004\u0018M]6TKN\u001c\u0018n\u001c8!\u00031!(/[4hKJ\u001cEn\\2l+\u00051\u0005CA$K\u001b\u0005A%BA%(\u0003\u0011)H/\u001b7\n\u0005-C%!B\"m_\u000e\\\u0017!\u0004;sS\u001e<WM]\"m_\u000e\\\u0007%A\u0006m_\u001eL7-\u00197QY\u0006tW#A(\u0011\u0007A\u0002&+\u0003\u0002Rc\tIa)\u001e8di&|g\u000e\r\t\u0003'jk\u0011\u0001\u0016\u0006\u0003+Z\u000bq\u0001\\8hS\u000e\fGN\u0003\u0002X1\u0006)\u0001\u000f\\1og*\u0011\u0011,J\u0001\tG\u0006$\u0018\r\\=ti&\u00111\f\u0016\u0002\f\u0019><\u0017nY1m!2\fg.\u0001\u0007m_\u001eL7-\u00197QY\u0006t\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005?\u0006\u00147\r\u0005\u0002a\u00015\tq\u0004C\u0003<\u000f\u0001\u0007Q\bC\u0003E\u000f\u0001\u0007a\tC\u0003N\u000f\u0001\u0007q*\u0001\u0011mCN$hj\\#yK\u000e,H/[8o!J|wM]3tg\u00163XM\u001c;US6,W#\u00014\u0011\u0005A:\u0017B\u000152\u0005\u0011auN\\4\u0002I1\f7\u000f\u001e(p\u000bb,7-\u001e;j_:\u0004&o\\4sKN\u001cXI^3oiRKW.Z0%KF$\"a\u001b8\u0011\u0005Ab\u0017BA72\u0005\u0011)f.\u001b;\t\u000f=L\u0011\u0011!a\u0001M\u0006\u0019\u0001\u0010J\u0019\u0002C1\f7\u000f\u001e(p\u000bb,7-\u001e;j_:\u0004&o\\4sKN\u001cXI^3oiRKW.\u001a\u0011\u0002=MDw.\u001e7e-\u0006d\u0017\u000eZ1uKN#\u0018\r^3Ti>\u0014XmQ8n[&$X#A:\u0011\u0005QdX\"A;\u000b\u0005Y<\u0018AB1u_6L7M\u0003\u0002ys\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005%S(\"A>\u0002\t)\fg/Y\u0005\u0003{V\u0014Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017aH:i_VdGMV1mS\u0012\fG/Z*uCR,7\u000b^8sK\u000e{W.\\5uA\u0005q\u0001O]8he\u0016\u001c8OQ;gM\u0016\u0014XCAA\u0002!\u0019\t)!a\u0004\u0002\u00145\u0011\u0011q\u0001\u0006\u0005\u0003\u0013\tY!A\u0004nkR\f'\r\\3\u000b\u0007\u00055\u0011'\u0001\u0006d_2dWm\u0019;j_:LA!!\u0005\u0002\b\t)\u0011+^3vKB!\u0011QCA\r\u001b\t\t9B\u0003\u0002#K%!\u00111DA\f\u0005Y\u0019FO]3b[&tw-U;fef\u0004&o\\4sKN\u001c\u0018a\u00049s_\u001e\u0014Xm]:Ck\u001a4WM\u001d\u0011\u000279|G)\u0019;b!J|wM]3tg\u00163XM\u001c;J]R,'O^1m\u0003qqw\u000eR1uCB\u0013xn\u001a:fgN,e/\u001a8u\u0013:$XM\u001d<bY\u0002\n!eY8pe\u0012Lg.\u0019;peJ+\u0007o\u001c:u':\f\u0007o\u001d5piV\u0003Hn\\1e\u0019\u0006<WCAA\u0014!\r\u0001\u0014\u0011F\u0005\u0004\u0003W\t$a\u0002\"p_2,\u0017M\\\u0001$G>|'\u000fZ5oCR|'OU3q_J$8K\\1qg\"|G/\u00169m_\u0006$G*Y4!\u0003U\u0019H/\u0019;f'R|'/Z\"p_J$\u0017N\\1u_J,\"!a\r\u0011\t\u0005U\u00121H\u0007\u0003\u0003oQ1!!\u000f\"\u0003\u0015\u0019H/\u0019;f\u0013\u0011\ti$a\u000e\u00031M#\u0018\r^3Ti>\u0014XmQ8pe\u0012Lg.\u0019;peJ+g-\u0001\fti\u0006$Xm\u0015;pe\u0016\u001cun\u001c:eS:\fGo\u001c:!\u0003=!\u0018.\\3ti\u0006l\u0007OR8s[\u0006$XCAA#!\u0011\t9%!\u0015\u000e\u0005\u0005%#\u0002BA&\u0003\u001b\naAZ8s[\u0006$(bAA(u\u0006!A/[7f\u0013\u0011\t\u0019&!\u0013\u0003#\u0011\u000bG/\u001a+j[\u00164uN]7biR,'/\u0001\tuS6,7\u000f^1na\u001a{'/\\1uA\u0005q!/Z2f]R\u0004&o\\4sKN\u001cXCAA.!\u0015\u0001\u0014QLA\n\u0013\r\ty&\r\u0002\u0006\u0003J\u0014\u0018-_\u0001\rY\u0006\u001cH\u000f\u0015:pOJ,7o]\u000b\u0003\u0003'\ta\"\u001e9eCR,\u0007K]8he\u0016\u001c8\u000fF\u0002l\u0003SBq!a\u001b\u001a\u0001\u0004\t\u0019\"A\u0006oK^\u0004&o\\4sKN\u001c\u0018AD1eI:+w\u000f\u0015:pOJ,7o\u001d\u000b\u0004W\u0006E\u0004bBA65\u0001\u0007\u00111C\u0001\u000fkB$\u0017\r^3JI2,g.Z:t)%Y\u0017qOAB\u0003\u000f\u000bY\tC\u0004\u0002zm\u0001\r!a\u001f\u0002\u0005%$\u0007\u0003BA?\u0003\u007fj\u0011!_\u0005\u0004\u0003\u0003K(\u0001B+V\u0013\u0012Cq!!\"\u001c\u0001\u0004\tY(A\u0003sk:LE\r\u0003\u0004\u0002\nn\u0001\rAZ\u0001\u001dGV\u0014(/\u001a8u)JLwmZ3s'R\f'\u000f\u001e+j[\u0016\u001cH/Y7q\u0011\u001d\tYg\u0007a\u0001\u0003'\t\u0011\u0002]8ti\u00163XM\u001c;\u0015\u0007-\f\t\nC\u0004\u0002\u0014r\u0001\r!!&\u0002\u000b\u00154XM\u001c;\u0011\t\u0005]\u0015Q\u0014\b\u0005\u0003+\tI*\u0003\u0003\u0002\u001c\u0006]\u0011AF*ue\u0016\fW.\u001b8h#V,'/\u001f'jgR,g.\u001a:\n\t\u0005}\u0015\u0011\u0015\u0002\u0006\u000bZ,g\u000e\u001e\u0006\u0005\u00037\u000b9\"A\bg_Jl\u0017\r\u001e+j[\u0016\u001cH/Y7q)\u0011\t9+!0\u0011\t\u0005%\u0016q\u0017\b\u0005\u0003W\u000b\u0019\fE\u0002\u0002.Fj!!a,\u000b\u0007\u0005EV&\u0001\u0004=e>|GOP\u0005\u0004\u0003k\u000b\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002:\u0006m&AB*ue&twMC\u0002\u00026FBa!a0\u001e\u0001\u00041\u0017AB7jY2L7\u000f")
public class ProgressReporter
implements Logging {
    private final SparkSession sparkSession;
    private final Clock triggerClock;
    private final Function0<LogicalPlan> logicalPlan;
    private long lastNoExecutionProgressEventTime;
    private final AtomicBoolean shouldValidateStateStoreCommit;
    private final Queue<StreamingQueryProgress> progressBuffer;
    private final long noDataProgressEventInterval;
    private final boolean coordinatorReportSnapshotUploadLag;
    private final StateStoreCoordinatorRef stateStoreCoordinator;
    private final DateTimeFormatter timestampFormat;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkSession sparkSession() {
        return this.sparkSession;
    }

    private Clock triggerClock() {
        return this.triggerClock;
    }

    public Function0<LogicalPlan> logicalPlan() {
        return this.logicalPlan;
    }

    public long lastNoExecutionProgressEventTime() {
        return this.lastNoExecutionProgressEventTime;
    }

    public void lastNoExecutionProgressEventTime_$eq(long x$1) {
        this.lastNoExecutionProgressEventTime = x$1;
    }

    public AtomicBoolean shouldValidateStateStoreCommit() {
        return this.shouldValidateStateStoreCommit;
    }

    private Queue<StreamingQueryProgress> progressBuffer() {
        return this.progressBuffer;
    }

    public long noDataProgressEventInterval() {
        return this.noDataProgressEventInterval;
    }

    public boolean coordinatorReportSnapshotUploadLag() {
        return this.coordinatorReportSnapshotUploadLag;
    }

    public StateStoreCoordinatorRef stateStoreCoordinator() {
        return this.stateStoreCoordinator;
    }

    private DateTimeFormatter timestampFormat() {
        return this.timestampFormat;
    }

    public StreamingQueryProgress[] recentProgress() {
        StreamingQueryProgress[] streamingQueryProgressArray;
        Queue<StreamingQueryProgress> queue = this.progressBuffer();
        synchronized (queue) {
            streamingQueryProgressArray = (StreamingQueryProgress[])this.progressBuffer().toArray(ClassTag$.MODULE$.apply(StreamingQueryProgress.class));
        }
        return streamingQueryProgressArray;
    }

    public StreamingQueryProgress lastProgress() {
        StreamingQueryProgress streamingQueryProgress;
        Queue<StreamingQueryProgress> queue = this.progressBuffer();
        synchronized (queue) {
            streamingQueryProgress = (StreamingQueryProgress)this.progressBuffer().lastOption().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return streamingQueryProgress;
    }

    public void updateProgress(StreamingQueryProgress newProgress) {
        this.lastNoExecutionProgressEventTime_$eq(this.triggerClock().getTimeMillis());
        this.addNewProgress(newProgress);
        this.postEvent((StreamingQueryListener.Event)new StreamingQueryListener.QueryProgressEvent(newProgress));
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Streaming query made progress: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.STREAMING_QUERY_PROGRESS, newProgress)}))));
    }

    private void addNewProgress(StreamingQueryProgress newProgress) {
        Queue<StreamingQueryProgress> queue = this.progressBuffer();
        synchronized (queue) {
            this.progressBuffer().$plus$eq((Object)newProgress);
            while (this.progressBuffer().length() >= this.sparkSession().sessionState().conf().streamingProgressRetention()) {
                this.progressBuffer().dequeue();
            }
        }
    }

    public void updateIdleness(UUID id, UUID runId, long currentTriggerStartTimestamp, StreamingQueryProgress newProgress) {
        long now = this.triggerClock().getTimeMillis();
        if (now - this.noDataProgressEventInterval() >= this.lastNoExecutionProgressEventTime()) {
            this.addNewProgress(newProgress);
            if (this.lastNoExecutionProgressEventTime() > Long.MIN_VALUE) {
                this.postEvent((StreamingQueryListener.Event)new StreamingQueryListener.QueryIdleEvent(id, runId, this.formatTimestamp(currentTriggerStartTimestamp)));
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Streaming query has been idle and waiting for new data more than "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " ms."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.TIME_UNITS, BoxesRunTime.boxToLong((long)this.noDataProgressEventInterval()))})))));
            }
            this.lastNoExecutionProgressEventTime_$eq(now);
            return;
        }
    }

    private void postEvent(StreamingQueryListener.Event event) {
        this.sparkSession().streams().postListenerEvent(event);
    }

    public String formatTimestamp(long millis) {
        return Instant.ofEpochMilli(millis).atZone(ZoneId.of("Z")).format(this.timestampFormat());
    }

    public ProgressReporter(SparkSession sparkSession, Clock triggerClock, Function0<LogicalPlan> logicalPlan2) {
        this.sparkSession = sparkSession;
        this.triggerClock = triggerClock;
        this.logicalPlan = logicalPlan2;
        Logging.$init$((Logging)this);
        this.lastNoExecutionProgressEventTime = Long.MIN_VALUE;
        this.shouldValidateStateStoreCommit = new AtomicBoolean(false);
        this.progressBuffer = new Queue(Queue$.MODULE$.$lessinit$greater$default$1());
        this.noDataProgressEventInterval = sparkSession.sessionState().conf().streamingNoDataProgressEventInterval();
        this.coordinatorReportSnapshotUploadLag = sparkSession.sessionState().conf().stateStoreCoordinatorReportSnapshotUploadLag();
        this.stateStoreCoordinator = sparkSession.sessionState().streamingQueryManager().stateStoreCoordinator();
        this.timestampFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZone(DateTimeUtils$.MODULE$.getZoneId("UTC"));
    }
}

