/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.SequenceFile;
import org.apache.spark.sql.catalyst.util.HadoopCompressionCodec;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.util.Utils$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class CompressionCodecs$ {
    public static final CompressionCodecs$ MODULE$ = new CompressionCodecs$();
    private static final Map<String, String> shortCompressionCodecNames = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])HadoopCompressionCodec.values()), (Function1 & Serializable)codec -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)codec.lowerCaseName()), Option$.MODULE$.apply((Object)codec.getCompressionCodec()).map((Function1 & Serializable)x$1 -> x$1.getClass().getName()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());

    private Map<String, String> shortCompressionCodecNames() {
        return shortCompressionCodecNames;
    }

    public String getCodecClassName(String name) {
        String string;
        String codecName = (String)this.shortCompressionCodecNames().getOrElse((Object)name.toLowerCase(Locale.ROOT), (Function0 & Serializable)() -> name);
        try {
            Object object = codecName != null ? Utils$.MODULE$.classForName(codecName, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3()) : BoxedUnit.UNIT;
            string = codecName;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw QueryExecutionErrors$.MODULE$.codecNotAvailableError(codecName, this.shortCompressionCodecNames().keys().mkString(", "));
        }
        return string;
    }

    public void setCodecConfiguration(Configuration conf, String codec) {
        if (codec != null) {
            conf.set("mapreduce.output.fileoutputformat.compress", "true");
            conf.set("mapreduce.output.fileoutputformat.compress.type", SequenceFile.CompressionType.BLOCK.toString());
            conf.set("mapreduce.output.fileoutputformat.compress.codec", codec);
            conf.set("mapreduce.map.output.compress", "true");
            conf.set("mapreduce.map.output.compress.codec", codec);
            return;
        }
        conf.set("mapreduce.output.fileoutputformat.compress", "false");
        conf.set("mapreduce.map.output.compress", "false");
    }

    private CompressionCodecs$() {
    }
}

