/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.xml;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.spark.TaskContext$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.FailureSafeParser;
import org.apache.spark.sql.catalyst.xml.StaxXmlParser;
import org.apache.spark.sql.catalyst.xml.XmlInferSchema;
import org.apache.spark.sql.catalyst.xml.XmlOptions;
import org.apache.spark.sql.classic.ClassicConversions$;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.HadoopFileLinesReader;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.text.TextFileFormat;
import org.apache.spark.sql.execution.datasources.xml.XmlDataSource;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class TextInputXmlDataSource$
extends XmlDataSource {
    public static final TextInputXmlDataSource$ MODULE$ = new TextInputXmlDataSource$();
    private static final boolean isSplitable = true;

    @Override
    public boolean isSplitable() {
        return isSplitable;
    }

    @Override
    public Iterator<InternalRow> readFile(Configuration conf, PartitionedFile file, StaxXmlParser parser, StructType schema) {
        HadoopFileLinesReader linesReader = (HadoopFileLinesReader)Utils$.MODULE$.createResourceUninterruptiblyIfInTaskThread((Function0 & Serializable)() -> new HadoopFileLinesReader(file, (Option<byte[]>)None$.MODULE$, conf));
        Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1 & Serializable)x$1 -> x$1.addTaskCompletionListener((Function1 & Serializable)x$2 -> {
            linesReader.close();
            return BoxedUnit.UNIT;
        }));
        Iterator lines = linesReader.map((Function1 & Serializable)line -> new String(line.getBytes(), 0, line.getLength(), parser.options().charset()));
        FailureSafeParser safeParser = new FailureSafeParser((Function1 & Serializable)input -> Option$.MODULE$.option2Iterable((Option)parser.parse().apply(input)), parser.options().parseMode(), schema, parser.options().columnNameOfCorruptRecord());
        return lines.flatMap((Function1 & Serializable)input -> safeParser.parse(input));
    }

    @Override
    public StructType infer(SparkSession sparkSession, Seq<FileStatus> inputPaths, XmlOptions parsedOptions) {
        Dataset<String> xml = this.createBaseDataset(sparkSession, inputPaths, parsedOptions);
        return this.inferFromDataset(xml, parsedOptions);
    }

    public StructType inferFromDataset(Dataset<String> xml, XmlOptions parsedOptions) {
        return (StructType)SQLExecution$.MODULE$.withSQLConfPropagated(ClassicConversions$.MODULE$.castToImpl(xml.sparkSession()), (Function0 & Serializable)() -> new XmlInferSchema(parsedOptions, xml.sparkSession().sessionState().conf().caseSensitiveAnalysis()).infer(xml.rdd()));
    }

    private Dataset<String> createBaseDataset(SparkSession sparkSession, Seq<FileStatus> inputPaths, XmlOptions options) {
        Seq paths = (Seq)inputPaths.map((Function1 & Serializable)x$3 -> x$3.getPath().toString());
        SparkSession x$1 = sparkSession;
        Seq x$2 = paths;
        String x$32 = TextFileFormat.class.getName();
        CaseInsensitiveMap x$4 = options.parameters().$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSource$.MODULE$.GLOB_PATHS_KEY()), (Object)"false")})));
        Option<StructType> x$5 = DataSource$.MODULE$.apply$default$4();
        Seq<String> x$6 = DataSource$.MODULE$.apply$default$5();
        Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$8 = DataSource$.MODULE$.apply$default$8();
        DataSource qual$1 = new DataSource(x$1, x$32, (Seq<String>)x$2, x$5, x$6, x$7, (Map<String, String>)x$4, x$8);
        boolean x$9 = false;
        boolean x$10 = qual$1.resolveRelation$default$2();
        Dataset df = sparkSession.baseRelationToDataFrame(qual$1.resolveRelation(false, x$10)).select("value", (Seq)Nil$.MODULE$).as(Encoders$.MODULE$.STRING());
        Charset charset = Charset.forName(options.charset());
        Charset charset2 = StandardCharsets.UTF_8;
        if (!(charset != null ? !((Object)charset).equals(charset2) : charset2 != null)) {
            return df;
        }
        String charset3 = options.charset();
        return sparkSession.createDataset(df.queryExecution().toRdd().map((Function1 & Serializable)row -> {
            byte[] bytes = row.getBinary(0);
            return new String(bytes, 0, bytes.length, charset3);
        }, ClassTag$.MODULE$.apply(String.class)), Encoders$.MODULE$.STRING());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TextInputXmlDataSource$.class);
    }

    private TextInputXmlDataSource$() {
    }
}

