/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.service;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import org.apache.spark.SparkRuntimeException;
import org.apache.spark.connect.proto.AddArtifactsRequest;
import org.apache.spark.connect.proto.AddArtifactsResponse;
import org.apache.spark.sql.artifact.ArtifactManager$;
import org.apache.spark.sql.connect.service.ExecuteEventsManager;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.connect.service.SparkConnectService$;
import org.apache.spark.sql.connect.utils.ErrorUtils$;
import org.apache.spark.sql.util.ArtifactUtils$;
import org.apache.spark.util.Utils$;
import org.sparkproject.connect.grpc.stub.StreamObserver;
import org.sparkproject.connect.guava.io.CountingOutputStream;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\r=a\u0001B&M\u0001eC\u0001b\u001d\u0001\u0003\u0006\u0004%\t\u0001\u001e\u0005\ts\u0002\u0011\t\u0011)A\u0005k\")!\u0010\u0001C\u0001w\"Aq\u0010\u0001b\u0001\n#\t\t\u0001\u0003\u0005\u0002\u0014\u0001\u0001\u000b\u0011BA\u0002\u0011%\t)\u0002\u0001b\u0001\n#\t9\u0002\u0003\u0005\u0003h\u0001\u0001\u000b\u0011BA\r\u0011-\u0011I\u0007\u0001a\u0001\u0002\u0004%IAa\u001b\t\u0017\t\u001d\u0006\u00011AA\u0002\u0013%!\u0011\u0016\u0005\f\u0005[\u0003\u0001\u0019!A!B\u0013\u0011i\u0007C\u0006\u00030\u0002\u0001\r\u00111A\u0005\n\tE\u0006b\u0003B]\u0001\u0001\u0007\t\u0019!C\u0005\u0005wC1Ba0\u0001\u0001\u0004\u0005\t\u0015)\u0003\u00034\"9!\u0011\u0019\u0001\u0005B\t\r\u0007b\u0002Be\u0001\u0011\u0005#1\u001a\u0005\b\u0005G\u0004A\u0011\u0003Bs\u0011\u001d\u0011Y\u000f\u0001C\t\u0005[DqA!>\u0001\t#\u0011\t\u0007C\u0004\u0003x\u0002!\tE!\u0019\t\u000f\te\b\u0001\"\u0003\u0003|\"9!\u0011 \u0001\u0005\n\r\u0015aABA\u0019\u0001\u0001\t\u0019\u0004\u0003\u0006\u0002>Y\u0011)\u0019!C\u0001\u0003\u007fA!\"a\u0016\u0017\u0005\u0003\u0005\u000b\u0011BA!\u0011\u0019Qh\u0003\"\u0001\u0002Z!a\u0011Q\f\f\u0011\u0002\u0003\r\t\u0015!\u0003\u0002`!I\u0011q\u000e\fC\u0002\u0013\u0005\u0011q\b\u0005\t\u0003c2\u0002\u0015!\u0003\u0002B!I\u00111\u000f\fC\u0002\u0013\u0005\u0011Q\u000f\u0005\t\u0003s2\u0002\u0015!\u0003\u0002x!I\u00111\u0010\fC\u0002\u0013\u0005\u0011\u0011\u0001\u0005\t\u0003{2\u0002\u0015!\u0003\u0002\u0004!I\u0011q\u0010\fC\u0002\u0013\u0005\u0011\u0011\u0001\u0005\t\u0003\u00033\u0002\u0015!\u0003\u0002\u0004!I\u00111\u0011\fC\u0002\u0013%\u0011Q\u0011\u0005\t\u0003#3\u0002\u0015!\u0003\u0002\b\"I\u00111\u0013\fC\u0002\u0013%\u0011Q\u0013\u0005\t\u0003[3\u0002\u0015!\u0003\u0002\u0018\"I\u0011q\u0016\fC\u0002\u0013%\u0011\u0011\u0017\u0005\t\u0003\u00074\u0002\u0015!\u0003\u00024\"I\u0011Q\u0019\fC\u0002\u0013%\u0011q\u0019\u0005\t\u0003\u001f4\u0002\u0015!\u0003\u0002J\"I\u0011\u0011\u001b\fC\u0002\u0013%\u00111\u001b\u0005\t\u0003\u007f4\u0002\u0015!\u0003\u0002V\"Y!\u0011\u0001\fA\u0002\u0003\u0007I\u0011\u0002B\u0002\u0011-\u0011YA\u0006a\u0001\u0002\u0004%IA!\u0004\t\u0017\tea\u00031A\u0001B\u0003&!Q\u0001\u0005\f\u000571\u0002\u0019!a\u0001\n#\u0011i\u0002C\u0006\u0003&Y\u0001\r\u00111A\u0005\u0012\t\u001d\u0002b\u0003B\u0016-\u0001\u0007\t\u0011)Q\u0005\u0005?AqA!\f\u0017\t#\u0011y\u0003C\u0004\u00036Y!\tAa\u000e\t\u000f\tmb\u0003\"\u0001\u0003>!9!Q\t\f\u0005\u0002\t\u001d\u0003b\u0002B0-\u0011\u0005!\u0011\r\u0005\b\u0005G2B\u0011\u0001B3\r\u0019\u0011y\u0007\u0001\u0001\u0003r!Y\u0011QH\u001d\u0003\u0002\u0003\u0006I!!\u0011\u0018\u0011)\u0011\u0019(\u000fB\u0001B\u0003%!q\b\u0005\u000b\u0005kJ$\u0011!Q\u0001\n\t}\u0002B\u0002>:\t\u0003\u00119\bC\u0005\u0003\u0000e\u0002\r\u0011\"\u0003\u0003>!I!\u0011Q\u001dA\u0002\u0013%!1\u0011\u0005\t\u0005\u000fK\u0004\u0015)\u0003\u0003@!I!\u0011R\u001dA\u0002\u0013%!Q\b\u0005\n\u0005\u0017K\u0004\u0019!C\u0005\u0005\u001bC\u0001B!%:A\u0003&!q\b\u0005\n\u0005'K\u0004\u0019!C\u0005\u0005;A\u0011B!&:\u0001\u0004%IAa&\t\u0011\tm\u0015\b)Q\u0005\u0005?AqA!(:\t\u0003\u0011i\u0002C\u0004\u0003.e\"\tFa(\t\u000f\t\u0015\u0013\b\"\u0011\u0003$\"9!qL\u001d\u0005B\t\u0005$aH*qCJ\\7i\u001c8oK\u000e$\u0018\t\u001a3BeRLg-Y2ug\"\u000bg\u000e\u001a7fe*\u0011QJT\u0001\bg\u0016\u0014h/[2f\u0015\ty\u0005+A\u0004d_:tWm\u0019;\u000b\u0005E\u0013\u0016aA:rY*\u00111\u000bV\u0001\u0006gB\f'o\u001b\u0006\u0003+Z\u000ba!\u00199bG\",'\"A,\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Q&\r\u0005\u0002\\A6\tAL\u0003\u0002^=\u0006!A.\u00198h\u0015\u0005y\u0016\u0001\u00026bm\u0006L!!\u0019/\u0003\r=\u0013'.Z2u!\r\u0019'\u000e\\\u0007\u0002I*\u0011QMZ\u0001\u0005gR,(M\u0003\u0002hQ\u0006!qM\u001d9d\u0015\u0005I\u0017AA5p\u0013\tYGM\u0001\bTiJ,\u0017-\\(cg\u0016\u0014h/\u001a:\u0011\u00055\fX\"\u00018\u000b\u0005=\u0004\u0018!\u00029s_R|'BA(S\u0013\t\u0011hNA\nBI\u0012\f%\u000f^5gC\u000e$8OU3rk\u0016\u001cH/\u0001\tsKN\u0004xN\\:f\u001f\n\u001cXM\u001d<feV\tQ\u000fE\u0002dUZ\u0004\"!\\<\n\u0005at'\u0001F!eI\u0006\u0013H/\u001b4bGR\u001c(+Z:q_:\u001cX-A\tsKN\u0004xN\\:f\u001f\n\u001cXM\u001d<fe\u0002\na\u0001P5oSRtDC\u0001?\u007f!\ti\b!D\u0001M\u0011\u0015\u00198\u00011\u0001v\u0003)\u0019H/Y4j]\u001e$\u0015N]\u000b\u0003\u0003\u0007\u0001B!!\u0002\u0002\u00105\u0011\u0011q\u0001\u0006\u0005\u0003\u0013\tY!\u0001\u0003gS2,'bAA\u0007=\u0006\u0019a.[8\n\t\u0005E\u0011q\u0001\u0002\u0005!\u0006$\b.A\u0006ti\u0006<\u0017N\\4ESJ\u0004\u0013aD:uC\u001e,G-\u0011:uS\u001a\f7\r^:\u0016\u0005\u0005e\u0001CBA\u000e\u0003S\ti#\u0004\u0002\u0002\u001e)!\u0011qDA\u0011\u0003\u001diW\u000f^1cY\u0016TA!a\t\u0002&\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0005\u0005\u001d\u0012!B:dC2\f\u0017\u0002BA\u0016\u0003;\u0011aAQ;gM\u0016\u0014\bcAA\u0018-5\t\u0001A\u0001\bTi\u0006<W\rZ!si&4\u0017m\u0019;\u0014\u0007Y\t)\u0004\u0005\u0003\u00028\u0005eRBAA\u0013\u0013\u0011\tY$!\n\u0003\r\u0005s\u0017PU3g\u0003\u0011q\u0017-\\3\u0016\u0005\u0005\u0005\u0003\u0003BA\"\u0003#rA!!\u0012\u0002NA!\u0011qIA\u0013\u001b\t\tIEC\u0002\u0002La\u000ba\u0001\u0010:p_Rt\u0014\u0002BA(\u0003K\ta\u0001\u0015:fI\u00164\u0017\u0002BA*\u0003+\u0012aa\u0015;sS:<'\u0002BA(\u0003K\tQA\\1nK\u0002\"B!!\f\u0002\\!9\u0011QH\rA\u0002\u0005\u0005\u0013a\u0001=%gAA\u0011qGA1\u0003K\nI'\u0003\u0003\u0002d\u0005\u0015\"A\u0002+va2,'\u0007E\u0002\\\u0003OJ1!a\u0015]!\u0019\t9$a\u001b\u0002f%!\u0011QNA\u0013\u0005\u0019y\u0005\u000f^5p]\u0006\t2-\u00198p]&\u001c\u0017\r\u001c$jY\u0016t\u0015-\\3\u0002%\r\fgn\u001c8jG\u0006dg)\u001b7f\u001d\u0006lW\rI\u0001\tMJ\fw-\\3oiV\u0011\u0011q\u000f\t\u0007\u0003o\tY'!\u0011\u0002\u0013\u0019\u0014\u0018mZ7f]R\u0004\u0013\u0001\u00029bi\"\fQ\u0001]1uQ\u0002\n!b\u001d;bO\u0016$\u0007+\u0019;i\u0003-\u0019H/Y4fIB\u000bG\u000f\u001b\u0011\u0002\u000f\u0019LG.Z(viV\u0011\u0011q\u0011\t\u0005\u0003\u0013\u000bi)\u0004\u0002\u0002\f*\u0011\u0011NX\u0005\u0005\u0003\u001f\u000bYI\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW.\u0001\u0005gS2,w*\u001e;!\u0003-\u0019w.\u001e8uS:<w*\u001e;\u0016\u0005\u0005]\u0005\u0003BAM\u0003Sk!!a'\u000b\u0007%\fiJ\u0003\u0003\u0002 \u0006\u0005\u0016AB2p[6|gN\u0003\u0003\u0002$\u0006\u0015\u0016AB4p_\u001edWM\u0003\u0002\u0002(\u0006\u00191m\\7\n\t\u0005-\u00161\u0014\u0002\u0015\u0007>,h\u000e^5oO>+H\u000f];u'R\u0014X-Y7\u0002\u0019\r|WO\u001c;j]\u001e|U\u000f\u001e\u0011\u0002\u0017\rDWmY6tk6|U\u000f^\u000b\u0003\u0003g\u0003B!!.\u0002@6\u0011\u0011q\u0017\u0006\u0005\u0003s\u000bY,A\u0002{SBT1!!0_\u0003\u0011)H/\u001b7\n\t\u0005\u0005\u0017q\u0017\u0002\u0014\u0007\",7m[3e\u001fV$\b/\u001e;TiJ,\u0017-\\\u0001\rG\",7m[:v[>+H\u000fI\u0001\u0010_Z,'/\u00197m\u0007\",7m[:v[V\u0011\u0011\u0011\u001a\t\u0005\u0003k\u000bY-\u0003\u0003\u0002N\u0006]&!B\"S\u0007N\u0012\u0014\u0001E8wKJ\fG\u000e\\\"iK\u000e\\7/^7!\u0003\u001d\u0011W/\u001b7eKJ,\"!!6\u0011\t\u0005]\u0017\u0011 \b\u0005\u00033\f\u0019P\u0004\u0003\u0002\\\u0006=h\u0002BAo\u0003[tA!a8\u0002l:!\u0011\u0011]Au\u001d\u0011\t\u0019/a:\u000f\t\u0005\u001d\u0013Q]\u0005\u0002/&\u0011QKV\u0005\u0003'RK!a\u0014*\n\u0005=\u0004\u0018bAAy]\u0006!\u0012\t\u001a3BeRLg-Y2ugJ+7\u000f]8og\u0016LA!!>\u0002x\u0006y\u0011I\u001d;jM\u0006\u001cGoU;n[\u0006\u0014\u0018PC\u0002\u0002r:LA!a?\u0002~\n9!)^5mI\u0016\u0014(\u0002BA{\u0003o\f\u0001BY;jY\u0012,'\u000fI\u0001\u0010CJ$\u0018NZ1diN+X.\\1ssV\u0011!Q\u0001\t\u0005\u00033\u00149!\u0003\u0003\u0003\n\u0005](aD!si&4\u0017m\u0019;Tk6l\u0017M]=\u0002'\u0005\u0014H/\u001b4bGR\u001cV/\\7bef|F%Z9\u0015\t\t=!Q\u0003\t\u0005\u0003o\u0011\t\"\u0003\u0003\u0003\u0014\u0005\u0015\"\u0001B+oSRD\u0011Ba\u0006/\u0003\u0003\u0005\rA!\u0002\u0002\u0007a$\u0013'\u0001\tbeRLg-Y2u'VlW.\u0019:zA\u0005a\u0011n]\"sGN+8mY3tgV\u0011!q\u0004\t\u0005\u0003o\u0011\t#\u0003\u0003\u0003$\u0005\u0015\"a\u0002\"p_2,\u0017M\\\u0001\u0011SN\u001c%oY*vG\u000e,7o]0%KF$BAa\u0004\u0003*!I!qC\u0019\u0002\u0002\u0003\u0007!qD\u0001\u000eSN\u001c%oY*vG\u000e,7o\u001d\u0011\u0002\u0013U\u0004H-\u0019;f\u0007J\u001cG\u0003\u0002B\b\u0005cAqAa\r4\u0001\u0004\u0011y\"A\u0005jgN+8mY3tg\u0006aq-\u001a;De\u000e\u001cF/\u0019;vgV\u0011!\u0011\b\t\u0007\u0003o\tYGa\b\u0002\r\u001d,Go\u0011:d+\t\u0011y\u0004\u0005\u0003\u00028\t\u0005\u0013\u0002\u0002B\"\u0003K\u0011A\u0001T8oO\u0006)qO]5uKR!!q\u0002B%\u0011\u001d\u0011YE\u000ea\u0001\u0005\u001b\n\u0011\u0002Z1uC\u000eCWO\\6\u0011\t\t=#\u0011\f\b\u0005\u0005#\u0012)F\u0004\u0003\u0003T\u00055X\"\u00019\n\u0007\t]c.A\nBI\u0012\f%\u000f^5gC\u000e$8OU3rk\u0016\u001cH/\u0003\u0003\u0003\\\tu#!D!si&4\u0017m\u0019;DQVt7NC\u0002\u0003X9\fQa\u00197pg\u0016$\"Aa\u0004\u0002\u000fM,X.\\1ssR\u0011!QA\u0001\u0011gR\fw-\u001a3BeRLg-Y2ug\u0002\nqb\u00195v].,G-\u0011:uS\u001a\f7\r^\u000b\u0003\u0005[\u00022!a\f:\u0005U\u0019F/Y4fI\u000eCWO\\6fI\u0006\u0013H/\u001b4bGR\u001c2!OA\u0017\u0003%qW/\\\"ik:\\7/\u0001\u0006u_R\fGNQ=uKN$\u0002B!\u001c\u0003z\tm$Q\u0010\u0005\b\u0003{i\u0004\u0019AA!\u0011\u001d\u0011\u0019(\u0010a\u0001\u0005\u007fAqA!\u001e>\u0001\u0004\u0011y$A\bsK6\f\u0017N\\5oO\u000eCWO\\6t\u0003M\u0011X-\\1j]&twm\u00115v].\u001cx\fJ3r)\u0011\u0011yA!\"\t\u0013\t]q(!AA\u0002\t}\u0012\u0001\u0005:f[\u0006Lg.\u001b8h\u0007\",hn[:!\u0003M!x\u000e^1m\u0005f$Xm\u001d)s_\u000e,7o]3e\u0003]!x\u000e^1m\u0005f$Xm\u001d)s_\u000e,7o]3e?\u0012*\u0017\u000f\u0006\u0003\u0003\u0010\t=\u0005\"\u0003B\f\u0005\u0006\u0005\t\u0019\u0001B \u0003Q!x\u000e^1m\u0005f$Xm\u001d)s_\u000e,7o]3eA\u0005\u0001\u0012n\u001d$jeN$8I]2Va\u0012\fG/Z\u0001\u0015SN4\u0015N]:u\u0007J\u001cW\u000b\u001d3bi\u0016|F%Z9\u0015\t\t=!\u0011\u0014\u0005\n\u0005/)\u0015\u0011!a\u0001\u0005?\t\u0011#[:GSJ\u001cHo\u0011:d+B$\u0017\r^3!\u0003)I7OR5oSNDW\r\u001a\u000b\u0005\u0005\u001f\u0011\t\u000bC\u0004\u00034!\u0003\rAa\b\u0015\t\t=!Q\u0015\u0005\b\u0005\u0017J\u0005\u0019\u0001B'\u0003M\u0019\u0007.\u001e8lK\u0012\f%\u000f^5gC\u000e$x\fJ3r)\u0011\u0011yAa+\t\u0013\t]\u0011\"!AA\u0002\t5\u0014\u0001E2ik:\\W\rZ!si&4\u0017m\u0019;!\u0003\u0019Aw\u000e\u001c3feV\u0011!1\u0017\t\u0004{\nU\u0016b\u0001B\\\u0019\ni1+Z:tS>t\u0007j\u001c7eKJ\f!\u0002[8mI\u0016\u0014x\fJ3r)\u0011\u0011yA!0\t\u0013\t]A\"!AA\u0002\tM\u0016a\u00025pY\u0012,'\u000fI\u0001\u0007_:tU\r\u001f;\u0015\t\t=!Q\u0019\u0005\u0007\u0005\u000ft\u0001\u0019\u00017\u0002\u0007I,\u0017/A\u0004p]\u0016\u0013(o\u001c:\u0015\t\t=!Q\u001a\u0005\b\u0005\u001f|\u0001\u0019\u0001Bi\u0003%!\bN]8xC\ndW\r\u0005\u0003\u0003T\nug\u0002\u0002Bk\u00053tA!a\u0012\u0003X&\u0011\u0011qE\u0005\u0005\u00057\f)#A\u0004qC\u000e\\\u0017mZ3\n\t\t}'\u0011\u001d\u0002\n)\"\u0014xn^1cY\u0016TAAa7\u0002&\u0005\u0011\u0013\r\u001a3Ti\u0006<W\rZ!si&4\u0017m\u0019;U_\u0006\u0013H/\u001b4bGRl\u0015M\\1hKJ$BAa\u0004\u0003h\"9!\u0011\u001e\tA\u0002\u00055\u0012\u0001C1si&4\u0017m\u0019;\u0002)\u0019dWo\u001d5Ti\u0006<W\rZ!si&4\u0017m\u0019;t)\t\u0011y\u000f\u0005\u0004\u0003T\nE(QA\u0005\u0005\u0005g\u0014\tOA\u0002TKF\fac\u00197fC:,\u0006o\u0015;bO\u0016$\u0017I\u001d;jM\u0006\u001cGo]\u0001\f_:\u001cu.\u001c9mKR,G-A\nxe&$X-\u0011:uS\u001a\f7\r\u001e+p\r&dW\r\u0006\u0003\u0002.\tu\bb\u0002Bu)\u0001\u0007!q \t\u0005\u0005\u001f\u001a\t!\u0003\u0003\u0004\u0004\tu#aE*j]\u001edWm\u00115v].\f%\u000f^5gC\u000e$H\u0003\u0002B7\u0007\u000fAqA!;\u0016\u0001\u0004\u0019I\u0001\u0005\u0003\u0003P\r-\u0011\u0002BB\u0007\u0005;\u0012ACQ3hS:\u001c\u0005.\u001e8lK\u0012\f%\u000f^5gC\u000e$\b")
public class SparkConnectAddArtifactsHandler
implements StreamObserver<AddArtifactsRequest> {
    private final StreamObserver<AddArtifactsResponse> responseObserver;
    private final Path stagingDir;
    private final Buffer<StagedArtifact> stagedArtifacts;
    private StagedChunkedArtifact chunkedArtifact;
    private SessionHolder holder;

    public StreamObserver<AddArtifactsResponse> responseObserver() {
        return this.responseObserver;
    }

    public Path stagingDir() {
        return this.stagingDir;
    }

    public Buffer<StagedArtifact> stagedArtifacts() {
        return this.stagedArtifacts;
    }

    private StagedChunkedArtifact chunkedArtifact() {
        return this.chunkedArtifact;
    }

    private void chunkedArtifact_$eq(StagedChunkedArtifact x$1) {
        this.chunkedArtifact = x$1;
    }

    private SessionHolder holder() {
        return this.holder;
    }

    private void holder_$eq(SessionHolder x$1) {
        this.holder = x$1;
    }

    @Override
    public void onNext(AddArtifactsRequest req) {
        block12: {
            try {
                if (this.holder() == null) {
                    Some some;
                    boolean bl = req.hasClientObservedServerSideSessionId();
                    if (bl) {
                        some = new Some((Object)req.getClientObservedServerSideSessionId());
                    } else if (!bl) {
                        some = None$.MODULE$;
                    } else {
                        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                    }
                    Some previousSessionId = some;
                    this.holder_$eq(SparkConnectService$.MODULE$.getOrCreateIsolatedSession(req.getUserContext().getUserId(), req.getSessionId(), (Option<String>)previousSessionId));
                }
                if (req.hasBeginChunk()) {
                    Predef$.MODULE$.require(this.chunkedArtifact() == null);
                    this.chunkedArtifact_$eq(this.writeArtifactToFile(req.getBeginChunk()));
                    break block12;
                }
                if (req.hasChunk()) {
                    Predef$.MODULE$.require(this.chunkedArtifact() != null && !this.chunkedArtifact().isFinished());
                    this.chunkedArtifact().write(req.getChunk());
                    if (this.chunkedArtifact().isFinished()) {
                        this.chunkedArtifact().close();
                        this.chunkedArtifact_$eq(null);
                    }
                    break block12;
                }
                if (req.hasBatch()) {
                    req.getBatch().getArtifactsList().forEach(artifact -> this.writeArtifactToFile((AddArtifactsRequest.SingleChunkArtifact)artifact).close());
                    break block12;
                }
                throw new UnsupportedOperationException("Unsupported data transfer request: " + req);
            }
            catch (Throwable x$6) {
                PartialFunction<Throwable, BoxedUnit> catchExpr$1 = ErrorUtils$.MODULE$.handleError("addArtifacts.onNext", this.responseObserver(), req.getUserContext().getUserId(), req.getSessionId(), (Option<ExecuteEventsManager>)None$.MODULE$, false, (Option<Function0<BoxedUnit>>)new Some((JFunction0.mcV.sp & Serializable)() -> this.cleanUpStagedArtifacts()));
                if (catchExpr$1.isDefinedAt((Object)x$6)) {
                    catchExpr$1.apply((Object)x$6);
                }
                throw x$6;
            }
        }
    }

    @Override
    public void onError(Throwable throwable) {
        this.cleanUpStagedArtifacts();
        this.responseObserver().onError(throwable);
    }

    public void addStagedArtifactToArtifactManager(StagedArtifact artifact) {
        Predef$.MODULE$.require(this.holder() != null);
        this.holder().addArtifact(artifact.path(), artifact.stagedPath(), artifact.fragment());
    }

    public Seq<AddArtifactsResponse.ArtifactSummary> flushStagedArtifacts() {
        ListBuffer failedArtifactExceptions = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Seq summaries = ((IterableOnceOps)this.stagedArtifacts().map((Function1 & Serializable)artifact -> {
            BoxedUnit boxedUnit;
            try {
                if (artifact.getCrcStatus().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                    if (artifact.path().startsWith(ArtifactManager$.MODULE$.forwardToFSPrefix() + File.separator)) {
                        this.holder().artifactManager().uploadArtifactToFs(artifact.path(), artifact.stagedPath());
                    } else {
                        this.addStagedArtifactToArtifactManager((StagedArtifact)artifact);
                    }
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof SparkRuntimeException) {
                    SparkRuntimeException sparkRuntimeException = (SparkRuntimeException)throwable2;
                    String string = sparkRuntimeException.getCondition();
                    String string2 = "ARTIFACT_ALREADY_EXISTS";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        boxedUnit = failedArtifactExceptions.$plus$eq((Object)sparkRuntimeException);
                    }
                }
                throw throwable;
            }
            return artifact.summary();
        })).toSeq();
        if (failedArtifactExceptions.nonEmpty()) {
            throw ArtifactUtils$.MODULE$.mergeExceptionsWithSuppressed(failedArtifactExceptions.toSeq());
        }
        return summaries;
    }

    public void cleanUpStagedArtifacts() {
        Utils$.MODULE$.deleteRecursively(this.stagingDir().toFile());
    }

    @Override
    public void onCompleted() {
        try {
            Seq<AddArtifactsResponse.ArtifactSummary> artifactSummaries = this.flushStagedArtifacts();
            AddArtifactsResponse.Builder builder = AddArtifactsResponse.newBuilder();
            builder.setSessionId(this.holder().sessionId());
            builder.setServerSideSessionId(this.holder().serverSessionId());
            artifactSummaries.foreach((Function1 & Serializable)summary -> builder.addArtifacts((AddArtifactsResponse.ArtifactSummary)summary));
            this.cleanUpStagedArtifacts();
            this.responseObserver().onNext(builder.build());
            this.responseObserver().onCompleted();
        }
        catch (Throwable x$7) {
            PartialFunction<Throwable, BoxedUnit> catchExpr$2 = ErrorUtils$.MODULE$.handleError("addArtifacts.onComplete", this.responseObserver(), this.holder().userId(), this.holder().sessionId(), (Option<ExecuteEventsManager>)None$.MODULE$, false, (Option<Function0<BoxedUnit>>)new Some((JFunction0.mcV.sp & Serializable)() -> this.cleanUpStagedArtifacts()));
            if (catchExpr$2.isDefinedAt((Object)x$7)) {
                catchExpr$2.apply((Object)x$7);
            }
            throw x$7;
        }
    }

    private StagedArtifact writeArtifactToFile(AddArtifactsRequest.SingleChunkArtifact artifact) {
        StagedArtifact stagedDep = new StagedArtifact(this, artifact.getName());
        this.stagedArtifacts().$plus$eq((Object)stagedDep);
        stagedDep.write(artifact.getData());
        return stagedDep;
    }

    private StagedChunkedArtifact writeArtifactToFile(AddArtifactsRequest.BeginChunkedArtifact artifact) {
        StagedChunkedArtifact stagedChunkedArtifact = new StagedChunkedArtifact(this, artifact.getName(), artifact.getNumChunks(), artifact.getTotalBytes());
        this.stagedArtifacts().$plus$eq((Object)stagedChunkedArtifact);
        stagedChunkedArtifact.write(artifact.getInitialChunk());
        return stagedChunkedArtifact;
    }

    public SparkConnectAddArtifactsHandler(StreamObserver<AddArtifactsResponse> responseObserver) {
        this.responseObserver = responseObserver;
        this.stagingDir = Utils$.MODULE$.createTempDir().toPath();
        this.stagedArtifacts = (Buffer)Buffer$.MODULE$.empty();
    }

    public class StagedArtifact {
        private final String name;
        private final /* synthetic */ Tuple2 x$3;
        private final String canonicalFileName;
        private final Option<String> fragment;
        private final Path path;
        private final Path stagedPath;
        private final OutputStream fileOut;
        private final CountingOutputStream countingOut;
        private final CheckedOutputStream checksumOut;
        private final CRC32 overallChecksum;
        private final AddArtifactsResponse.ArtifactSummary.Builder builder;
        private AddArtifactsResponse.ArtifactSummary artifactSummary;
        private boolean isCrcSuccess;
        public final /* synthetic */ SparkConnectAddArtifactsHandler $outer;

        public String name() {
            return this.name;
        }

        public String canonicalFileName() {
            return this.canonicalFileName;
        }

        public Option<String> fragment() {
            return this.fragment;
        }

        public Path path() {
            return this.path;
        }

        public Path stagedPath() {
            return this.stagedPath;
        }

        private OutputStream fileOut() {
            return this.fileOut;
        }

        private CountingOutputStream countingOut() {
            return this.countingOut;
        }

        private CheckedOutputStream checksumOut() {
            return this.checksumOut;
        }

        private CRC32 overallChecksum() {
            return this.overallChecksum;
        }

        private AddArtifactsResponse.ArtifactSummary.Builder builder() {
            return this.builder;
        }

        private AddArtifactsResponse.ArtifactSummary artifactSummary() {
            return this.artifactSummary;
        }

        private void artifactSummary_$eq(AddArtifactsResponse.ArtifactSummary x$1) {
            this.artifactSummary = x$1;
        }

        public boolean isCrcSuccess() {
            return this.isCrcSuccess;
        }

        public void isCrcSuccess_$eq(boolean x$1) {
            this.isCrcSuccess = x$1;
        }

        public void updateCrc(boolean isSuccess) {
            this.isCrcSuccess_$eq(isSuccess);
        }

        public Option<Object> getCrcStatus() {
            return Option$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.isCrcSuccess()));
        }

        public long getCrc() {
            return this.overallChecksum().getValue();
        }

        public void write(AddArtifactsRequest.ArtifactChunk dataChunk) {
            try {
                dataChunk.getData().writeTo(this.checksumOut());
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable throwable3 = throwable;
                if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                    this.close();
                    throw throwable2;
                }
                throw throwable;
            }
            this.overallChecksum().update(dataChunk.getData().toByteArray());
            this.updateCrc(this.checksumOut().getChecksum().getValue() == dataChunk.getCrc());
            this.checksumOut().getChecksum().reset();
        }

        public void close() {
            if (this.artifactSummary() == null) {
                this.checksumOut().close();
                this.artifactSummary_$eq(this.builder().setName(this.name()).setIsCrcSuccessful(BoxesRunTime.unboxToBoolean((Object)this.getCrcStatus().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false))).build());
                return;
            }
        }

        public AddArtifactsResponse.ArtifactSummary summary() {
            Predef$.MODULE$.require(this.artifactSummary() != null);
            return this.artifactSummary();
        }

        public /* synthetic */ SparkConnectAddArtifactsHandler org$apache$spark$sql$connect$service$SparkConnectAddArtifactsHandler$StagedArtifact$$$outer() {
            return this.$outer;
        }

        private final /* synthetic */ Path liftedTree1$1() {
            Path path;
            try {
                path = ArtifactUtils$.MODULE$.concatenatePaths(this.org$apache$spark$sql$connect$service$SparkConnectAddArtifactsHandler$StagedArtifact$$$outer().stagingDir(), this.path());
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable throwable3 = throwable;
                if (throwable3 instanceof IllegalArgumentException) {
                    throw new IllegalArgumentException("Artifact with name: " + this.name() + " is invalid. The `name` must be a relative path and cannot reference parent/sibling/nephew directories.");
                }
                if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                    throw throwable2;
                }
                throw throwable;
            }
            return path;
        }

        public StagedArtifact(SparkConnectAddArtifactsHandler $outer, String name) {
            String string;
            Option fragment;
            block7: {
                Tuple2 tuple2;
                block6: {
                    this.name = name;
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    if (name.startsWith("archives" + File.separator)) {
                        String[] splits = name.split("#");
                        Predef$.MODULE$.assert(splits.length <= 2, (Function0 & Serializable)() -> "'#' in the path is not supported for adding an archive.");
                        v0 = splits.length == 2 ? new Tuple2((Object)splits[0], (Object)new Some((Object)splits[1])) : new Tuple2((Object)splits[0], (Object)None$.MODULE$);
                    } else {
                        v0 = tuple2 = new Tuple2((Object)name, (Object)None$.MODULE$);
                    }
                    if (tuple2 == null) break block6;
                    String canonicalFileName = (String)tuple2._1();
                    fragment = (Option)tuple2._2();
                    if (canonicalFileName == null) break block6;
                    string = canonicalFileName;
                    if (fragment != null) break block7;
                }
                throw new MatchError((Object)tuple2);
            }
            Option option = fragment;
            this.x$3 = new Tuple2((Object)string, (Object)option);
            this.canonicalFileName = (String)this.x$3._1();
            this.fragment = (Option)this.x$3._2();
            this.path = Paths.get(this.canonicalFileName(), new String[0]);
            this.stagedPath = this.liftedTree1$1();
            Files.createDirectories(this.stagedPath().getParent(), new FileAttribute[0]);
            this.fileOut = Files.newOutputStream(this.stagedPath(), new OpenOption[0]);
            this.countingOut = new CountingOutputStream(this.fileOut());
            this.checksumOut = new CheckedOutputStream(this.countingOut(), new CRC32());
            this.overallChecksum = new CRC32();
            this.builder = AddArtifactsResponse.ArtifactSummary.newBuilder().setName(name);
        }
    }

    public class StagedChunkedArtifact
    extends StagedArtifact {
        private final long numChunks;
        private final long totalBytes;
        private long remainingChunks;
        private long totalBytesProcessed;
        private boolean isFirstCrcUpdate;

        private long remainingChunks() {
            return this.remainingChunks;
        }

        private void remainingChunks_$eq(long x$1) {
            this.remainingChunks = x$1;
        }

        private long totalBytesProcessed() {
            return this.totalBytesProcessed;
        }

        private void totalBytesProcessed_$eq(long x$1) {
            this.totalBytesProcessed = x$1;
        }

        private boolean isFirstCrcUpdate() {
            return this.isFirstCrcUpdate;
        }

        private void isFirstCrcUpdate_$eq(boolean x$1) {
            this.isFirstCrcUpdate = x$1;
        }

        public boolean isFinished() {
            return this.remainingChunks() == 0L;
        }

        @Override
        public void updateCrc(boolean isSuccess) {
            this.isCrcSuccess_$eq(isSuccess && (this.isCrcSuccess() || this.isFirstCrcUpdate()));
            this.isFirstCrcUpdate_$eq(false);
        }

        @Override
        public void write(AddArtifactsRequest.ArtifactChunk dataChunk) {
            if (this.remainingChunks() == 0L) {
                throw new RuntimeException("Excessive data chunks for artifact: " + super.name() + ", expected " + this.numChunks + " chunks in total. Processed " + this.totalBytesProcessed() + " bytes out of " + this.totalBytes + " bytes.");
            }
            super.write(dataChunk);
            this.totalBytesProcessed_$eq(this.totalBytesProcessed() + (long)dataChunk.getData().size());
            this.remainingChunks_$eq(this.remainingChunks() - 1L);
        }

        @Override
        public void close() {
            if (this.remainingChunks() != 0L || this.totalBytesProcessed() != this.totalBytes) {
                throw new RuntimeException("Missing data chunks for artifact: " + super.name() + ". Expected " + this.numChunks + " chunks and received " + (this.numChunks - this.remainingChunks()) + " chunks. Processed " + this.totalBytesProcessed() + " bytes out of " + this.totalBytes + " bytes.");
            }
            super.close();
        }

        public /* synthetic */ SparkConnectAddArtifactsHandler org$apache$spark$sql$connect$service$SparkConnectAddArtifactsHandler$StagedChunkedArtifact$$$outer() {
            return this.$outer;
        }

        public StagedChunkedArtifact(SparkConnectAddArtifactsHandler $outer, String name, long numChunks, long totalBytes) {
            this.numChunks = numChunks;
            this.totalBytes = totalBytes;
            super($outer, name);
            this.remainingChunks = numChunks;
            this.totalBytesProcessed = 0L;
            this.isFirstCrcUpdate = true;
        }
    }
}

