/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.IntervalMathUtils$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.catalyst.util.MathUtils$;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the negated value of `expr`.", examples="\n    Examples:\n      > SELECT _FUNC_(1);\n       -1\n  ", since="1.0.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\t%a\u0001B\u0012%\u0001FB\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t!\u0002\u0011\t\u0012)A\u0005\u001b\"A\u0011\u000b\u0001BK\u0002\u0013\u0005!\u000b\u0003\u0005W\u0001\tE\t\u0015!\u0003T\u0011\u00159\u0006\u0001\"\u0001Y\u0011\u0015a\u0006\u0001\"\u0011S\u0011\u00159\u0006\u0001\"\u0001^\u0011\u0015y\u0006\u0001\"\u0011a\u0011\u0015Q\u0007\u0001\"\u0011l\u0011\u0015y\u0007\u0001\"\u0011q\u0011!I\b\u0001#b\u0001\n\u0013Q\bbBA\u0002\u0001\u0011\u0005\u0013Q\u0001\u0005\b\u0003C\u0001A\u0011KA\u0012\u0011\u0019I\u0003\u0001\"\u0011\u0002*!9\u00111\u0006\u0001\u0005R\u00055\u0002\"CA\u001a\u0001\u0005\u0005I\u0011AA\u001b\u0011%\tY\u0004AI\u0001\n\u0003\ti\u0004C\u0005\u0002T\u0001\t\n\u0011\"\u0001\u0002V!I\u0011\u0011\f\u0001\u0002\u0002\u0013\u0005\u00131\f\u0005\n\u0003W\u0002\u0011\u0011!C\u0001\u0003[B\u0011\"!\u001e\u0001\u0003\u0003%\t!a\u001e\t\u0013\u0005u\u0004!!A\u0005B\u0005}\u0004\"CAG\u0001\u0005\u0005I\u0011AAH\u0011%\t\u0019\nAA\u0001\n\u0003\n)\nC\u0005\u0002\u001a\u0002\t\t\u0011\"\u0011\u0002\u001c\u001eI\u0011q\u0018\u0013\u0002\u0002#\u0005\u0011\u0011\u0019\u0004\tG\u0011\n\t\u0011#\u0001\u0002D\"1qk\u0007C\u0001\u00037D\u0001b\\\u000e\u0002\u0002\u0013\u0015\u0013Q\u001c\u0005\n\u0003?\\\u0012\u0011!CA\u0003CD\u0011\"a:\u001c#\u0003%\t!!\u0016\t\u0013\u0005%8$!A\u0005\u0002\u0006-\b\"CA\u007f7E\u0005I\u0011AA+\u0011%\typGA\u0001\n\u0013\u0011\tA\u0001\u0006V]\u0006\u0014\u00180T5okNT!!\n\u0014\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003O!\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003S)\n1a]9m\u0015\tYC&A\u0003ta\u0006\u00148N\u0003\u0002.]\u00051\u0011\r]1dQ\u0016T\u0011aL\u0001\u0004_J<7\u0001A\n\u0006\u0001I2\u0014h\u0010\t\u0003gQj\u0011\u0001J\u0005\u0003k\u0011\u0012q\"\u00168bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003g]J!\u0001\u000f\u0013\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"AO\u001f\u000e\u0003mR\u0011\u0001P\u0001\u0006g\u000e\fG.Y\u0005\u0003}m\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002A\u0011:\u0011\u0011I\u0012\b\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\tB\na\u0001\u0010:p_Rt\u0014\"\u0001\u001f\n\u0005\u001d[\u0014a\u00029bG.\fw-Z\u0005\u0003\u0013*\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!aR\u001e\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u00035\u0003\"a\r(\n\u0005=##AC#yaJ,7o]5p]\u000611\r[5mI\u0002\n1BZ1jY>sWI\u001d:peV\t1\u000b\u0005\u0002;)&\u0011Qk\u000f\u0002\b\u0005>|G.Z1o\u000311\u0017-\u001b7P]\u0016\u0013(o\u001c:!\u0003\u0019a\u0014N\\5u}Q\u0019\u0011LW.\u0011\u0005M\u0002\u0001\"B&\u0006\u0001\u0004i\u0005bB)\u0006!\u0003\u0005\raU\u0001\u000f]VdG.\u00138u_2,'/\u00198u)\tIf\fC\u0003L\u000f\u0001\u0007Q*\u0001\u0006j]B,H\u000fV=qKN,\u0012!\u0019\t\u0004\u0001\n$\u0017BA2K\u0005\r\u0019V-\u001d\t\u0003K\"l\u0011A\u001a\u0006\u0003O\"\nQ\u0001^=qKNL!!\u001b4\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u00031\u0004\"!Z7\n\u000594'\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!\u001d\t\u0003eZt!a\u001d;\u0011\u0005\t[\u0014BA;<\u0003\u0019\u0001&/\u001a3fM&\u0011q\u000f\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005U\\\u0014a\u00028v[\u0016\u0014\u0018nY\u000b\u0002wB\u0019\u0001\t @\n\u0005uT%a\u0002(v[\u0016\u0014\u0018n\u0019\t\u0003u}L1!!\u0001<\u0005\r\te._\u0001\nI><UM\\\"pI\u0016$b!a\u0002\u0002\u0014\u0005u\u0001\u0003BA\u0005\u0003\u001fi!!a\u0003\u000b\u0007\u00055A%A\u0004d_\u0012,w-\u001a8\n\t\u0005E\u00111\u0002\u0002\t\u000bb\u0004(oQ8eK\"9\u0011Q\u0003\u0007A\u0002\u0005]\u0011aA2uqB!\u0011\u0011BA\r\u0013\u0011\tY\"a\u0003\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u0011q\u0004\u0007A\u0002\u0005\u001d\u0011AA3w\u00031qW\u000f\u001c7TC\u001a,WI^1m)\rq\u0018Q\u0005\u0005\u0007\u0003Oi\u0001\u0019\u0001@\u0002\u000b%t\u0007/\u001e;\u0016\u0003E\fAc^5uQ:+wo\u00115jY\u0012Le\u000e^3s]\u0006dGcA-\u00020!1\u0011\u0011G\bA\u00025\u000b\u0001B\\3x\u0007\"LG\u000eZ\u0001\u0005G>\u0004\u0018\u0010F\u0003Z\u0003o\tI\u0004C\u0004L!A\u0005\t\u0019A'\t\u000fE\u0003\u0002\u0013!a\u0001'\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA U\ri\u0015\u0011I\u0016\u0003\u0003\u0007\u0002B!!\u0012\u0002P5\u0011\u0011q\t\u0006\u0005\u0003\u0013\nY%A\u0005v]\u000eDWmY6fI*\u0019\u0011QJ\u001e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002R\u0005\u001d#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA,U\r\u0019\u0016\u0011I\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005u\u0003\u0003BA0\u0003Sj!!!\u0019\u000b\t\u0005\r\u0014QM\u0001\u0005Y\u0006twM\u0003\u0002\u0002h\u0005!!.\u0019<b\u0013\r9\u0018\u0011M\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003_\u00022AOA9\u0013\r\t\u0019h\u000f\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004}\u0006e\u0004\"CA>+\u0005\u0005\t\u0019AA8\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\u0011\t\u0006\u0003\u0007\u000bII`\u0007\u0003\u0003\u000bS1!a\"<\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0017\u000b)I\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA*\u0002\u0012\"A\u00111P\f\u0002\u0002\u0003\u0007a0\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA/\u0003/C\u0011\"a\u001f\u0019\u0003\u0003\u0005\r!a\u001c\u0002\r\u0015\fX/\u00197t)\r\u0019\u0016Q\u0014\u0005\t\u0003wJ\u0012\u0011!a\u0001}\"\u001a\u0002!!)\u0002(\u0006%\u0016QVAX\u0003g\u000b),!/\u0002<B\u00191'a)\n\u0007\u0005\u0015FEA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005-\u0016aM0G+:\u001bu\fK3yaJL\u0003%\f\u0011SKR,(O\\:!i\",\u0007E\\3hCR,G\r\t<bYV,\u0007e\u001c4!A\u0016D\bO\u001d1/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAY\u0003UR\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&M\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A5\n$\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005]\u0016!B\u0019/a9\u0002\u0014!B4s_V\u0004\u0018EAA_\u0003)i\u0017\r\u001e5`MVt7m]\u0001\u000b+:\f'/_'j]V\u001c\bCA\u001a\u001c'\u0015Y\u0012QYAi!\u001d\t9-!4N'fk!!!3\u000b\u0007\u0005-7(A\u0004sk:$\u0018.\\3\n\t\u0005=\u0017\u0011\u001a\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004\u0003BAj\u00033l!!!6\u000b\t\u0005]\u0017QM\u0001\u0003S>L1!SAk)\t\t\t\r\u0006\u0002\u0002^\u0005)\u0011\r\u001d9msR)\u0011,a9\u0002f\")1J\ba\u0001\u001b\"9\u0011K\bI\u0001\u0002\u0004\u0019\u0016aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\u0002\u000fUt\u0017\r\u001d9msR!\u0011Q^A}!\u0015Q\u0014q^Az\u0013\r\t\tp\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000bi\n)0T*\n\u0007\u0005]8H\u0001\u0004UkBdWM\r\u0005\t\u0003w\u0004\u0013\u0011!a\u00013\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011\u0019\u0001\u0005\u0003\u0002`\t\u0015\u0011\u0002\u0002B\u0004\u0003C\u0012aa\u00142kK\u000e$\b")
public class UnaryMinus
extends UnaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private Numeric<Object> numeric;
    private final Expression child;
    private final boolean failOnError;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$2() {
        return UnaryMinus$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Object>> unapply(UnaryMinus x$0) {
        return UnaryMinus$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$2() {
        return UnaryMinus$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Expression, Object>, UnaryMinus> tupled() {
        return UnaryMinus$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, UnaryMinus>> curried() {
        return UnaryMinus$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TypeCollection$.MODULE$.NumericAndInterval(), (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return this.child().dataType();
    }

    @Override
    public String toString() {
        return "-" + this.child();
    }

    private Numeric<Object> numeric$lzycompute() {
        UnaryMinus unaryMinus = this;
        synchronized (unaryMinus) {
            if (!this.bitmap$0) {
                this.numeric = TypeUtils$.MODULE$.getNumeric(this.dataType(), this.failOnError());
                this.bitmap$0 = true;
            }
        }
        return this.numeric;
    }

    private Numeric<Object> numeric() {
        if (!this.bitmap$0) {
            return this.numeric$lzycompute();
        }
        return this.numeric;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        DataType dataType = this.dataType();
        if (dataType instanceof DecimalType) {
            return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> c + ".unary_$minus()");
        }
        if ((ByteType$.MODULE$.equals(dataType) ? true : (ShortType$.MODULE$.equals(dataType) ? true : (IntegerType$.MODULE$.equals(dataType) ? true : LongType$.MODULE$.equals(dataType)))) && this.failOnError()) {
            String mathUtils = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(MathUtils$.MODULE$.getClass().getCanonicalName()), "$");
            return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)eval -> ev.value() + " = " + mathUtils + ".negateExact(" + eval + ");");
        }
        if (dataType instanceof NumericType) {
            NumericType numericType = (NumericType)dataType;
            return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)eval -> {
                String originValue = ctx.freshName("origin");
                return "\n        " + CodeGenerator$.MODULE$.javaType((DataType)numericType) + " " + originValue + " = (" + CodeGenerator$.MODULE$.javaType((DataType)numericType) + ")(" + eval + ");\n        " + ev.value() + " = (" + CodeGenerator$.MODULE$.javaType((DataType)numericType) + ")(-(" + originValue + "));\n      ";
            });
        }
        if (dataType instanceof CalendarIntervalType) {
            String iu = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(IntervalUtils$.MODULE$.getClass().getCanonicalName()), "$");
            String method = this.failOnError() ? "negateExact" : "negate";
            return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> iu + "." + method + "(" + c + ")");
        }
        if (dataType instanceof AnsiIntervalType) {
            return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)eval -> {
                String mathUtils = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(IntervalMathUtils$.MODULE$.getClass().getCanonicalName()), "$");
                return ev.value() + " = " + mathUtils + ".negateExact(" + eval + ");";
            });
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public Object nullSafeEval(Object input) {
        boolean bl = false;
        DataType dataType = null;
        DataType dataType2 = this.dataType();
        if (CalendarIntervalType$.MODULE$.equals(dataType2)) {
            bl = true;
            dataType = dataType2;
            if (this.failOnError()) {
                return IntervalUtils$.MODULE$.negateExact((CalendarInterval)input);
            }
        }
        if (bl) {
            return IntervalUtils$.MODULE$.negate((CalendarInterval)input);
        }
        if (dataType2 instanceof DayTimeIntervalType) {
            return BoxesRunTime.boxToLong((long)IntervalMathUtils$.MODULE$.negateExact(BoxesRunTime.unboxToLong((Object)input)));
        }
        if (dataType2 instanceof YearMonthIntervalType) {
            return BoxesRunTime.boxToInteger((int)IntervalMathUtils$.MODULE$.negateExact(BoxesRunTime.unboxToInt((Object)input)));
        }
        return this.numeric().negate(input);
    }

    @Override
    public String sql() {
        String string = (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable)() -> "-");
        switch (string == null ? 0 : string.hashCode()) {
            case 45: {
                if (!"-".equals(string)) break;
                return "(- " + this.child().sql() + ")";
            }
        }
        return string + "(" + this.child().sql() + ")";
    }

    @Override
    public UnaryMinus withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public UnaryMinus copy(Expression child, boolean failOnError) {
        return new UnaryMinus(child, failOnError);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "UnaryMinus";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean((boolean)this.failOnError());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof UnaryMinus;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "failOnError";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof UnaryMinus)) return false;
        boolean bl = true;
        if (!bl) return false;
        UnaryMinus unaryMinus = (UnaryMinus)x$1;
        if (this.failOnError() != unaryMinus.failOnError()) return false;
        Expression expression = this.child();
        Expression expression2 = unaryMinus.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!unaryMinus.canEqual(this)) return false;
        return true;
    }

    public UnaryMinus(Expression child, boolean failOnError) {
        this.child = child;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
    }

    public UnaryMinus(Expression child) {
        this(child, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

