/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.HTTPRouteRetry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class HTTPRouteRetryFluent<A extends HTTPRouteRetryFluent<A>>
extends BaseFluent<A> {
    private Integer attempts;
    private String backoff;
    private List<Integer> codes = new ArrayList<Integer>();
    private Map<String, Object> additionalProperties;

    public HTTPRouteRetryFluent() {
    }

    public HTTPRouteRetryFluent(HTTPRouteRetry instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(HTTPRouteRetry instance) {
        HTTPRouteRetry hTTPRouteRetry = instance = instance != null ? instance : new HTTPRouteRetry();
        if (instance != null) {
            this.withAttempts(instance.getAttempts());
            this.withBackoff(instance.getBackoff());
            this.withCodes(instance.getCodes());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Integer getAttempts() {
        return this.attempts;
    }

    public A withAttempts(Integer attempts) {
        this.attempts = attempts;
        return (A)((Object)this);
    }

    public boolean hasAttempts() {
        return this.attempts != null;
    }

    public String getBackoff() {
        return this.backoff;
    }

    public A withBackoff(String backoff) {
        this.backoff = backoff;
        return (A)((Object)this);
    }

    public boolean hasBackoff() {
        return this.backoff != null;
    }

    public A addToCodes(int index, Integer item) {
        if (this.codes == null) {
            this.codes = new ArrayList<Integer>();
        }
        this.codes.add(index, item);
        return (A)((Object)this);
    }

    public A setToCodes(int index, Integer item) {
        if (this.codes == null) {
            this.codes = new ArrayList<Integer>();
        }
        this.codes.set(index, item);
        return (A)((Object)this);
    }

    public A addToCodes(Integer ... items) {
        if (this.codes == null) {
            this.codes = new ArrayList<Integer>();
        }
        for (Integer item : items) {
            this.codes.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToCodes(Collection<Integer> items) {
        if (this.codes == null) {
            this.codes = new ArrayList<Integer>();
        }
        for (Integer item : items) {
            this.codes.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromCodes(Integer ... items) {
        if (this.codes == null) {
            return (A)((Object)this);
        }
        for (Integer item : items) {
            this.codes.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCodes(Collection<Integer> items) {
        if (this.codes == null) {
            return (A)((Object)this);
        }
        for (Integer item : items) {
            this.codes.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Integer> getCodes() {
        return this.codes;
    }

    public Integer getCode(int index) {
        return this.codes.get(index);
    }

    public Integer getFirstCode() {
        return this.codes.get(0);
    }

    public Integer getLastCode() {
        return this.codes.get(this.codes.size() - 1);
    }

    public Integer getMatchingCode(Predicate<Integer> predicate) {
        for (Integer item : this.codes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCode(Predicate<Integer> predicate) {
        for (Integer item : this.codes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCodes(List<Integer> codes) {
        if (codes != null) {
            this.codes = new ArrayList<Integer>();
            for (Integer item : codes) {
                this.addToCodes(item);
            }
        } else {
            this.codes = null;
        }
        return (A)((Object)this);
    }

    public A withCodes(Integer ... codes) {
        if (this.codes != null) {
            this.codes.clear();
            this._visitables.remove((Object)"codes");
        }
        if (codes != null) {
            for (Integer item : codes) {
                this.addToCodes(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasCodes() {
        return this.codes != null && !this.codes.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPRouteRetryFluent that = (HTTPRouteRetryFluent)((Object)o);
        if (!Objects.equals(this.attempts, that.attempts)) {
            return false;
        }
        if (!Objects.equals(this.backoff, that.backoff)) {
            return false;
        }
        if (!Objects.equals(this.codes, that.codes)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.attempts, this.backoff, this.codes, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attempts != null) {
            sb.append("attempts:");
            sb.append(this.attempts + ",");
        }
        if (this.backoff != null) {
            sb.append("backoff:");
            sb.append(this.backoff + ",");
        }
        if (this.codes != null && !this.codes.isEmpty()) {
            sb.append("codes:");
            sb.append(this.codes + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

