/*
 * Decompiled with CFR 0.152.
 */
package spire.math.interval;

import cats.kernel.Eq;
import cats.kernel.Order;
import scala.Serializable;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import spire.algebra.package$;
import spire.math.Bounded;
import spire.math.Empty;
import spire.math.Interval;
import spire.math.Interval$;
import spire.math.Point;
import spire.math.interval.Bound;
import spire.math.interval.Bound$;
import spire.math.interval.Overlap;
import spire.math.interval.Overlap$Disjoint$;
import spire.math.interval.Overlap$Equal$;
import spire.math.interval.Overlap$PartialOverlap$;
import spire.math.interval.Overlap$Subset$;

public final class Overlap$
implements Serializable {
    public static Overlap$ MODULE$;

    static {
        new Overlap$();
    }

    public <A> Overlap<A> apply(Interval<A> lhs, Interval<A> rhs, Order<A> evidence$1) {
        Overlap overlap;
        if (Interval$.MODULE$.eq(evidence$1).eqv(lhs, rhs)) {
            overlap = Overlap$Equal$.MODULE$.apply();
        } else if (rhs.isSupersetOf(lhs, evidence$1)) {
            overlap = Overlap$Subset$.MODULE$.apply(lhs, rhs);
        } else if (lhs.isSupersetOf(rhs, evidence$1)) {
            overlap = Overlap$Subset$.MODULE$.apply(rhs, lhs);
        } else {
            Overlap.Disjoint<A> disjoint;
            Interval<A> interval = lhs.intersect(rhs, evidence$1);
            if (interval instanceof Bounded) {
                Bounded bounded = (Bounded)interval;
                disjoint = Overlap$.lessAndOverlaps$1(bounded.lowerBound(), evidence$1, lhs, rhs);
            } else if (interval instanceof Point) {
                Point point = (Point)interval;
                disjoint = Overlap$.lessAndOverlaps$1(point.lowerBound(), evidence$1, lhs, rhs);
            } else if (interval instanceof Empty) {
                disjoint = Interval$.MODULE$.fromBounds(lhs.lowerBound(), rhs.upperBound(), evidence$1).isEmpty() ? Overlap$Disjoint$.MODULE$.apply(rhs, lhs) : Overlap$Disjoint$.MODULE$.apply(lhs, rhs);
            } else {
                throw new Exception("impossible");
            }
            overlap = disjoint;
        }
        return overlap;
    }

    public <A> Eq<Overlap<A>> eqOverlap(Eq<A> evidence$2) {
        return new Eq<Overlap<A>>(evidence$2){
            private final Eq<Interval<A>> eq;

            public boolean eqv$mcZ$sp(boolean x, boolean y) {
                return Eq.eqv$mcZ$sp$((Eq)this, (boolean)x, (boolean)y);
            }

            public boolean eqv$mcB$sp(byte x, byte y) {
                return Eq.eqv$mcB$sp$((Eq)this, (byte)x, (byte)y);
            }

            public boolean eqv$mcC$sp(char x, char y) {
                return Eq.eqv$mcC$sp$((Eq)this, (char)x, (char)y);
            }

            public boolean eqv$mcD$sp(double x, double y) {
                return Eq.eqv$mcD$sp$((Eq)this, (double)x, (double)y);
            }

            public boolean eqv$mcF$sp(float x, float y) {
                return Eq.eqv$mcF$sp$((Eq)this, (float)x, (float)y);
            }

            public boolean eqv$mcI$sp(int x, int y) {
                return Eq.eqv$mcI$sp$((Eq)this, (int)x, (int)y);
            }

            public boolean eqv$mcJ$sp(long x, long y) {
                return Eq.eqv$mcJ$sp$((Eq)this, (long)x, (long)y);
            }

            public boolean eqv$mcS$sp(short x, short y) {
                return Eq.eqv$mcS$sp$((Eq)this, (short)x, (short)y);
            }

            public boolean eqv$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Eq.eqv$mcV$sp$((Eq)this, (BoxedUnit)x, (BoxedUnit)y);
            }

            public boolean neqv(Object x, Object y) {
                return Eq.neqv$((Eq)this, (Object)x, (Object)y);
            }

            public boolean neqv$mcZ$sp(boolean x, boolean y) {
                return Eq.neqv$mcZ$sp$((Eq)this, (boolean)x, (boolean)y);
            }

            public boolean neqv$mcB$sp(byte x, byte y) {
                return Eq.neqv$mcB$sp$((Eq)this, (byte)x, (byte)y);
            }

            public boolean neqv$mcC$sp(char x, char y) {
                return Eq.neqv$mcC$sp$((Eq)this, (char)x, (char)y);
            }

            public boolean neqv$mcD$sp(double x, double y) {
                return Eq.neqv$mcD$sp$((Eq)this, (double)x, (double)y);
            }

            public boolean neqv$mcF$sp(float x, float y) {
                return Eq.neqv$mcF$sp$((Eq)this, (float)x, (float)y);
            }

            public boolean neqv$mcI$sp(int x, int y) {
                return Eq.neqv$mcI$sp$((Eq)this, (int)x, (int)y);
            }

            public boolean neqv$mcJ$sp(long x, long y) {
                return Eq.neqv$mcJ$sp$((Eq)this, (long)x, (long)y);
            }

            public boolean neqv$mcS$sp(short x, short y) {
                return Eq.neqv$mcS$sp$((Eq)this, (short)x, (short)y);
            }

            public boolean neqv$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Eq.neqv$mcV$sp$((Eq)this, (BoxedUnit)x, (BoxedUnit)y);
            }

            private Eq<Interval<A>> eq() {
                return this.eq;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean eqv(Overlap<A> x, Overlap<A> y) {
                Tuple2 tuple2 = new Tuple2(x, y);
                if (tuple2 != null) {
                    Overlap overlap = (Overlap)tuple2._1();
                    Overlap overlap2 = (Overlap)tuple2._2();
                    if (overlap instanceof Overlap.Equal && overlap2 instanceof Overlap.Equal) {
                        return true;
                    }
                }
                if (tuple2 != null) {
                    Overlap overlap = (Overlap)tuple2._1();
                    Overlap overlap3 = (Overlap)tuple2._2();
                    if (overlap instanceof Overlap.Disjoint) {
                        Overlap.Disjoint disjoint = (Overlap.Disjoint)overlap;
                        Interval<A> x1 = disjoint.lower();
                        Interval<A> y1 = disjoint.upper();
                        if (overlap3 instanceof Overlap.Disjoint) {
                            Overlap.Disjoint disjoint2 = (Overlap.Disjoint)overlap3;
                            Interval<A> x2 = disjoint2.lower();
                            Interval<A> y2 = disjoint2.upper();
                            if (!this.eq().eqv(x1, x2)) return false;
                            if (!this.eq().eqv(y1, y2)) return false;
                            return true;
                        }
                    }
                }
                if (tuple2 != null) {
                    Overlap overlap = (Overlap)tuple2._1();
                    Overlap overlap4 = (Overlap)tuple2._2();
                    if (overlap instanceof Overlap.PartialOverlap) {
                        Overlap.PartialOverlap partialOverlap = (Overlap.PartialOverlap)overlap;
                        Interval<A> x1 = partialOverlap.lower();
                        Interval<A> y1 = partialOverlap.upper();
                        if (overlap4 instanceof Overlap.PartialOverlap) {
                            Overlap.PartialOverlap partialOverlap2 = (Overlap.PartialOverlap)overlap4;
                            Interval<A> x2 = partialOverlap2.lower();
                            Interval<A> y2 = partialOverlap2.upper();
                            if (!this.eq().eqv(x1, x2)) return false;
                            if (!this.eq().eqv(y1, y2)) return false;
                            return true;
                        }
                    }
                }
                if (tuple2 == null) return false;
                Overlap overlap = (Overlap)tuple2._1();
                Overlap overlap5 = (Overlap)tuple2._2();
                if (!(overlap instanceof Overlap.Subset)) return false;
                Overlap.Subset subset = (Overlap.Subset)overlap;
                Interval<A> x1 = subset.inner();
                Interval<A> y1 = subset.outer();
                if (!(overlap5 instanceof Overlap.Subset)) return false;
                Overlap.Subset subset2 = (Overlap.Subset)overlap5;
                Interval<A> x2 = subset2.inner();
                Interval<A> y2 = subset2.outer();
                if (!this.eq().eqv(x1, x2)) return false;
                if (!this.eq().eqv(y1, y2)) return false;
                return true;
            }
            {
                Eq.$init$((Eq)this);
                this.eq = package$.MODULE$.Eq().apply(Interval$.MODULE$.eq(evidence$2$1));
            }
        };
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final Overlap lessAndOverlaps$1(Bound intersectionLowerBound, Order evidence$1$1, Interval lhs$1, Interval rhs$1) {
        return Bound$.MODULE$.eq(evidence$1$1).eqv(lhs$1.lowerBound(), (Object)intersectionLowerBound) ? Overlap$PartialOverlap$.MODULE$.apply(lhs$1, rhs$1) : Overlap$PartialOverlap$.MODULE$.apply(rhs$1, lhs$1);
    }

    private Overlap$() {
        MODULE$ = this;
    }
}

