/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.services;

import java.net.URL;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import org.apache.sling.settings.SlingSettingsService;
import org.jetbrains.annotations.NotNull;

public final class MockSlingSettingService
implements SlingSettingsService {
    private Set<String> runModes;
    private String slingId;

    public MockSlingSettingService() {
        this(Collections.emptySet());
    }

    public MockSlingSettingService(@NotNull Set<String> defaultRunModes) {
        this.runModes = defaultRunModes;
        this.slingId = UUID.randomUUID().toString();
    }

    public Set<String> getRunModes() {
        return Collections.unmodifiableSet(this.runModes);
    }

    public void setRunModes(@NotNull Set<String> runModes) {
        this.runModes = runModes;
    }

    public String getSlingId() {
        return this.slingId;
    }

    public String getAbsolutePathWithinSlingHome(String relativePath) {
        throw new UnsupportedOperationException();
    }

    public String getSlingHomePath() {
        throw new UnsupportedOperationException();
    }

    public URL getSlingHome() {
        throw new UnsupportedOperationException();
    }

    public String getSlingName() {
        throw new UnsupportedOperationException();
    }

    public String getSlingDescription() {
        throw new UnsupportedOperationException();
    }

    public int getBestRunModeMatchCountFromSpec(String spec) {
        throw new UnsupportedOperationException();
    }
}

