/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.util.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.jackrabbit.core.util.db.ConnectionHelper;
import org.apache.jackrabbit.core.util.db.DbUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DerbyConnectionHelper
extends ConnectionHelper {
    public static final String DERBY_EMBEDDED_DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    private static Logger log = LoggerFactory.getLogger(DerbyConnectionHelper.class);

    public DerbyConnectionHelper(DataSource dataSrc, boolean block) {
        super(dataSrc, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown(String driver) throws SQLException {
        if (!DERBY_EMBEDDED_DRIVER.equals(driver)) {
            return;
        }
        Object url = null;
        Connection con = null;
        try {
            con = this.dataSource.getConnection();
            try {
                url = con.getMetaData().getURL();
            }
            catch (SQLException e) {
                log.debug("failed to retrieve connection url: embedded db probably already shut down", (Throwable)e);
                DbUtility.close(con, null, null);
                return;
            }
            con.setAutoCommit(true);
        }
        finally {
            DbUtility.close(con, null, null);
        }
        int pos = ((String)url).lastIndexOf(59);
        if (pos != -1) {
            url = ((String)url).substring(0, pos);
        }
        url = (String)url + ";shutdown=true";
        try {
            DriverManager.getConnection((String)url);
        }
        catch (SQLException e) {
            log.info(e.getMessage());
        }
    }
}

