/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.stream;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.skywalking.banyandb.v1.client.AbstractQuery;
import org.apache.skywalking.banyandb.v1.client.RowEntity;
import org.apache.skywalking.banyandb.v1.client.StreamQuery;
import org.apache.skywalking.banyandb.v1.client.StreamQueryResponse;
import org.apache.skywalking.banyandb.v1.client.TimestampRange;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.query.type.PprofEventType;
import org.apache.skywalking.oap.server.core.query.type.PprofTask;
import org.apache.skywalking.oap.server.core.storage.profiling.pprof.IPprofTaskQueryDAO;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BanyanDBPprofTaskQueryDAO
extends AbstractBanyanDBDAO
implements IPprofTaskQueryDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BanyanDBPprofTaskQueryDAO.class);
    private static final Gson GSON = new Gson();
    private static final Set<String> TAGS = ImmutableSet.of((Object)"service_id", (Object)"service_instance_ids", (Object)"task_id", (Object)"create_time", (Object)"events", (Object)"duration", (Object[])new String[]{"dump_period"});
    private final int queryMaxSize;

    public BanyanDBPprofTaskQueryDAO(BanyanDBStorageClient client, int queryMaxSize) {
        super(client);
        this.queryMaxSize = queryMaxSize;
    }

    public List<PprofTask> getTaskList(final String serviceId, Long startTimeBucket, Long endTimeBucket, final Integer limit) throws IOException {
        long startTS = 0L;
        long endTS = UPPER_BOUND_TIME;
        if (startTimeBucket != null) {
            startTS = TimeBucket.getTimestamp((long)startTimeBucket);
        }
        if (endTimeBucket != null) {
            endTS = TimeBucket.getTimestamp((long)endTimeBucket);
        }
        StreamQueryResponse resp = this.query(false, "pprof_task", TAGS, new TimestampRange(startTS, endTS), new AbstractBanyanDBDAO.QueryBuilder<StreamQuery>(){

            @Override
            protected void apply(StreamQuery query) {
                if (StringUtil.isNotEmpty((String)serviceId)) {
                    query.and(this.eq("service_id", serviceId));
                }
                if (limit != null) {
                    query.setLimit(limit.intValue());
                } else {
                    query.setLimit(BanyanDBPprofTaskQueryDAO.this.queryMaxSize);
                }
                query.setOrderBy(new AbstractQuery.OrderBy(AbstractQuery.Sort.DESC));
            }
        });
        ArrayList<PprofTask> tasks = new ArrayList<PprofTask>(resp.size());
        for (RowEntity entity : resp.getElements()) {
            tasks.add(this.buildPprofTask(entity));
        }
        return tasks;
    }

    public PprofTask getById(final String id) throws IOException {
        StreamQueryResponse resp = this.query(false, "pprof_task", TAGS, new AbstractBanyanDBDAO.QueryBuilder<StreamQuery>(){

            @Override
            protected void apply(StreamQuery query) {
                if (StringUtil.isNotEmpty((String)id)) {
                    query.and(this.eq("task_id", id));
                }
                query.setLimit(1);
            }
        });
        if (resp.size() == 0) {
            return null;
        }
        return this.buildPprofTask((RowEntity)resp.getElements().get(0));
    }

    private PprofTask buildPprofTask(RowEntity data) {
        Type listType = new TypeToken<List<String>>(){}.getType();
        String serviceInstanceIds = (String)data.getTagValue("service_instance_ids");
        List serviceInstanceIdList = (List)GSON.fromJson(serviceInstanceIds, listType);
        String eventsStr = (String)data.getTagValue("events");
        PprofEventType eventType = null;
        if (StringUtil.isNotEmpty((String)eventsStr)) {
            try {
                eventType = PprofEventType.valueOfString((String)eventsStr);
            }
            catch (Exception e) {
                eventType = PprofEventType.CPU;
                log.warn("Failed to parse pprof event type: {}, using CPU as default", (Object)eventsStr, (Object)e);
            }
        }
        return PprofTask.builder().id((String)data.getTagValue("task_id")).serviceId((String)data.getTagValue("service_id")).serviceInstanceIds(serviceInstanceIdList).createTime(((Number)data.getTagValue("create_time")).longValue()).events(eventType).duration(((Number)data.getTagValue("duration")).intValue()).dumpPeriod(((Number)data.getTagValue("dump_period")).intValue()).build();
    }
}

