/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRenderedImage;
import java.util.Arrays;
import java.util.Objects;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.image.DataType;
import org.apache.sis.image.internal.shared.RasterFactory;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.resources.Errors;

public class ImageLayout {
    private static final int MIN_TILE_SIZE = 180;
    public static final int DEFAULT_TILE_SIZE = 256;
    public static final ImageLayout DEFAULT = new ImageLayout(null, null, true, false, true, null);
    protected final SampleModel sampleModel;
    protected final int preferredTileWidth;
    protected final int preferredTileHeight;
    public final boolean isTileSizeAdjustmentAllowed;
    public final boolean isImageBoundsAdjustmentAllowed;
    public final boolean isPartialTilesAllowed;
    protected final int preferredMinTileX;
    protected final int preferredMinTileY;

    protected ImageLayout(SampleModel sampleModel, Dimension preferredTileSize, boolean isTileSizeAdjustmentAllowed, boolean isImageBoundsAdjustmentAllowed, boolean isPartialTilesAllowed, Point preferredMinTile) {
        this.sampleModel = sampleModel;
        if (preferredTileSize != null) {
            this.preferredTileWidth = Math.max(1, preferredTileSize.width);
            this.preferredTileHeight = Math.max(1, preferredTileSize.height);
        } else {
            this.preferredTileWidth = 256;
            this.preferredTileHeight = 256;
        }
        this.isTileSizeAdjustmentAllowed = isTileSizeAdjustmentAllowed;
        this.isImageBoundsAdjustmentAllowed = isImageBoundsAdjustmentAllowed;
        this.isPartialTilesAllowed = isPartialTilesAllowed;
        if (preferredMinTile != null) {
            this.preferredMinTileX = preferredMinTile.x;
            this.preferredMinTileY = preferredMinTile.y;
        } else {
            this.preferredMinTileX = 0;
            this.preferredMinTileY = 0;
        }
    }

    static ImageLayout forDestination(WritableRenderedImage source, int minTileX, int minTileY) {
        return new FixedDestination(source, minTileX, minTileY);
    }

    public ImageLayout withSampleModel(SampleModel model, boolean cascade) {
        int width = this.preferredTileWidth;
        int height = this.preferredTileHeight;
        if (cascade && model != null) {
            width = model.getWidth();
            height = model.getHeight();
        }
        if (Objects.equals(this.sampleModel, model) && width == this.preferredTileWidth && height == this.preferredTileHeight) {
            return this;
        }
        return new ImageLayout(model, new Dimension(width, height), this.isTileSizeAdjustmentAllowed, this.isImageBoundsAdjustmentAllowed, this.isPartialTilesAllowed, this.getPreferredMinTile());
    }

    public ImageLayout allowTileSizeAdjustments(boolean allowed) {
        if (this.isTileSizeAdjustmentAllowed == allowed) {
            return this;
        }
        return new ImageLayout(this.sampleModel, this.getPreferredTileSize(), allowed, this.isImageBoundsAdjustmentAllowed, this.isPartialTilesAllowed, this.getPreferredMinTile());
    }

    public ImageLayout allowImageBoundsAdjustments(boolean allowed) {
        if (this.isImageBoundsAdjustmentAllowed == allowed) {
            return this;
        }
        return new ImageLayout(this.sampleModel, this.getPreferredTileSize(), this.isTileSizeAdjustmentAllowed, allowed, this.isPartialTilesAllowed, this.getPreferredMinTile());
    }

    public ImageLayout allowPartialTiles(boolean allowed) {
        if (this.isPartialTilesAllowed == allowed) {
            return this;
        }
        return new ImageLayout(this.sampleModel, this.getPreferredTileSize(), this.isTileSizeAdjustmentAllowed, this.isImageBoundsAdjustmentAllowed, allowed, this.getPreferredMinTile());
    }

    public ImageLayout withTileMatrix(RenderedImage source) {
        Dimension preferredTileSize = new Dimension(source.getTileWidth(), source.getTileHeight());
        Point preferredMinTile = new Point(source.getMinTileX(), source.getMinTileY());
        if (preferredTileSize.width == this.preferredTileWidth && preferredTileSize.height == this.preferredTileHeight && preferredMinTile.x == this.preferredMinTileX && preferredMinTile.y == this.preferredMinTileY) {
            return this;
        }
        return new ImageLayout(this.sampleModel, preferredTileSize, this.isTileSizeAdjustmentAllowed, this.isImageBoundsAdjustmentAllowed, this.isPartialTilesAllowed, preferredMinTile);
    }

    public ImageLayout withPreferredTileSize(Dimension size) {
        if (size.width == this.preferredTileWidth && size.height == this.preferredTileHeight) {
            return this;
        }
        return new ImageLayout(this.sampleModel, size, this.isTileSizeAdjustmentAllowed, this.isImageBoundsAdjustmentAllowed, this.isPartialTilesAllowed, this.getPreferredMinTile());
    }

    public final Dimension getPreferredTileSize() {
        return new Dimension(this.preferredTileWidth, this.preferredTileHeight);
    }

    private static int toTileSize(int imageSize, int preferredTileSize, boolean allowPartialTiles) {
        int maxTileSize = 2 * preferredTileSize;
        if (imageSize <= maxTileSize) {
            return imageSize;
        }
        int rmax = imageSize % preferredTileSize;
        if (rmax == 0) {
            return preferredTileSize;
        }
        int[] divisors = MathFunctions.divisors((int)imageSize);
        int i = Arrays.binarySearch(divisors, preferredTileSize);
        if ((i ^= 0xFFFFFFFF) < divisors.length) {
            boolean tooSmall;
            int smaller;
            if (i == 0) {
                smaller = 0;
                tooSmall = true;
            } else {
                smaller = divisors[i - 1];
                tooSmall = smaller < 180;
            }
            int larger = divisors[i];
            if (larger <= (allowPartialTiles ? maxTileSize : imageSize) && (tooSmall || larger - preferredTileSize <= preferredTileSize - smaller)) {
                return larger;
            }
            if (!tooSmall) {
                return smaller;
            }
        }
        if (!allowPartialTiles) {
            return imageSize;
        }
        int best = preferredTileSize;
        i = maxTileSize;
        while (--i >= 180) {
            int r = imageSize % i;
            if (r <= rmax && (r != rmax || Math.abs(i - preferredTileSize) >= Math.abs(best - preferredTileSize))) continue;
            rmax = r;
            best = i;
        }
        return best;
    }

    public Dimension suggestTileSize(int imageWidth, int imageHeight) {
        int tileWidth = this.preferredTileWidth;
        int tileHeight = this.preferredTileHeight;
        if (this.isTileSizeAdjustmentAllowed) {
            tileWidth = ImageLayout.toTileSize(imageWidth, tileWidth, this.isPartialTilesAllowed);
            tileHeight = ImageLayout.toTileSize(imageHeight, tileHeight, this.isPartialTilesAllowed);
        }
        return new Dimension(tileWidth, tileHeight);
    }

    public Dimension suggestTileSize(RenderedImage image, Rectangle bounds) {
        int height;
        int width;
        boolean singleYTile;
        boolean singleXTile;
        if (bounds != null && bounds.isEmpty()) {
            throw new IllegalArgumentException(Errors.format((short)44, (Object)"bounds"));
        }
        boolean allowPartialTiles = this.isPartialTilesAllowed;
        if (allowPartialTiles && image != null && !this.isImageBoundsAdjustmentAllowed) {
            ColorModel cm = image.getColorModel();
            boolean bl = allowPartialTiles = cm != null;
            if (allowPartialTiles) {
                if (cm instanceof IndexColorModel) {
                    allowPartialTiles = ((IndexColorModel)cm).getTransparentPixel() == 0;
                } else {
                    boolean bl2 = allowPartialTiles = cm.getTransparency() != 1;
                }
            }
        }
        if (bounds != null) {
            singleXTile = true;
            singleYTile = true;
            width = bounds.width;
            height = bounds.height;
        } else if (image != null) {
            singleXTile = image.getNumXTiles() <= 1;
            singleYTile = image.getNumYTiles() <= 1;
            width = singleXTile ? image.getWidth() : image.getTileWidth();
            height = singleYTile ? image.getHeight() : image.getTileHeight();
        } else {
            return this.getPreferredTileSize();
        }
        int tileWidth = this.preferredTileWidth;
        int tileHeight = this.preferredTileHeight;
        if (this.isTileSizeAdjustmentAllowed) {
            tileWidth = ImageLayout.toTileSize(width, tileWidth, allowPartialTiles & singleXTile);
            tileHeight = ImageLayout.toTileSize(height, tileHeight, allowPartialTiles & singleYTile);
        }
        if (this.isImageBoundsAdjustmentAllowed && bounds != null && !bounds.isEmpty()) {
            int sx = ImageLayout.sizeToAdd(bounds.width, tileWidth);
            int sy = ImageLayout.sizeToAdd(bounds.height, tileHeight);
            if ((bounds.width += sx) < 0) {
                bounds.width -= tileWidth;
            }
            if ((bounds.height += sy) < 0) {
                bounds.height -= tileHeight;
            }
            bounds.translate(-sx / 2, -sy / 2);
        }
        return new Dimension(tileWidth, tileHeight);
    }

    private static int sizeToAdd(int size, int tileSize) {
        if ((size %= tileSize) != 0) {
            size = tileSize - size;
        }
        return size;
    }

    private void checkBandCount(int actual) {
        int expected = this.sampleModel.getNumBands();
        if (expected != actual) {
            throw new IllegalStateException(Resources.format((short)67, expected, actual));
        }
    }

    public SampleModel createCompatibleSampleModel(RenderedImage image, Rectangle bounds) {
        SampleModel sm = image.getSampleModel();
        if (this.sampleModel != null) {
            this.checkBandCount(sm.getNumBands());
            sm = this.sampleModel;
        }
        return ImageLayout.createCompatibleSampleModel(sm, this.suggestTileSize(image, bounds));
    }

    private static SampleModel createCompatibleSampleModel(SampleModel sm, Dimension tile) {
        if (sm.getWidth() != tile.width || sm.getHeight() != tile.height) {
            sm = sm.createCompatibleSampleModel(tile.width, tile.height);
            sm = RasterFactory.unique(sm);
        }
        return sm;
    }

    public SampleModel createSampleModel(DataType dataType, Rectangle bounds, int numBands) {
        ArgumentChecks.ensureNonNull((String)"bounds", (Object)bounds);
        if (this.sampleModel != null) {
            this.checkBandCount(numBands);
            return ImageLayout.createCompatibleSampleModel(this.sampleModel, this.suggestTileSize(null, bounds));
        }
        return this.createBandedSampleModel(null, bounds, dataType, numBands, 0);
    }

    final BandedSampleModel createBandedSampleModel(RenderedImage image, Rectangle bounds, DataType dataType, int numBands, int scanlineStride) {
        Dimension tileSize = this.suggestTileSize(image, bounds);
        if (scanlineStride <= 0) {
            scanlineStride = tileSize.width;
        }
        return RasterFactory.unique(new BandedSampleModel(dataType.toDataBufferType(), tileSize.width, tileSize.height, scanlineStride, ArraysExt.range((int)0, (int)numBands), new int[numBands]));
    }

    public final Point getPreferredMinTile() {
        return new Point(this.preferredMinTileX, this.preferredMinTileY);
    }

    WritableRenderedImage getDestination() {
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String preferredTileSize = sb.append(this.preferredTileWidth).append('\u00d7').append(this.preferredTileHeight).toString();
        sb.setLength(0);
        String preferredMinTile = sb.append('(').append(this.preferredMinTileX).append(", ").append(this.preferredMinTileY).append(')').toString();
        return Strings.toString(this.getClass(), (Object[])new Object[]{"preferredTileSize", preferredTileSize, "isTileSizeAdjustmentAllowed", this.isTileSizeAdjustmentAllowed, "isImageBoundsAdjustmentAllowed", this.isImageBoundsAdjustmentAllowed, "isPartialTilesAllowed", this.isPartialTilesAllowed, "preferredMinTile", preferredMinTile});
    }

    private static final class FixedDestination
    extends ImageLayout {
        private final WritableRenderedImage destination;

        FixedDestination(WritableRenderedImage destination, int minTileX, int minTileY) {
            super(destination.getSampleModel(), new Dimension(destination.getTileWidth(), destination.getTileHeight()), false, false, true, new Point(minTileX, minTileY));
            this.destination = destination;
        }

        @Override
        public WritableRenderedImage getDestination() {
            return this.destination;
        }

        @Override
        public SampleModel createCompatibleSampleModel(RenderedImage image, Rectangle bounds) {
            return this.destination.getSampleModel();
        }
    }
}

