/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf.base;

import org.apache.sis.math.Vector;

public enum DataType {
    UNKNOWN(0, Object.class, false, false, 0, null),
    BYTE(3, Byte.class, true, false, 7, org.apache.sis.image.DataType.BYTE),
    CHAR(3, Character.class, false, true, 2, null),
    SHORT(4, Short.class, true, false, 8, org.apache.sis.image.DataType.SHORT),
    INT(5, Integer.class, true, false, 9, org.apache.sis.image.DataType.INT),
    FLOAT(8, Float.class, false, false, 5, org.apache.sis.image.DataType.FLOAT),
    DOUBLE(9, Double.class, false, false, 6, org.apache.sis.image.DataType.DOUBLE),
    UBYTE(3, Short.class, true, true, 1, org.apache.sis.image.DataType.BYTE),
    USHORT(4, Integer.class, true, true, 3, org.apache.sis.image.DataType.USHORT),
    UINT(5, Long.class, true, true, 4, org.apache.sis.image.DataType.UINT),
    INT64(6, Long.class, true, false, 11, null),
    UINT64(6, Number.class, true, true, 10, null),
    STRING(0, String.class, false, false, 12, null);

    public final byte number;
    public final boolean isInteger;
    public final boolean isUnsigned;
    private final byte opposite;
    public final org.apache.sis.image.DataType rasterDataType;
    private final Class<?> classe;
    private static final DataType[] VALUES;

    private DataType(byte number, Class<?> classe, boolean isInteger, boolean isUnsigned, byte opposite, org.apache.sis.image.DataType rasterDataType) {
        this.number = number;
        this.classe = classe;
        this.isInteger = isInteger;
        this.isUnsigned = isUnsigned;
        this.opposite = opposite;
        this.rasterDataType = rasterDataType;
    }

    final Class<?> getClass(boolean vector) {
        if (vector) {
            if (this.classe == Character.class) {
                return String.class;
            }
            if (Number.class.isAssignableFrom(this.classe)) {
                return Vector.class;
            }
            return Object.class;
        }
        return this.classe;
    }

    public final int size() {
        switch (this.number) {
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 5: 
            case 8: {
                return 4;
            }
            case 6: 
            case 9: {
                return 8;
            }
        }
        return 0;
    }

    public final DataType unsigned(boolean u) {
        return u == this.isUnsigned ? this : DataType.valueOf(this.opposite);
    }

    public static DataType valueOf(int code) {
        return code >= 0 && code < VALUES.length ? VALUES[code] : UNKNOWN;
    }

    static {
        VALUES = DataType.values();
    }
}

