/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.http;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseCompression;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseCredentials;
import com.clickhouse.client.ClickHouseInputStream;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseOutputStream;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.config.ClickHouseOption;
import com.clickhouse.client.data.ClickHouseExternalTable;
import com.clickhouse.client.http.ClickHouseHttpResponse;
import com.clickhouse.client.http.config.ClickHouseHttpOption;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class ClickHouseHttpConnection
implements AutoCloseable {
    protected final ClickHouseConfig config;
    protected final ClickHouseNode server;
    protected final ClickHouseOutputStream output;
    protected final String url;
    protected final Map<String, String> defaultHeaders;

    private static StringBuilder appendQueryParameter(StringBuilder builder, String key, String value) {
        return builder.append(ClickHouseHttpConnection.urlEncode(key, StandardCharsets.UTF_8)).append('=').append(ClickHouseHttpConnection.urlEncode(value, StandardCharsets.UTF_8)).append('&');
    }

    static String urlEncode(String str, Charset charset) {
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        try {
            return URLEncoder.encode(str, charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static String buildQueryParams(ClickHouseRequest<?> request) {
        Optional optionalValue;
        String comment;
        if (request == null) {
            return "";
        }
        ClickHouseConfig config = request.getConfig();
        StringBuilder builder = new StringBuilder();
        Map customParams = ClickHouseUtils.getKeyValuePairs((String)((String)((Object)config.getOption((ClickHouseOption)ClickHouseHttpOption.CUSTOM_PARAMS))));
        for (Map.Entry cp : customParams.entrySet()) {
            ClickHouseHttpConnection.appendQueryParameter(builder, (String)cp.getKey(), (String)cp.getValue());
        }
        ClickHouseInputStream chIn = request.getInputStream().orElse(null);
        if (chIn != null && chIn.getUnderlyingFile().isAvailable()) {
            ClickHouseHttpConnection.appendQueryParameter(builder, "query", (String)request.getStatements().get(0));
        } else if (config.isRequestCompressed()) {
            ClickHouseHttpConnection.appendQueryParameter(builder, "decompress", "1");
        }
        ClickHouseOutputStream chOut = request.getOutputStream().orElse(null);
        if (chOut != null && chOut.getUnderlyingFile().isAvailable()) {
            ClickHouseHttpConnection.appendQueryParameter(builder, "enable_http_compression", "1");
        } else if (config.isResponseCompressed()) {
            ClickHouseHttpConnection.appendQueryParameter(builder, "compress", "1");
        }
        Map settings = request.getSettings();
        List stmts = request.getStatements(false);
        String settingKey = "max_execution_time";
        if (config.getMaxExecutionTime() > 0 && !settings.containsKey(settingKey)) {
            ClickHouseHttpConnection.appendQueryParameter(builder, settingKey, String.valueOf(config.getMaxExecutionTime()));
        }
        settingKey = "max_result_rows";
        if (config.getMaxResultRows() > 0L && !settings.containsKey(settingKey)) {
            ClickHouseHttpConnection.appendQueryParameter(builder, settingKey, String.valueOf(config.getMaxResultRows()));
            ClickHouseHttpConnection.appendQueryParameter(builder, "result_overflow_mode", "break");
        }
        settingKey = "log_comment";
        if (!stmts.isEmpty() && ((Boolean)config.getOption((ClickHouseOption)ClickHouseClientOption.LOG_LEADING_COMMENT)).booleanValue() && !settings.containsKey(settingKey) && !(comment = ClickHouseUtils.getLeadingComment((String)((String)stmts.get(0)))).isEmpty()) {
            ClickHouseHttpConnection.appendQueryParameter(builder, settingKey, comment);
        }
        if (!settings.containsKey(settingKey = "extremes")) {
            ClickHouseHttpConnection.appendQueryParameter(builder, settingKey, "0");
        }
        if ((optionalValue = request.getSessionId()).isPresent()) {
            ClickHouseHttpConnection.appendQueryParameter(builder, "session_id", (String)optionalValue.get());
            if (config.isSessionCheck()) {
                ClickHouseHttpConnection.appendQueryParameter(builder, "session_check", "1");
            }
            if (config.getSessionTimeout() > 0) {
                ClickHouseHttpConnection.appendQueryParameter(builder, "session_timeout", String.valueOf(config.getSessionTimeout()));
            }
        }
        if ((optionalValue = request.getQueryId()).isPresent()) {
            ClickHouseHttpConnection.appendQueryParameter(builder, "query_id", (String)optionalValue.get());
        }
        for (Map.Entry entry : settings.entrySet()) {
            ClickHouseHttpConnection.appendQueryParameter(builder, (String)entry.getKey(), String.valueOf(entry.getValue()));
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    static String buildUrl(String baseUrl, ClickHouseRequest<?> request) {
        String query;
        ClickHouseConfig config = request.getConfig();
        StringBuilder builder = new StringBuilder().append(baseUrl);
        String context = (String)((Object)config.getOption((ClickHouseOption)ClickHouseHttpOption.WEB_CONTEXT));
        if (!ClickHouseChecker.isNullOrEmpty((CharSequence)context)) {
            char ch;
            char prev = '/';
            int len = context.length();
            for (int i = 0; i < len && (ch = context.charAt(i)) != '?' && ch != '#'; ++i) {
                if (ch != '/' || ch != prev) {
                    builder.append(ch);
                }
                prev = ch;
            }
        }
        if (!(query = ClickHouseHttpConnection.buildQueryParams(request)).isEmpty()) {
            builder.append('?').append(query);
        }
        return builder.toString();
    }

    protected static Map<String, String> createDefaultHeaders(ClickHouseConfig config, ClickHouseNode server) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.putAll(ClickHouseUtils.getKeyValuePairs((String)((String)((Object)config.getOption((ClickHouseOption)ClickHouseHttpOption.CUSTOM_HEADERS)))));
        map.put("Accept", "*/*");
        if (!((Boolean)config.getOption((ClickHouseOption)ClickHouseHttpOption.KEEP_ALIVE)).booleanValue()) {
            map.put("Connection", "Close");
        }
        map.put("User-Agent", config.getClientName());
        ClickHouseCredentials credentials = server.getCredentials(config);
        if (credentials.useAccessToken()) {
            map.put("Authorization", credentials.getAccessToken());
        } else {
            map.put("X-ClickHouse-User", credentials.getUserName());
            if (config.isSsl() && !ClickHouseChecker.isNullOrEmpty((CharSequence)config.getSslCert())) {
                map.put("X-ClickHouse-SSL-Certificate-Auth", "on");
            } else if (!ClickHouseChecker.isNullOrEmpty((CharSequence)credentials.getPassword())) {
                map.put("X-ClickHouse-Key", credentials.getPassword());
            }
        }
        String database = server.getDatabase(config);
        if (!ClickHouseChecker.isNullOrEmpty((CharSequence)database)) {
            map.put("X-ClickHouse-Database", database);
        }
        map.put("X-ClickHouse-Format", config.getFormat().name());
        if (config.isResponseCompressed()) {
            map.put("Accept-Encoding", config.getResponseCompressAlgorithm().encoding());
        }
        if (config.isRequestCompressed() && config.getRequestCompressAlgorithm() != ClickHouseCompression.LZ4) {
            map.put("Content-Encoding", config.getRequestCompressAlgorithm().encoding());
        }
        return map;
    }

    protected ClickHouseHttpConnection(ClickHouseNode server, ClickHouseRequest<?> request) {
        if (server == null || request == null) {
            throw new IllegalArgumentException("Non-null server and request are required");
        }
        this.config = request.getConfig();
        this.server = server;
        this.output = request.getOutputStream().orElse(null);
        this.url = ClickHouseHttpConnection.buildUrl(server.getBaseUri(), request);
        this.defaultHeaders = Collections.unmodifiableMap(ClickHouseHttpConnection.createDefaultHeaders(this.config, server));
    }

    protected void closeQuietly() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String getBaseUrl() {
        int index = this.url.indexOf(63);
        if (index < 1) {
            index = this.url.length();
        }
        String baseUrl = this.url.substring(0, index);
        if (this.url.charAt(index - 1) != '/') {
            baseUrl = baseUrl.concat("/");
        }
        return baseUrl;
    }

    protected Map<String, String> mergeHeaders(Map<String, String> requestHeaders) {
        if (requestHeaders == null || requestHeaders.isEmpty()) {
            return this.defaultHeaders;
        }
        if (this.isReusable()) {
            return requestHeaders;
        }
        LinkedHashMap<String, String> merged = new LinkedHashMap<String, String>();
        merged.putAll(this.defaultHeaders);
        for (Map.Entry<String, String> header : requestHeaders.entrySet()) {
            if (header.getValue() == null) {
                merged.remove(header.getKey());
                continue;
            }
            merged.put(header.getKey(), header.getValue());
        }
        return merged;
    }

    protected abstract ClickHouseHttpResponse post(String var1, ClickHouseInputStream var2, List<ClickHouseExternalTable> var3, String var4, Map<String, String> var5, ClickHouseConfig var6, Runnable var7) throws IOException;

    protected boolean isReusable() {
        return true;
    }

    public abstract boolean ping(int var1);

    public ClickHouseHttpResponse update(String query) throws IOException {
        return this.post(query, null, null, null, null, null, null);
    }

    public ClickHouseHttpResponse update(String query, Map<String, String> headers) throws IOException {
        return this.post(query, null, null, null, headers, null, null);
    }

    public ClickHouseHttpResponse update(String query, ClickHouseInputStream data) throws IOException {
        return this.post(query, data, null, null, null, null, null);
    }

    public ClickHouseHttpResponse update(String query, ClickHouseInputStream data, Map<String, String> headers) throws IOException {
        return this.post(query, data, null, null, headers, null, null);
    }

    public ClickHouseHttpResponse query(String query) throws IOException {
        return this.post(query, null, null, null, null, null, null);
    }

    public ClickHouseHttpResponse query(String query, Map<String, String> headers) throws IOException {
        return this.post(query, null, null, null, headers, null, null);
    }

    public ClickHouseHttpResponse query(String query, List<ClickHouseExternalTable> tables) throws IOException {
        return this.post(query, null, tables, null, null, null, null);
    }

    public ClickHouseHttpResponse query(String query, List<ClickHouseExternalTable> tables, Map<String, String> headers) throws IOException {
        return this.post(query, null, tables, null, headers, null, null);
    }
}

