/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

public final class Utf8Utils {
    private Utf8Utils() {
    }

    public static int decodeUtf8(byte[] srcBytes, int srcIdx, int srcSize, char[] destChars, int destIdx) {
        byte b;
        int offset;
        if ((srcIdx | srcSize | srcBytes.length - srcIdx - srcSize) < 0 || (destIdx | destChars.length - destIdx - srcSize) < 0) {
            String exMsg = String.format("buffer srcBytes.length=%d, srcIdx=%d, srcSize=%d, destChars.length=%d, destIdx=%d", srcBytes.length, srcIdx, srcSize, destChars.length, destIdx);
            throw new ArrayIndexOutOfBoundsException(exMsg);
        }
        int limit = offset + srcSize;
        int destIdx0 = destIdx;
        for (offset = srcIdx; offset < limit && DecodeUtil.isOneByte(b = srcBytes[offset]); ++offset) {
            DecodeUtil.handleOneByteSafe(b, destChars, destIdx++);
        }
        while (offset < limit) {
            byte byte1;
            if (DecodeUtil.isOneByte(byte1 = srcBytes[offset++])) {
                byte b2;
                DecodeUtil.handleOneByteSafe(byte1, destChars, destIdx++);
                while (offset < limit && DecodeUtil.isOneByte(b2 = srcBytes[offset])) {
                    ++offset;
                    DecodeUtil.handleOneByteSafe(b2, destChars, destIdx++);
                }
                continue;
            }
            if (DecodeUtil.isTwoBytes(byte1)) {
                if (offset >= limit) {
                    throw new IllegalArgumentException("invalid UTF-8.");
                }
                DecodeUtil.handleTwoBytesSafe(byte1, srcBytes[offset++], destChars, destIdx++);
                continue;
            }
            if (DecodeUtil.isThreeBytes(byte1)) {
                if (offset >= limit - 1) {
                    throw new IllegalArgumentException("invalid UTF-8.");
                }
                DecodeUtil.handleThreeBytesSafe(byte1, srcBytes[offset++], srcBytes[offset++], destChars, destIdx++);
                continue;
            }
            if (offset >= limit - 2) {
                throw new IllegalArgumentException("invalid UTF-8.");
            }
            DecodeUtil.handleFourBytesSafe(byte1, srcBytes[offset++], srcBytes[offset++], srcBytes[offset++], destChars, destIdx);
            destIdx += 2;
        }
        return destIdx - destIdx0;
    }

    private static class DecodeUtil {
        private DecodeUtil() {
        }

        private static boolean isOneByte(byte b) {
            return b >= 0;
        }

        private static boolean isTwoBytes(byte b) {
            return b < -32;
        }

        private static boolean isThreeBytes(byte b) {
            return b < -16;
        }

        private static void handleOneByteSafe(byte byte1, char[] resultArr, int resultPos) {
            resultArr[resultPos] = (char)byte1;
        }

        private static void handleTwoBytesSafe(byte byte1, byte byte2, char[] resultArr, int resultPos) {
            DecodeUtil.checkUtf8(byte1, byte2);
            resultArr[resultPos] = (char)((byte1 & 0x1F) << 6 | DecodeUtil.trailingByteValue(byte2));
        }

        private static void checkUtf8(byte byte1, byte byte2) {
            if (byte1 < -62 || DecodeUtil.isNotTrailingByte(byte2)) {
                throw new IllegalArgumentException("invalid UTF-8.");
            }
        }

        private static void handleThreeBytesSafe(byte byte1, byte byte2, byte byte3, char[] resultArr, int resultPos) {
            DecodeUtil.checkUtf8(byte1, byte2, byte3);
            resultArr[resultPos] = (char)((byte1 & 0xF) << 12 | DecodeUtil.trailingByteValue(byte2) << 6 | DecodeUtil.trailingByteValue(byte3));
        }

        private static void checkUtf8(byte byte1, byte byte2, byte byte3) {
            if (DecodeUtil.isNotTrailingByte(byte2) || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96 || DecodeUtil.isNotTrailingByte(byte3)) {
                throw new IllegalArgumentException("invalid UTF-8.");
            }
        }

        private static void handleFourBytesSafe(byte byte1, byte byte2, byte byte3, byte byte4, char[] resultArr, int resultPos) {
            DecodeUtil.checkUtf8(byte1, byte2, byte3, byte4);
            int codepoint = (byte1 & 7) << 18 | DecodeUtil.trailingByteValue(byte2) << 12 | DecodeUtil.trailingByteValue(byte3) << 6 | DecodeUtil.trailingByteValue(byte4);
            resultArr[resultPos] = DecodeUtil.highSurrogate(codepoint);
            resultArr[resultPos + 1] = DecodeUtil.lowSurrogate(codepoint);
        }

        private static void checkUtf8(byte byte1, byte byte2, byte byte3, byte byte4) {
            if (DecodeUtil.isNotTrailingByte(byte2) || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || DecodeUtil.isNotTrailingByte(byte3) || DecodeUtil.isNotTrailingByte(byte4)) {
                throw new IllegalArgumentException("invalid UTF-8.");
            }
        }

        private static boolean isNotTrailingByte(byte b) {
            return b > -65;
        }

        private static int trailingByteValue(byte b) {
            return b & 0x3F;
        }

        private static char highSurrogate(int codePoint) {
            return (char)(55232 + (codePoint >>> 10));
        }

        private static char lowSurrogate(int codePoint) {
            return (char)(56320 + (codePoint & 0x3FF));
        }
    }
}

