/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.waf.handler;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.WafHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.plugin.base.cache.CommonHandleCache;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.base.utils.BeanHolder;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.waf.config.WafConfig;

public class WafPluginDataHandler
implements PluginDataHandler {
    public static final Supplier<CommonHandleCache<String, WafHandle>> CACHED_HANDLE = new BeanHolder(CommonHandleCache::new);

    public void handlerPlugin(PluginData pluginData) {
        WafConfig wafConfig = (WafConfig)GsonUtils.getInstance().fromJson(pluginData.getConfig(), WafConfig.class);
        Singleton.INST.single(WafConfig.class, (Object)wafConfig);
    }

    public void handlerSelector(SelectorData selectorData) {
        if (!selectorData.getContinued().booleanValue()) {
            CACHED_HANDLE.get().cachedHandle((Object)CacheKeyUtils.INST.getKey(selectorData.getId(), "default_rule"), (Object)WafHandle.newDefaultInstance());
        }
    }

    public void removeSelector(SelectorData selectorData) {
        super.removeSelector(selectorData);
    }

    public void handlerRule(RuleData ruleData) {
        Optional.ofNullable(ruleData.getHandle()).ifPresent(s -> {
            WafHandle wafHandle = (WafHandle)GsonUtils.getInstance().fromJson(s, WafHandle.class);
            CACHED_HANDLE.get().cachedHandle((Object)CacheKeyUtils.INST.getKey(ruleData), (Object)wafHandle);
        });
    }

    public void removeRule(RuleData ruleData) {
        Optional.ofNullable(ruleData.getHandle()).ifPresent(s -> CACHED_HANDLE.get().removeHandle((Object)CacheKeyUtils.INST.getKey(ruleData)));
    }

    public String pluginNamed() {
        return PluginEnum.WAF.getName();
    }
}

