/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.lookout.api;

import com.alipay.lookout.common.Assert;

public final class Measurement<T> {
    public static final String EMPTY_STR = "value";
    private String name;
    private final T value;

    public Measurement(String name, T value) {
        Assert.notNull(name, "name is null!");
        this.name = name;
        this.value = value;
    }

    public Measurement(T value) {
        this.name = EMPTY_STR;
        this.value = value;
    }

    public String name() {
        return this.name;
    }

    public T value() {
        return this.value;
    }

    public boolean equals(Object obj) {
        boolean valueEqual;
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Measurement)) {
            return false;
        }
        Measurement other = (Measurement)obj;
        boolean bl = valueEqual = this.value == other.value();
        if (!valueEqual && this.value instanceof Double && other.value instanceof Double) {
            valueEqual = Double.compare((Double)this.value, (Double)other.value) == 0;
        }
        return this.name.equals(other.name) && valueEqual;
    }

    public int hashCode() {
        int prime = 31;
        int hc = 31;
        hc = 31 * hc + this.name.hashCode();
        int valueHashCode = 0;
        valueHashCode = this.value instanceof Double ? Double.valueOf((Double)this.value).hashCode() : this.value.hashCode();
        hc = 31 * hc + valueHashCode;
        return hc;
    }

    public String toString() {
        return "Measurement(" + this.name + ":" + this.value + ")";
    }
}

