/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee11.websocket.server.internal;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.net.HttpCookie;
import java.net.SocketAddress;
import java.net.URI;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jetty.ee11.websocket.server.JettyServerUpgradeRequest;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.websocket.api.ExtensionConfig;
import org.eclipse.jetty.websocket.common.JettyExtensionConfig;
import org.eclipse.jetty.websocket.core.server.ServerUpgradeRequest;

public class DelegatedServerUpgradeRequest
implements JettyServerUpgradeRequest {
    private final HttpFields _httpFields;
    private final ServerUpgradeRequest _upgradeRequest;
    private final HttpServletRequest _httpServletRequest;
    private URI _requestURI;
    private List<HttpCookie> _cookies;
    private Map<String, List<String>> _parameterMap;

    public DelegatedServerUpgradeRequest(ServerUpgradeRequest request) {
        this._httpFields = request.getHeaders();
        this._httpServletRequest = (HttpServletRequest)request.getAttribute("org.eclipse.jetty.websocket.wrappedRequest");
        this._upgradeRequest = request;
    }

    public ServerUpgradeRequest getServerUpgradeRequest() {
        return this._upgradeRequest;
    }

    public List<HttpCookie> getCookies() {
        if (this._cookies == null) {
            Cookie[] reqCookies = this._httpServletRequest.getCookies();
            this._cookies = reqCookies != null ? Arrays.stream(reqCookies).map(c -> new HttpCookie(c.getName(), c.getValue())).collect(Collectors.toList()) : Collections.emptyList();
        }
        return this._cookies;
    }

    public List<ExtensionConfig> getExtensions() {
        return this._upgradeRequest.getExtensions().stream().map(JettyExtensionConfig::new).collect(Collectors.toList());
    }

    public String getHeader(String name) {
        return this._httpFields.get(name);
    }

    public int getHeaderInt(String name) {
        HttpField field = this._httpFields.getField(name);
        return field == null ? -1 : field.getIntValue();
    }

    public Map<String, List<String>> getHeaders() {
        return HttpFields.asMap((HttpFields)this._httpFields);
    }

    public List<String> getHeaders(String name) {
        return this._httpFields.getValuesList(name);
    }

    public String getHost() {
        return this._upgradeRequest.getHttpURI().getHost();
    }

    public String getHttpVersion() {
        return this._upgradeRequest.getConnectionMetaData().getHttpVersion().asString();
    }

    public String getMethod() {
        return this._httpServletRequest.getMethod();
    }

    public String getOrigin() {
        return this._httpServletRequest.getHeader(HttpHeader.ORIGIN.asString());
    }

    public Map<String, List<String>> getParameterMap() {
        Map requestParams;
        if (this._parameterMap == null && (requestParams = this._httpServletRequest.getParameterMap()) != null) {
            this._parameterMap = new HashMap<String, List<String>>(requestParams.size());
            for (Map.Entry entry : requestParams.entrySet()) {
                this._parameterMap.put((String)entry.getKey(), Arrays.asList((String[])entry.getValue()));
            }
        }
        return this._parameterMap;
    }

    public String getProtocolVersion() {
        return this._upgradeRequest.getProtocolVersion();
    }

    public String getQueryString() {
        return this._httpServletRequest.getQueryString();
    }

    public URI getRequestURI() {
        if (this._requestURI == null) {
            try {
                String queryString = this._httpServletRequest.getQueryString();
                StringBuffer uri = this._httpServletRequest.getRequestURL();
                if (queryString != null) {
                    uri.append("?").append(queryString);
                }
                uri.replace(0, uri.indexOf(":"), this._httpServletRequest.isSecure() ? "wss" : "ws");
                this._requestURI = new URI(uri.toString());
            }
            catch (Throwable t) {
                throw new BadMessageException("Bad WebSocket UpgradeRequest URI", t);
            }
        }
        return this._requestURI;
    }

    public HttpSession getSession() {
        return this._httpServletRequest.getSession();
    }

    public List<String> getSubProtocols() {
        return this._upgradeRequest.getSubProtocols();
    }

    public Principal getUserPrincipal() {
        return this._httpServletRequest.getUserPrincipal();
    }

    public boolean hasSubProtocol(String subprotocol) {
        return this._upgradeRequest.hasSubProtocol(subprotocol);
    }

    public boolean isSecure() {
        return this._httpServletRequest.isSecure();
    }

    @Override
    public X509Certificate[] getCertificates() {
        return (X509Certificate[])this._httpServletRequest.getAttribute("jakarta.servlet.request.X509Certificate");
    }

    @Override
    public HttpServletRequest getHttpServletRequest() {
        return this._httpServletRequest;
    }

    @Override
    public Locale getLocale() {
        return this._httpServletRequest.getLocale();
    }

    @Override
    public Enumeration<Locale> getLocales() {
        return this._httpServletRequest.getLocales();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this._upgradeRequest.getConnectionMetaData().getLocalSocketAddress();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this._upgradeRequest.getConnectionMetaData().getRemoteSocketAddress();
    }

    @Override
    public String getRequestPath() {
        return URIUtil.addPaths((String)this._httpServletRequest.getServletPath(), (String)this._httpServletRequest.getPathInfo());
    }

    @Override
    public Object getServletAttribute(String name) {
        return this._upgradeRequest.getAttribute(name);
    }

    @Override
    public Map<String, Object> getServletAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>(2);
        Enumeration attributeNames = this._httpServletRequest.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String name = (String)attributeNames.nextElement();
            attributes.put(name, this._httpServletRequest.getAttribute(name));
        }
        return attributes;
    }

    @Override
    public Map<String, List<String>> getServletParameters() {
        return this.getParameterMap();
    }

    @Override
    public boolean isUserInRole(String role) {
        return this._httpServletRequest.isUserInRole(role);
    }

    @Override
    public void setServletAttribute(String name, Object value) {
        this._upgradeRequest.setAttribute(name, value);
    }
}

