/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.factory;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.comparison.BetweenExpression;
import org.apache.qpid.server.query.engine.parsing.expression.comparison.EqualExpression;
import org.apache.qpid.server.query.engine.parsing.expression.comparison.GreaterThanExpression;
import org.apache.qpid.server.query.engine.parsing.expression.comparison.GreaterThanOrEqualExpression;
import org.apache.qpid.server.query.engine.parsing.expression.comparison.InExpression;
import org.apache.qpid.server.query.engine.parsing.expression.comparison.IsNullExpression;
import org.apache.qpid.server.query.engine.parsing.expression.comparison.LessThanExpression;
import org.apache.qpid.server.query.engine.parsing.expression.comparison.LessThanOrEqualExpression;
import org.apache.qpid.server.query.engine.parsing.expression.comparison.LikeExpression;
import org.apache.qpid.server.query.engine.parsing.expression.logic.NotExpression;
import org.apache.qpid.server.query.engine.parsing.query.SelectExpression;

public final class ComparisonExpressionFactory {
    private ComparisonExpressionFactory() {
    }

    public static <T, R> Predicate<T> equalExpression(ExpressionNode<T, R> left, ExpressionNode<T, R> right) {
        Objects.requireNonNull(left, "Child expression should be not null");
        Objects.requireNonNull(right, "Child expression should be not null");
        return new EqualExpression<T, R>(left, right);
    }

    public static <T, R> Predicate<T> notEqualExpression(ExpressionNode<T, R> left, ExpressionNode<T, R> right) {
        Objects.requireNonNull(left, "Child expression should be not null");
        Objects.requireNonNull(right, "Child expression should be not null");
        return new NotExpression<T, R>(new EqualExpression<T, R>(left, right));
    }

    public static <T, R> Predicate<T> isNullExpression(ExpressionNode<T, R> left) {
        Objects.requireNonNull(left, "Child expression should be not null");
        return new IsNullExpression<T>(left);
    }

    public static <T, R> Predicate<T> isNotNullExpression(ExpressionNode<T, R> left) {
        Objects.requireNonNull(left, "Child expression should be not null");
        return new NotExpression(new IsNullExpression<T>(left));
    }

    public static <T, R> LikeExpression<T, R> likeExpression(ExpressionNode<T, R> left, String source, String escape) {
        Objects.requireNonNull(left, "Child expression should be not null");
        return new LikeExpression<T, R>(left, source, escape);
    }

    public static <T, R> BetweenExpression<T, R> betweenExpression(String alias, ExpressionNode<T, R> left, ExpressionNode<T, R> low, ExpressionNode<T, R> high) {
        Objects.requireNonNull(left, "Child expression should be not null");
        Objects.requireNonNull(low, "Child expression should be not null");
        Objects.requireNonNull(high, "Child expression should be not null");
        return new BetweenExpression(alias, left, low, high);
    }

    public static <T, R> GreaterThanExpression<T, R> greaterThanExpression(ExpressionNode<T, R> left, ExpressionNode<T, R> right) {
        Objects.requireNonNull(left, "Child expression should be not null");
        Objects.requireNonNull(right, "Child expression should be not null");
        return new GreaterThanExpression(left, right);
    }

    public static <T, R> Predicate<T> greaterThanOrEqualExpression(ExpressionNode<T, R> left, ExpressionNode<T, R> right) {
        Objects.requireNonNull(left, "Child expression should be not null");
        Objects.requireNonNull(right, "Child expression should be not null");
        return new GreaterThanOrEqualExpression(left, right);
    }

    public static <T, R> Predicate<T> lessThanExpression(ExpressionNode<T, R> left, ExpressionNode<T, R> right) {
        Objects.requireNonNull(left, "Child expression should be not null");
        Objects.requireNonNull(right, "Child expression should be not null");
        return new LessThanExpression(left, right);
    }

    public static <T, R> Predicate<T> lessThanOrEqualExpression(ExpressionNode<T, R> left, ExpressionNode<T, R> right) {
        Objects.requireNonNull(left, "Child expression should be not null");
        Objects.requireNonNull(right, "Child expression should be not null");
        return new LessThanOrEqualExpression(left, right);
    }

    public static <T, R> InExpression<T, R> inExpression(ExpressionNode<T, R> left, List<ExpressionNode<T, R>> right) {
        Objects.requireNonNull(left, "Child expression should be not null");
        Objects.requireNonNull(right, "Child expressions should be not null");
        List list = Stream.concat(Stream.of(left), right.stream()).collect(Collectors.toList());
        return new InExpression(list);
    }

    public static <T, R> InExpression<T, R> inExpression(ExpressionNode<T, R> left, SelectExpression<T, R> right) {
        Objects.requireNonNull(left, "Child expression should be not null");
        Objects.requireNonNull(right, "Child expression should be not null");
        return new InExpression<T, R>(left, right);
    }
}

