/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.log.BasicVersionedWriteLoggable;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.VersionedWriteLoggable;
import com.sleepycat.utilint.StringUtils;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;

public class DatabaseId
extends BasicVersionedWriteLoggable
implements Comparable<DatabaseId> {
    private static final int LAST_FORMAT_CHANGE = 8;
    private long id;

    public DatabaseId(long id) {
        this.id = id;
    }

    public DatabaseId() {
    }

    public long getId() {
        return this.id;
    }

    public byte[] getBytes() throws DatabaseException {
        return StringUtils.toUTF8(this.toString());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DatabaseId)) {
            return false;
        }
        return ((DatabaseId)obj).id == this.id;
    }

    public int hashCode() {
        return (int)this.id;
    }

    public String toString() {
        return Long.toString(this.id);
    }

    @Override
    public int compareTo(DatabaseId o) {
        if (o == null) {
            throw EnvironmentFailureException.unexpectedState("null arg");
        }
        if (this.id == o.id) {
            return 0;
        }
        if (this.id > o.id) {
            return 1;
        }
        return -1;
    }

    @Override
    public int getLastFormatChange() {
        return 8;
    }

    @Override
    public Collection<VersionedWriteLoggable> getEmbeddedLoggables() {
        return Collections.emptyList();
    }

    @Override
    public int getLogSize(int logVersion, boolean forReplication) {
        return LogUtils.getPackedLongLogSize(this.id);
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer, int logVersion, boolean forReplication) {
        LogUtils.writePackedLong(logBuffer, this.id);
    }

    @Override
    public void readFromLog(ByteBuffer itemBuffer, int entryVersion) {
        this.id = entryVersion < 6 ? (long)LogUtils.readInt(itemBuffer) : LogUtils.readPackedLong(itemBuffer);
    }

    @Override
    public void dumpLog(StringBuilder sb, boolean verbose) {
        sb.append("<dbId id=\"");
        sb.append(this.id);
        sb.append("\"/>");
    }

    @Override
    public long getTransactionId() {
        return 0L;
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        if (!(other instanceof DatabaseId)) {
            return false;
        }
        return this.id == ((DatabaseId)other).id;
    }
}

