/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.RawMessage;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.RawReaderImpl;
import org.apache.pulsar.client.impl.conf.ConsumerConfigurationData;

public interface RawReader {
    public static CompletableFuture<RawReader> create(PulsarClient client, String topic, String subscription) {
        return RawReader.create(client, topic, subscription, true, true);
    }

    public static CompletableFuture<RawReader> create(PulsarClient client, String topic, String subscription, boolean createTopicIfDoesNotExist, boolean retryOnRecoverableErrors) {
        CompletableFuture<Consumer<byte[]>> future = new CompletableFuture<Consumer<byte[]>>();
        RawReaderImpl r = new RawReaderImpl((PulsarClientImpl)client, topic, subscription, future, createTopicIfDoesNotExist, retryOnRecoverableErrors);
        return future.thenApply(__ -> r);
    }

    public static CompletableFuture<RawReader> create(PulsarClient client, ConsumerConfigurationData<byte[]> consumerConfiguration, boolean createTopicIfDoesNotExist, boolean retryOnRecoverableErrors) {
        CompletableFuture<Consumer<byte[]>> future = new CompletableFuture<Consumer<byte[]>>();
        RawReaderImpl r = new RawReaderImpl((PulsarClientImpl)client, consumerConfiguration, future, createTopicIfDoesNotExist, retryOnRecoverableErrors);
        return future.thenApply(__ -> r);
    }

    public String getTopic();

    public CompletableFuture<Boolean> hasMessageAvailableAsync();

    public CompletableFuture<Void> seekAsync(MessageId var1);

    public CompletableFuture<RawMessage> readNextAsync();

    public CompletableFuture<Void> acknowledgeCumulativeAsync(MessageId var1, Map<String, Long> var2);

    public CompletableFuture<MessageId> getLastMessageIdAsync();

    public CompletableFuture<Void> closeAsync();

    default public void pause() {
    }

    default public void resume() {
    }
}

