/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.airlift.slice.Slice;
import io.trino.block.BlockSerdeUtil;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.FunctionNullability;
import io.trino.metadata.LongVariableConstraint;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlScalarFunction;
import io.trino.metadata.TypeVariableConstraint;
import io.trino.operator.scalar.ChoicesScalarFunctionImplementation;
import io.trino.operator.scalar.ScalarFunctionImplementation;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Objects;

public class LiteralFunction
extends SqlScalarFunction {
    public static final String LITERAL_FUNCTION_NAME = "$literal$";
    private final BlockEncodingSerde blockEncodingSerde;

    public LiteralFunction(BlockEncodingSerde blockEncodingSerde) {
        super(new FunctionMetadata(new Signature(LITERAL_FUNCTION_NAME, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("F"), (Object)Signature.typeVariable("T")), (List<LongVariableConstraint>)ImmutableList.of(), new TypeSignature("T", new TypeSignatureParameter[0]), (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("F", new TypeSignatureParameter[0])), false), new FunctionNullability(false, (List<Boolean>)ImmutableList.of((Object)false)), true, true, "literal", FunctionKind.SCALAR));
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundSignature boundSignature) {
        Type parameterType = boundSignature.getArgumentTypes().get(0);
        Type type = boundSignature.getReturnType();
        MethodHandle methodHandle = null;
        if (parameterType.getJavaType() == type.getJavaType()) {
            methodHandle = MethodHandles.identity(parameterType.getJavaType());
        }
        if (parameterType.getJavaType() == Slice.class) {
            if (type.getJavaType() == Block.class) {
                methodHandle = BlockSerdeUtil.READ_BLOCK.bindTo(this.blockEncodingSerde);
            } else if (type.getJavaType() != Slice.class) {
                methodHandle = BlockSerdeUtil.READ_BLOCK_VALUE.bindTo(this.blockEncodingSerde).bindTo(type);
            }
        }
        Preconditions.checkArgument((methodHandle != null ? 1 : 0) != 0, (String)"Expected type %s to use (or can be converted into) Java type %s, but Java type is %s", (Object)type, (Object)parameterType.getJavaType(), (Object)type.getJavaType());
        return new ChoicesScalarFunctionImplementation(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandle);
    }

    public static Type typeForMagicLiteral(Type type) {
        Class clazz = type.getJavaType();
        if ((clazz = Primitives.unwrap((Class)clazz)) == Long.TYPE) {
            return BigintType.BIGINT;
        }
        if (clazz == Double.TYPE) {
            return DoubleType.DOUBLE;
        }
        if (!clazz.isPrimitive()) {
            if (type instanceof VarcharType) {
                return type;
            }
            return VarbinaryType.VARBINARY;
        }
        if (clazz == Boolean.TYPE) {
            return BooleanType.BOOLEAN;
        }
        throw new IllegalArgumentException("Unhandled Java type: " + clazz.getName());
    }
}

