/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.jetty;

import com.google.common.base.Preconditions;
import io.airlift.concurrent.Threads;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.thread.Scheduler;

class ConcurrentScheduler
extends AbstractLifeCycle
implements Scheduler {
    private final int threadsPerScheduler;
    private final ScheduledExecutorService[] schedulers;
    private final ThreadFactory threadFactory;

    ConcurrentScheduler(int schedulerCount, int threadsPerScheduler, String threadBaseName) {
        Preconditions.checkArgument((schedulerCount > 0 ? 1 : 0) != 0, (Object)"schedulerCount must be at least one");
        this.schedulers = new ScheduledThreadPoolExecutor[schedulerCount];
        Preconditions.checkArgument((threadsPerScheduler > 0 ? 1 : 0) != 0, (Object)"threadsPerScheduler must be at least one");
        this.threadsPerScheduler = threadsPerScheduler;
        Objects.requireNonNull(threadBaseName, "threadBaseName is null");
        this.threadFactory = Threads.daemonThreadsNamed((String)(threadBaseName + "-timeout-%s"));
    }

    protected void doStart() {
        for (int i = 0; i < this.schedulers.length; ++i) {
            ScheduledThreadPoolExecutor scheduledExecutorService = new ScheduledThreadPoolExecutor(this.threadsPerScheduler, this.threadFactory);
            scheduledExecutorService.setRemoveOnCancelPolicy(true);
            this.schedulers[i] = scheduledExecutorService;
        }
    }

    protected void doStop() {
        for (int i = 0; i < this.schedulers.length; ++i) {
            this.schedulers[i].shutdownNow();
            this.schedulers[i] = null;
        }
    }

    public Scheduler.Task schedule(Runnable task, long delay, TimeUnit unit) {
        ScheduledExecutorService scheduler = this.schedulers[ThreadLocalRandom.current().nextInt(this.schedulers.length)];
        if (scheduler == null) {
            return () -> false;
        }
        ScheduledFuture<?> result = scheduler.schedule(task, delay, unit);
        return () -> result.cancel(false);
    }
}

