/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cli;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableSet;
import io.trino.cli.Console;
import io.trino.sql.parser.StatementSplitter;
import java.util.Locale;
import java.util.Set;
import org.jline.reader.EOFError;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.SyntaxError;
import org.jline.reader.impl.DefaultParser;

public class InputParser
implements Parser {
    private static final Set<String> SPECIAL = ImmutableSet.of((Object)"exit", (Object)"quit", (Object)"history", (Object)"help", (Object)"clear");

    public ParsedLine parse(String line, int cursor, Parser.ParseContext context) throws SyntaxError {
        String command = CharMatcher.whitespace().trimFrom((CharSequence)line);
        if (command.isEmpty() || SPECIAL.contains(command.toLowerCase(Locale.ENGLISH)) || context == Parser.ParseContext.COMPLETE) {
            return new DefaultParser().parse(line, cursor, context);
        }
        StatementSplitter splitter = new StatementSplitter(line, Console.STATEMENT_DELIMITERS);
        if (splitter.getCompleteStatements().isEmpty()) {
            throw new EOFError(-1, -1, null);
        }
        return new DefaultParser().parse(line, cursor, context);
    }

    public boolean isEscapeChar(char ch) {
        return false;
    }
}

