/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context;

import jakarta.el.ELException;
import jakarta.faces.FacesException;
import jakarta.faces.context.ExceptionHandler;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ExceptionQueuedEvent;
import jakarta.faces.event.ExceptionQueuedEventContext;
import jakarta.faces.event.SystemEvent;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Logger;
import org.apache.myfaces.context.ExceptionHandlerUtils;
import org.apache.myfaces.core.api.shared.lang.Assert;

public class ExceptionHandlerImpl
extends ExceptionHandler {
    private static final Logger log = Logger.getLogger(ExceptionHandlerImpl.class.getName());
    private Queue<ExceptionQueuedEvent> handled;
    private Queue<ExceptionQueuedEvent> unhandled;
    private ExceptionQueuedEvent handledAndThrown;

    public ExceptionQueuedEvent getHandledExceptionQueuedEvent() {
        return this.handledAndThrown;
    }

    public Iterable<ExceptionQueuedEvent> getHandledExceptionQueuedEvents() {
        return this.handled == null ? Collections.emptyList() : this.handled;
    }

    public Throwable getRootCause(Throwable throwable) {
        Assert.notNull((Object)throwable, (String)"throwable");
        while (throwable != null) {
            Class<?> clazz = throwable.getClass();
            if (!clazz.equals(FacesException.class) && !clazz.equals(ELException.class)) {
                return throwable;
            }
            throwable = throwable.getCause();
        }
        return null;
    }

    public Iterable<ExceptionQueuedEvent> getUnhandledExceptionQueuedEvents() {
        return this.unhandled == null ? Collections.emptyList() : this.unhandled;
    }

    public void handle() throws FacesException {
        if (this.unhandled != null && !this.unhandled.isEmpty()) {
            if (this.handled == null) {
                this.handled = new LinkedList<ExceptionQueuedEvent>();
            }
            FacesException toThrow = null;
            do {
                ExceptionQueuedEvent event = this.unhandled.peek();
                try {
                    ExceptionQueuedEventContext context = event.getContext();
                    Throwable exception = context.getException();
                    if (this.shouldSkip(exception)) continue;
                    Throwable rootCause = this.getRootCause(exception);
                    this.handledAndThrown = event;
                    toThrow = this.wrap(rootCause == null ? exception : rootCause);
                    ExceptionHandlerUtils.logException(rootCause == null ? exception : rootCause, context.getComponent(), context.getContext(), log);
                    break;
                }
                catch (Throwable t) {
                    throw new FacesException("Could not perform the algorithm to handle the Exception", t);
                }
                finally {
                    this.handled.add(event);
                    this.unhandled.remove(event);
                }
            } while (!this.unhandled.isEmpty());
            if (toThrow != null) {
                throw toThrow;
            }
        }
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof ExceptionQueuedEventContext;
    }

    public void processEvent(SystemEvent exceptionQueuedEvent) throws AbortProcessingException {
        if (this.unhandled == null) {
            this.unhandled = new LinkedList<ExceptionQueuedEvent>();
        }
        this.unhandled.add((ExceptionQueuedEvent)exceptionQueuedEvent);
    }

    protected FacesException wrap(Throwable exception) {
        if (exception instanceof FacesException) {
            return (FacesException)exception;
        }
        return new FacesException(exception);
    }

    protected boolean shouldSkip(Throwable exception) {
        return exception instanceof AbortProcessingException;
    }
}

