/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.profile;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.profile.ProfilesConfigFile;
import com.amazonaws.util.StringUtils;

public class ProfileCredentialsProvider
implements AWSCredentialsProvider {
    private volatile ProfilesConfigFile profilesConfigFile;
    private final String profileName;

    public ProfileCredentialsProvider() {
        this(null);
    }

    public ProfileCredentialsProvider(String profileName) {
        this((ProfilesConfigFile)null, profileName);
    }

    public ProfileCredentialsProvider(String profilesConfigFilePath, String profileName) {
        this(new ProfilesConfigFile(profilesConfigFilePath), profileName);
    }

    public ProfileCredentialsProvider(ProfilesConfigFile profilesConfigFile, String profileName) {
        this.profilesConfigFile = profilesConfigFile;
        if (profileName == null) {
            String profileOverride = System.getenv("AWS_PROFILE");
            this.profileName = !StringUtils.isNullOrEmpty(profileOverride = StringUtils.trim(profileOverride)) ? profileOverride : "default";
        } else {
            this.profileName = profileName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AWSCredentials getCredentials() {
        if (this.profilesConfigFile == null) {
            ProfileCredentialsProvider profileCredentialsProvider = this;
            synchronized (profileCredentialsProvider) {
                if (this.profilesConfigFile == null) {
                    this.profilesConfigFile = new ProfilesConfigFile();
                }
            }
        }
        return this.profilesConfigFile.getCredentials(this.profileName);
    }

    @Override
    public void refresh() {
    }
}

