/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.FieldComparator;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.PushBackStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class MergeStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    private PushBackStream[] streams;
    private StreamComparator comp;

    public MergeStream(TupleStream streamA, TupleStream streamB, StreamComparator comp) throws IOException {
        this.init(comp, streamA, streamB);
    }

    public MergeStream(StreamComparator comp, TupleStream ... streams) throws IOException {
        this.init(comp, streams);
    }

    public MergeStream(StreamExpression expression, StreamFactory factory) throws IOException {
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, TupleStream.class);
        StreamExpressionNamedParameter onExpression = factory.getNamedOperand(expression, "on");
        if (expression.getParameters().size() != streamExpressions.size() + 1) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - unknown operands found", expression));
        }
        if (streamExpressions.size() < 2) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting at least two streams but found %d (must be PushBackStream types)", expression, streamExpressions.size()));
        }
        if (null == onExpression || !(onExpression.getParameter() instanceof StreamExpressionValue)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting single 'on' parameter listing fields to merge on but didn't find one", expression));
        }
        TupleStream[] streams = new TupleStream[streamExpressions.size()];
        for (int idx = 0; idx < streamExpressions.size(); ++idx) {
            streams[idx] = factory.constructStream(streamExpressions.get(idx));
        }
        this.init(factory.constructComparator(((StreamExpressionValue)onExpression.getParameter()).getValue(), FieldComparator.class), streams);
    }

    private void init(StreamComparator comp, TupleStream ... streams) throws IOException {
        for (TupleStream stream : streams) {
            if (comp.isDerivedFrom(stream.getStreamSort())) continue;
            throw new IOException("Invalid MergeStream - all substream comparators (sort) must be a superset of this stream's comparator.");
        }
        this.streams = new PushBackStream[streams.length];
        for (int idx = 0; idx < streams.length; ++idx) {
            this.streams[idx] = new PushBackStream(streams[idx]);
        }
        this.comp = comp;
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        for (PushBackStream stream : this.streams) {
            if (includeStreams) {
                expression.addParameter(stream.toExpression(factory));
                continue;
            }
            expression.addParameter("<stream>");
        }
        expression.addParameter(new StreamExpressionNamedParameter("on", this.comp.toExpression(factory)));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        StreamExplanation explanation = new StreamExplanation(this.getStreamNodeId().toString());
        explanation.setFunctionName(factory.getFunctionName(this.getClass()));
        explanation.setImplementingClass(this.getClass().getName());
        explanation.setExpressionType("stream-decorator");
        explanation.setExpression(this.toExpression(factory, false).toString());
        explanation.addHelper(this.comp.toExplanation(factory));
        for (PushBackStream stream : this.streams) {
            explanation.addChild(stream.toExplanation(factory));
        }
        return explanation;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        for (PushBackStream stream : this.streams) {
            stream.setStreamContext(context);
        }
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        for (PushBackStream stream : this.streams) {
            l.add(stream);
        }
        return l;
    }

    @Override
    public void open() throws IOException {
        for (PushBackStream stream : this.streams) {
            stream.open();
        }
    }

    @Override
    public void close() throws IOException {
        for (PushBackStream stream : this.streams) {
            stream.close();
        }
    }

    @Override
    public Tuple read() throws IOException {
        Tuple minimum = null;
        PushBackStream minimumStream = null;
        for (PushBackStream stream : this.streams) {
            Tuple current = stream.read();
            if (current.EOF) {
                stream.pushBack(current);
                continue;
            }
            if (null == minimum) {
                minimum = current;
                minimumStream = stream;
                continue;
            }
            if (this.comp.compare(current, minimum) < 0) {
                minimumStream.pushBack(minimum);
                minimum = current;
                minimumStream = stream;
                continue;
            }
            stream.pushBack(current);
        }
        if (null == minimum) {
            return this.streams[0].read();
        }
        return minimum;
    }

    @Override
    public StreamComparator getStreamSort() {
        return this.comp;
    }

    @Override
    public int getCost() {
        return 0;
    }
}

