/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.scopes;

import com.github.sommeri.less4j.core.compiler.scopes.IScope;
import com.github.sommeri.less4j.core.problems.BugHappened;
import java.util.ArrayList;
import java.util.Iterator;

public class IteratedScope {
    private final IScope scope;
    private Iterator<IScope> childsIterator;

    public IteratedScope(IScope scope) {
        this.scope = scope;
        this.childsIterator = new ArrayList<IScope>(scope.getChilds()).iterator();
    }

    public IScope getScope() {
        return this.scope;
    }

    public IteratedScope getNextChild() {
        IScope child = null;
        do {
            if (!this.childsIterator.hasNext()) {
                throw new BugHappened("Child scope was expected but missing", this.getScope().getOwner());
            }
            child = this.childsIterator.next();
        } while (!child.isPresentInAst());
        return new IteratedScope(child);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IteratedScope [scope=");
        builder.append(this.scope);
        builder.append("]");
        return builder.toString();
    }
}

