/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k;

import java.util.Enumeration;
import java.util.Hashtable;
import jj2000.j2k.image.Coord;

public class ModuleSpec
implements Cloneable {
    public static final byte SPEC_TYPE_COMP = 0;
    public static final byte SPEC_TYPE_TILE = 1;
    public static final byte SPEC_TYPE_TILE_COMP = 2;
    public static final byte SPEC_DEF = 0;
    public static final byte SPEC_COMP_DEF = 1;
    public static final byte SPEC_TILE_DEF = 2;
    public static final byte SPEC_TILE_COMP = 3;
    protected int specType;
    protected int nTiles = 0;
    protected int nComp = 0;
    protected byte[][] specValType;
    protected Object def = null;
    protected Object[] compDef = null;
    protected Object[] tileDef = null;
    protected Hashtable tileCompVal;

    public ModuleSpec getCopy() {
        return (ModuleSpec)this.clone();
    }

    protected Object clone() {
        int t;
        ModuleSpec ms;
        try {
            ms = (ModuleSpec)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error when cloning ModuleSpec instance");
        }
        ms.specValType = new byte[this.nTiles][this.nComp];
        for (t = 0; t < this.nTiles; ++t) {
            for (int c = 0; c < this.nComp; ++c) {
                ms.specValType[t][c] = this.specValType[t][c];
            }
        }
        if (this.tileDef != null) {
            ms.tileDef = new Object[this.nTiles];
            for (t = 0; t < this.nTiles; ++t) {
                ms.tileDef[t] = this.tileDef[t];
            }
        }
        if (this.tileCompVal != null) {
            ms.tileCompVal = new Hashtable();
            Enumeration e = this.tileCompVal.keys();
            while (e.hasMoreElements()) {
                String tmpKey = (String)e.nextElement();
                Object tmpVal = this.tileCompVal.get(tmpKey);
                ms.tileCompVal.put(tmpKey, tmpVal);
            }
        }
        return ms;
    }

    public void rotate90(Coord anT) {
        int ax;
        int ay;
        byte[][] tmpsvt = new byte[this.nTiles][];
        Coord bnT = new Coord(anT.y, anT.x);
        for (int by = 0; by < bnT.y; ++by) {
            for (int bx = 0; bx < bnT.x; ++bx) {
                ay = bx;
                ax = bnT.y - by - 1;
                tmpsvt[ay * anT.x + ax] = this.specValType[by * bnT.x + bx];
            }
        }
        this.specValType = tmpsvt;
        if (this.tileDef != null) {
            Object[] tmptd = new Object[this.nTiles];
            for (int by = 0; by < bnT.y; ++by) {
                for (int bx = 0; bx < bnT.x; ++bx) {
                    ay = bx;
                    ax = bnT.y - by - 1;
                    tmptd[ay * anT.x + ax] = this.tileDef[by * bnT.x + bx];
                }
            }
            this.tileDef = tmptd;
        }
        if (this.tileCompVal != null && this.tileCompVal.size() > 0) {
            Hashtable tmptcv = new Hashtable();
            Enumeration e = this.tileCompVal.keys();
            while (e.hasMoreElements()) {
                String tmpKey = (String)e.nextElement();
                Object tmpVal = this.tileCompVal.get(tmpKey);
                int i1 = tmpKey.indexOf(116);
                int i2 = tmpKey.indexOf(99);
                int btIdx = new Integer(tmpKey.substring(i1 + 1, i2));
                int bx = btIdx % bnT.x;
                int by = btIdx / bnT.x;
                ay = bx;
                ax = bnT.y - by - 1;
                int atIdx = ax + ay * anT.x;
                tmptcv.put("t" + atIdx + tmpKey.substring(i2), tmpVal);
            }
            this.tileCompVal = tmptcv;
        }
    }

    public ModuleSpec(int nt, int nc, byte type) {
        this.nTiles = nt;
        this.nComp = nc;
        this.specValType = new byte[nt][nc];
        switch (type) {
            case 1: {
                this.specType = 1;
                break;
            }
            case 0: {
                this.specType = 0;
                break;
            }
            case 2: {
                this.specType = 2;
            }
        }
    }

    public void setDefault(Object value) {
        this.def = value;
    }

    public Object getDefault() {
        return this.def;
    }

    public void setCompDef(int c, Object value) {
        if (this.specType == 1) {
            String errMsg = "Option whose value is '" + value + "' cannot be " + "specified for components as it is a 'tile only' specific " + "option";
            throw new Error(errMsg);
        }
        if (this.compDef == null) {
            this.compDef = new Object[this.nComp];
        }
        for (int i = 0; i < this.nTiles; ++i) {
            if (this.specValType[i][c] >= 1) continue;
            this.specValType[i][c] = 1;
        }
        this.compDef[c] = value;
    }

    public Object getCompDef(int c) {
        if (this.specType == 1) {
            throw new Error("Illegal use of ModuleSpec class");
        }
        if (this.compDef == null || this.compDef[c] == null) {
            return this.getDefault();
        }
        return this.compDef[c];
    }

    public void setTileDef(int t, Object value) {
        if (this.specType == 0) {
            String errMsg = "Option whose value is '" + value + "' cannot be " + "specified for tiles as it is a 'component only' specific " + "option";
            throw new Error(errMsg);
        }
        if (this.tileDef == null) {
            this.tileDef = new Object[this.nTiles];
        }
        for (int i = 0; i < this.nComp; ++i) {
            if (this.specValType[t][i] >= 2) continue;
            this.specValType[t][i] = 2;
        }
        this.tileDef[t] = value;
    }

    public Object getTileDef(int t) {
        if (this.specType == 0) {
            throw new Error("Illegal use of ModuleSpec class");
        }
        if (this.tileDef == null || this.tileDef[t] == null) {
            return this.getDefault();
        }
        return this.tileDef[t];
    }

    public void setTileCompVal(int t, int c, Object value) {
        if (this.specType != 2) {
            String errMsg = "Option whose value is '" + value + "' cannot be " + "specified for ";
            switch (this.specType) {
                case 1: {
                    errMsg = errMsg + "components as it is a 'tile only' specific option";
                    break;
                }
                case 0: {
                    errMsg = errMsg + "tiles as it is a 'component only' specific option";
                }
            }
            throw new Error(errMsg);
        }
        if (this.tileCompVal == null) {
            this.tileCompVal = new Hashtable();
        }
        this.specValType[t][c] = 3;
        this.tileCompVal.put("t" + t + "c" + c, value);
    }

    public Object getTileCompVal(int t, int c) {
        if (this.specType != 2) {
            throw new Error("Illegal use of ModuleSpec class");
        }
        return this.getSpec(t, c);
    }

    protected Object getSpec(int t, int c) {
        switch (this.specValType[t][c]) {
            case 0: {
                return this.getDefault();
            }
            case 1: {
                return this.getCompDef(c);
            }
            case 2: {
                return this.getTileDef(t);
            }
            case 3: {
                return this.tileCompVal.get("t" + t + "c" + c);
            }
        }
        throw new IllegalArgumentException("Not recognized spec type");
    }

    public byte getSpecValType(int t, int c) {
        return this.specValType[t][c];
    }

    public boolean isCompSpecified(int c) {
        return this.compDef != null && this.compDef[c] != null;
    }

    public boolean isTileSpecified(int t) {
        return this.tileDef != null && this.tileDef[t] != null;
    }

    public boolean isTileCompSpecified(int t, int c) {
        return this.tileCompVal != null && this.tileCompVal.get("t" + t + "c" + c) != null;
    }

    public static final boolean[] parseIdx(String word, int maxIdx) {
        int j;
        int nChar = word.length();
        char c = word.charAt(0);
        int idx = -1;
        int lastIdx = -1;
        boolean isDash = false;
        boolean[] idxSet = new boolean[maxIdx];
        for (int i = 1; i < nChar; ++i) {
            c = word.charAt(i);
            if (Character.isDigit(c)) {
                if (idx == -1) {
                    idx = 0;
                }
                idx = idx * 10 + (c - 48);
                continue;
            }
            if (idx == -1 || c != ',' && c != '-') {
                throw new IllegalArgumentException("Bad construction for parameter: " + word);
            }
            if (idx < 0 || idx >= maxIdx) {
                throw new IllegalArgumentException("Out of range index in parameter `" + word + "' : " + idx);
            }
            if (c == ',') {
                if (isDash) {
                    for (j = lastIdx + 1; j < idx; ++j) {
                        idxSet[j] = true;
                    }
                }
                isDash = false;
            } else {
                isDash = true;
            }
            idxSet[idx] = true;
            lastIdx = idx;
            idx = -1;
        }
        if (idx < 0 || idx >= maxIdx) {
            throw new IllegalArgumentException("Out of range index in parameter `" + word + "' : " + idx);
        }
        if (isDash) {
            for (j = lastIdx + 1; j < idx; ++j) {
                idxSet[j] = true;
            }
        }
        idxSet[idx] = true;
        return idxSet;
    }
}

