/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.db.TriggerExecutionContext;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.ConnectionContext;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionStmtValidator;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.AutoincrementCounter;
import org.apache.derby.impl.sql.execute.DDLConstantAction;
import org.apache.derby.impl.sql.execute.TableScanResultSet;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderResultSet;
import org.apache.derby.impl.sql.execute.TriggerEvent;

class InternalTriggerExecutionContext
implements TriggerExecutionContext,
ExecutionStmtValidator {
    protected int dmlType;
    protected String statementText;
    protected ConnectionContext cc;
    protected UUID targetTableId;
    protected String targetTableName;
    protected LanguageConnectionContext lcc;
    protected CursorResultSet beforeResultSet;
    protected CursorResultSet afterResultSet;
    protected ExecRow afterRow;
    protected boolean cleanupCalled;
    protected TriggerEvent event;
    protected TriggerDescriptor triggerd;
    private Vector<ResultSet> resultSetVector;
    private Vector<AutoincrementCounter> aiCounters;
    private Hashtable<String, Long> aiHT;

    InternalTriggerExecutionContext(LanguageConnectionContext languageConnectionContext, ConnectionContext connectionContext, String string, int n, UUID uUID, String string2, Vector<AutoincrementCounter> vector) throws StandardException {
        this.dmlType = n;
        this.statementText = string;
        this.cc = connectionContext;
        this.lcc = languageConnectionContext;
        this.targetTableId = uUID;
        this.targetTableName = string2;
        this.resultSetVector = new Vector();
        this.aiCounters = vector;
        languageConnectionContext.pushTriggerExecutionContext(this);
    }

    void setBeforeResultSet(CursorResultSet cursorResultSet) {
        this.beforeResultSet = cursorResultSet;
    }

    void setAfterResultSet(CursorResultSet cursorResultSet) throws StandardException {
        this.afterResultSet = cursorResultSet;
        if (this.aiCounters != null) {
            if (this.triggerd.isRowTrigger()) {
                cursorResultSet.open();
                this.afterRow = cursorResultSet.getNextRow();
                cursorResultSet.close();
            } else if (!this.triggerd.isBeforeTrigger()) {
                this.resetAICounters(false);
            }
        }
    }

    void setCurrentTriggerEvent(TriggerEvent triggerEvent) {
        this.event = triggerEvent;
    }

    void clearCurrentTriggerEvent() {
        this.event = null;
    }

    void setTrigger(TriggerDescriptor triggerDescriptor) {
        this.triggerd = triggerDescriptor;
    }

    void clearTrigger() throws StandardException {
        this.event = null;
        this.triggerd = null;
        if (this.afterResultSet != null) {
            this.afterResultSet.close();
            this.afterResultSet = null;
        }
        if (this.beforeResultSet != null) {
            this.beforeResultSet.close();
            this.beforeResultSet = null;
        }
    }

    protected void cleanup() throws StandardException {
        if (this.lcc != null) {
            this.lcc.popTriggerExecutionContext(this);
        }
        if (this.resultSetVector != null) {
            for (ResultSet resultSet : this.resultSetVector) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        this.resultSetVector = null;
        if (this.afterResultSet != null) {
            this.afterResultSet.close();
            this.afterResultSet = null;
        }
        if (this.beforeResultSet != null) {
            this.beforeResultSet.close();
            this.beforeResultSet = null;
        }
        this.lcc = null;
        this.cleanupCalled = true;
    }

    private void ensureProperContext() throws SQLException {
        if (this.cleanupCalled) {
            throw new SQLException(MessageService.getTextMessage("XCL31.S", new Object[0]), "XCL31", 20000);
        }
    }

    @Override
    public void validateStatement(ConstantAction constantAction) throws StandardException {
        if (constantAction instanceof DDLConstantAction) {
            throw StandardException.newException("X0Y69.S", this.triggerd.getName());
        }
    }

    @Override
    public String getTargetTableName() {
        return this.targetTableName;
    }

    @Override
    public UUID getTargetTableId() {
        return this.targetTableId;
    }

    @Override
    public int getEventType() {
        return this.dmlType;
    }

    @Override
    public String getEventStatementText() {
        return this.statementText;
    }

    @Override
    public ResultSet getOldRowSet() throws SQLException {
        this.ensureProperContext();
        if (this.beforeResultSet == null) {
            return null;
        }
        try {
            CursorResultSet cursorResultSet = this.beforeResultSet;
            if (cursorResultSet instanceof TemporaryRowHolderResultSet) {
                cursorResultSet = (CursorResultSet)((TemporaryRowHolderResultSet)cursorResultSet).clone();
            } else if (cursorResultSet instanceof TableScanResultSet) {
                cursorResultSet = (CursorResultSet)((TableScanResultSet)cursorResultSet).clone();
            }
            cursorResultSet.open();
            ResultSet resultSet = this.cc.getResultSet(cursorResultSet);
            this.resultSetVector.addElement(resultSet);
            return resultSet;
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    @Override
    public ResultSet getNewRowSet() throws SQLException {
        this.ensureProperContext();
        if (this.afterResultSet == null) {
            return null;
        }
        try {
            CursorResultSet cursorResultSet = this.afterResultSet;
            if (cursorResultSet instanceof TemporaryRowHolderResultSet) {
                cursorResultSet = (CursorResultSet)((TemporaryRowHolderResultSet)cursorResultSet).clone();
            } else if (cursorResultSet instanceof TableScanResultSet) {
                cursorResultSet = (CursorResultSet)((TableScanResultSet)cursorResultSet).clone();
            }
            cursorResultSet.open();
            ResultSet resultSet = this.cc.getResultSet(cursorResultSet);
            this.resultSetVector.addElement(resultSet);
            return resultSet;
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    @Override
    public ResultSet getOldRow() throws SQLException {
        ResultSet resultSet = this.getOldRowSet();
        if (resultSet != null) {
            resultSet.next();
        }
        return resultSet;
    }

    @Override
    public ResultSet getNewRow() throws SQLException {
        ResultSet resultSet = this.getNewRowSet();
        if (resultSet != null) {
            resultSet.next();
        }
        return resultSet;
    }

    @Override
    public Long getAutoincrementValue(String string) {
        Object object;
        if (this.aiHT != null && (object = this.aiHT.get(string)) != null) {
            return object;
        }
        if (this.aiCounters != null) {
            for (AutoincrementCounter autoincrementCounter : this.aiCounters) {
                if (!string.equals(autoincrementCounter.getIdentity())) continue;
                return autoincrementCounter.getCurrentValue();
            }
        }
        return null;
    }

    public void copyHashtableToAIHT(Map<String, Long> map) {
        if (map == null) {
            return;
        }
        if (this.aiHT == null) {
            this.aiHT = new Hashtable();
        }
        this.aiHT.putAll(map);
    }

    public void resetAICounters(boolean bl) {
        if (this.aiCounters == null) {
            return;
        }
        this.afterRow = null;
        for (AutoincrementCounter autoincrementCounter : this.aiCounters) {
            autoincrementCounter.reset(bl);
        }
    }

    public void updateAICounters() throws StandardException {
        if (this.aiCounters == null) {
            return;
        }
        for (AutoincrementCounter autoincrementCounter : this.aiCounters) {
            DataValueDescriptor dataValueDescriptor = this.afterRow.getColumn(autoincrementCounter.getColumnPosition());
            autoincrementCounter.update(dataValueDescriptor.getLong());
        }
    }

    public String toString() {
        return this.triggerd.getName();
    }
}

