/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.endTransaction;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.ldap.extras.extended.endTransaction.EndTransactionResponse;
import org.apache.directory.api.ldap.extras.extended.endTransaction.UpdateControls;
import org.apache.directory.api.ldap.model.message.AbstractExtendedResponse;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;

public class EndTransactionResponseImpl
extends AbstractExtendedResponse
implements EndTransactionResponse {
    private int failedMessageId = -1;
    private List<UpdateControls> updateControls = new ArrayList<UpdateControls>();

    public EndTransactionResponseImpl(int failedMessageId, ResultCodeEnum resultCode) {
        super(failedMessageId);
        this.failedMessageId = resultCode == ResultCodeEnum.SUCCESS ? -1 : failedMessageId;
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(resultCode);
    }

    public EndTransactionResponseImpl(int messageId) {
        super(messageId);
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
    }

    public EndTransactionResponseImpl() {
        super("1.3.6.1.1.21.3");
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
    }

    @Override
    public int getFailedMessageId() {
        return this.failedMessageId;
    }

    @Override
    public void setFailedMessageId(int failedMessageId) {
        this.failedMessageId = failedMessageId;
    }

    @Override
    public List<UpdateControls> getUpdateControls() {
        return this.updateControls;
    }

    public void setUpdateControls(List<UpdateControls> updateControls) {
        this.updateControls = updateControls;
    }

    public int hashCode() {
        int hash = 37;
        hash = hash * 17 + this.failedMessageId;
        for (UpdateControls updateControl : this.updateControls) {
            hash = hash * 17 + updateControl.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EndTransactionResponse)) {
            return false;
        }
        EndTransactionResponse that = (EndTransactionResponse)obj;
        if (this.failedMessageId != that.getFailedMessageId()) {
            return false;
        }
        for (UpdateControls updateControl : this.updateControls) {
            if (that.getUpdateControls().contains(updateControl)) continue;
            return false;
        }
        return true;
    }
}

