/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.reflect;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectStreamClass;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.services.reflect.JarLoader;
import org.apache.derby.impl.services.reflect.LoadedGeneratedClass;
import org.apache.derby.impl.services.reflect.UpdateLoader;

abstract class DatabaseClasses
implements ClassFactory,
ModuleControl {
    private ClassInspector classInspector;
    private UpdateLoader applicationLoader;

    DatabaseClasses() {
    }

    @Override
    public void boot(boolean bl, Properties properties) throws StandardException {
        this.classInspector = this.makeClassInspector(this);
        String string = null;
        if (properties != null) {
            string = properties.getProperty("derby.__rt.database.classpath");
        }
        if (string != null) {
            this.applicationLoader = new UpdateLoader(string, this, true, true);
        }
    }

    @Override
    public void stop() {
        if (this.applicationLoader != null) {
            this.applicationLoader.close();
        }
    }

    protected ClassInspector makeClassInspector(DatabaseClasses databaseClasses) {
        return new ClassInspector(databaseClasses);
    }

    @Override
    public final GeneratedClass loadGeneratedClass(String string, ByteArray byteArray) throws StandardException {
        try {
            return this.loadGeneratedClassFromData(string, byteArray);
        }
        catch (LinkageError linkageError) {
            DatabaseClasses.WriteClassFile(string, byteArray, linkageError);
            throw StandardException.newException("XBCM1.S", linkageError, string);
        }
        catch (VirtualMachineError virtualMachineError) {
            DatabaseClasses.WriteClassFile(string, byteArray, virtualMachineError);
            throw virtualMachineError;
        }
    }

    private static void WriteClassFile(String string, ByteArray byteArray, Throwable throwable) {
        int n = string.lastIndexOf(46);
        String string2 = string.substring(n + 1, string.length()).concat(".class");
        Object object = DatabaseClasses.getMonitor().getEnvironment();
        File file = object instanceof File ? (File)object : null;
        final File file2 = new File(file, string2);
        HeaderPrintWriter headerPrintWriter = Monitor.getStream();
        try {
            FileOutputStream fileOutputStream;
            try {
                fileOutputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                    @Override
                    public FileOutputStream run() throws IOException {
                        return new FileOutputStream(file2);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getCause();
            }
            fileOutputStream.write(byteArray.getArray(), byteArray.getOffset(), byteArray.getLength());
            fileOutputStream.flush();
            if (throwable != null) {
                headerPrintWriter.printlnWithHeader(MessageService.getTextMessage("C000", string, file2, throwable));
            }
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public ClassInspector getClassInspector() {
        return this.classInspector;
    }

    @Override
    public final Class loadApplicationClass(String string) throws ClassNotFoundException {
        Throwable throwable;
        if (string.startsWith("org.apache.derby.")) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        try {
            try {
                return this.loadClassNotInDatabaseJar(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (this.applicationLoader == null) {
                    throw classNotFoundException;
                }
                Class clazz = this.applicationLoader.loadClass(string, true);
                if (clazz == null) {
                    throw classNotFoundException;
                }
                return clazz;
            }
        }
        catch (SecurityException securityException) {
            throwable = securityException;
        }
        catch (LinkageError linkageError) {
            throwable = linkageError;
        }
        throw new ClassNotFoundException(string + " : " + throwable.getMessage());
    }

    abstract Class loadClassNotInDatabaseJar(String var1) throws ClassNotFoundException;

    @Override
    public final Class loadApplicationClass(ObjectStreamClass objectStreamClass) throws ClassNotFoundException {
        return this.loadApplicationClass(objectStreamClass.getName());
    }

    @Override
    public boolean isApplicationClass(Class clazz) {
        return clazz.getClassLoader() instanceof JarLoader;
    }

    @Override
    public void notifyModifyJar(boolean bl) throws StandardException {
        if (this.applicationLoader != null) {
            this.applicationLoader.modifyJar(bl);
        }
    }

    @Override
    public void notifyModifyClasspath(String string) throws StandardException {
        if (this.applicationLoader != null) {
            this.applicationLoader.modifyClasspath(string);
        }
    }

    @Override
    public int getClassLoaderVersion() {
        if (this.applicationLoader != null) {
            return this.applicationLoader.getClassLoaderVersion();
        }
        return -1;
    }

    abstract LoadedGeneratedClass loadGeneratedClassFromData(String var1, ByteArray var2);

    private static ModuleFactory getMonitor() {
        return AccessController.doPrivileged(new PrivilegedAction<ModuleFactory>(){

            @Override
            public ModuleFactory run() {
                return Monitor.getMonitor();
            }
        });
    }
}

