/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.util.Objects;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.Range;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.internal.Numerics;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.TransformException;

public class NumberRange<E extends Number>
extends Range<E> {
    private static final long serialVersionUID = -3198281191274903617L;
    private static final WeakHashSet<NumberRange<?>> POOL = new WeakHashSet<NumberRange>(NumberRange.class);

    static <E extends Number, T extends NumberRange<E>> T unique(T range) {
        if (!range.isEmpty()) {
            range = POOL.unique(range);
        }
        return range;
    }

    static boolean isCacheable(Number n) {
        if (n == null) {
            return true;
        }
        if (n instanceof Double) {
            double value = (Double)n;
            return !Double.isNaN(value) || Double.doubleToRawLongBits(value) == 9221120237041090560L;
        }
        if (n instanceof Float) {
            float value = ((Float)n).floatValue();
            return !Float.isNaN(value) || Float.floatToRawIntBits(value) == 2143289344;
        }
        return Numbers.getEnumConstant(n.getClass()) != 0;
    }

    public static <N extends Number> NumberRange<N> create(Class<N> type, N value) {
        NumberRange<N> range = new NumberRange<N>(type, value, true, value, true);
        if (NumberRange.isCacheable(value)) {
            range = NumberRange.unique(range);
        }
        return range;
    }

    public static NumberRange<Byte> create(byte minValue, boolean isMinIncluded, byte maxValue, boolean isMaxIncluded) {
        return NumberRange.unique(new NumberRange<Byte>(Byte.class, minValue, isMinIncluded, maxValue, isMaxIncluded));
    }

    public static NumberRange<Short> create(short minValue, boolean isMinIncluded, short maxValue, boolean isMaxIncluded) {
        Short min2 = minValue;
        Short max2 = minValue == maxValue ? min2 : maxValue;
        return NumberRange.unique(new NumberRange<Short>(Short.class, min2, isMinIncluded, max2, isMaxIncluded));
    }

    public static NumberRange<Integer> create(int minValue, boolean isMinIncluded, int maxValue, boolean isMaxIncluded) {
        Integer min2 = minValue;
        Integer max2 = minValue == maxValue ? min2 : maxValue;
        return NumberRange.unique(new NumberRange<Integer>(Integer.class, min2, isMinIncluded, max2, isMaxIncluded));
    }

    public static NumberRange<Long> create(long minValue, boolean isMinIncluded, long maxValue, boolean isMaxIncluded) {
        Long min2 = minValue;
        Long max2 = minValue == maxValue ? min2 : maxValue;
        return NumberRange.unique(new NumberRange<Long>(Long.class, min2, isMinIncluded, max2, isMaxIncluded));
    }

    public static NumberRange<Float> create(float minValue, boolean isMinIncluded, float maxValue, boolean isMaxIncluded) {
        Float max2;
        Float min2;
        return NumberRange.unique(new NumberRange<Float>(Float.class, min2, isMinIncluded, Objects.equals(min2 = NumberRange.valueOf("minValue", minValue, Float.NEGATIVE_INFINITY), max2 = NumberRange.valueOf("maxValue", maxValue, Float.POSITIVE_INFINITY)) ? min2 : max2, isMaxIncluded));
    }

    static Float valueOf(String name, float value, float infinity) {
        if (Float.isNaN(value)) {
            throw new IllegalArgumentException(Errors.format((short)110, name));
        }
        return value != infinity ? Float.valueOf(value) : null;
    }

    public static NumberRange<Double> create(double minValue, boolean isMinIncluded, double maxValue, boolean isMaxIncluded) {
        Double max2;
        Double min2;
        return NumberRange.unique(new NumberRange<Double>(Double.class, min2, isMinIncluded, Objects.equals(min2 = NumberRange.valueOf("minValue", minValue, Double.NEGATIVE_INFINITY), max2 = NumberRange.valueOf("maxValue", maxValue, Double.POSITIVE_INFINITY)) ? min2 : max2, isMaxIncluded));
    }

    static Double valueOf(String name, double value, double infinity) {
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException(Errors.format((short)110, name));
        }
        return value != infinity ? Double.valueOf(value) : null;
    }

    public static NumberRange<?> createBestFit(Number minValue, boolean isMinIncluded, Number maxValue, boolean isMaxIncluded) {
        return NumberRange.createBestFit(false, minValue, isMinIncluded, maxValue, isMaxIncluded);
    }

    public static NumberRange<?> createBestFit(boolean asFloat, Number minValue, boolean isMinIncluded, Number maxValue, boolean isMaxIncluded) {
        boolean isCacheable;
        Class<? extends Number> type;
        if (asFloat) {
            if (minValue == null && maxValue == null) {
                return null;
            }
            type = NumberRange.isFloat(minValue) && NumberRange.isFloat(maxValue) ? Float.class : Double.class;
        } else {
            type = Numbers.widestClass(Numbers.narrowestClass(minValue), Numbers.narrowestClass(maxValue));
            if (type == null) {
                return null;
            }
        }
        Number min2 = Numbers.cast(minValue, type);
        Number max2 = Numbers.cast(maxValue, type);
        boolean bl = isCacheable = NumberRange.isCacheable(min2) && NumberRange.isCacheable(max2);
        if (isCacheable && Objects.equals(min2, max2)) {
            max2 = min2;
        }
        NumberRange<Number> range = new NumberRange<Number>(type, min2, isMinIncluded, max2, isMaxIncluded);
        if (isCacheable) {
            range = NumberRange.unique(range);
        }
        return range;
    }

    private static boolean isFloat(Number value) {
        return value == null || Double.doubleToRawLongBits(value.floatValue()) == Double.doubleToRawLongBits(value.doubleValue());
    }

    public static NumberRange<Integer> createLeftBounded(int minValue, boolean isMinIncluded) {
        return POOL.unique(new NumberRange<Object>((Class<Object>)Integer.class, minValue, isMinIncluded, null, false));
    }

    public static <N extends Number> NumberRange<N> castOrCopy(Range<N> range) {
        if (range instanceof NumberRange) {
            return (NumberRange)range;
        }
        return new NumberRange<N>(range);
    }

    public NumberRange(Range<E> range) {
        super(range);
    }

    public NumberRange(Class<E> type, ValueRange range) throws IllegalArgumentException {
        super(type, Numbers.cast(NumberRange.valueOf("minimum", range.minimum(), Double.NEGATIVE_INFINITY), type), range.isMinIncluded(), Numbers.cast(NumberRange.valueOf("maximum", range.maximum(), Double.POSITIVE_INFINITY), type), range.isMaxIncluded());
    }

    public NumberRange(Class<E> type, E minValue, boolean isMinIncluded, E maxValue, boolean isMaxIncluded) {
        super(type, minValue, isMinIncluded, maxValue, isMaxIncluded);
    }

    NumberRange(Class<E> type, Range<? extends Number> range) throws IllegalArgumentException {
        super(type, Numbers.cast((Number)range.minValue, type), range.isMinIncluded, Numbers.cast((Number)range.maxValue, type), range.isMaxIncluded);
    }

    @Override
    Range<E> create(E minValue, boolean isMinIncluded, E maxValue, boolean isMaxIncluded) {
        return new NumberRange<E>(this.elementType, minValue, isMinIncluded, maxValue, isMaxIncluded);
    }

    <N extends Number> NumberRange<N> convertAndCast(NumberRange<?> range, Class<N> type) throws IllegalArgumentException {
        if (range.elementType == type) {
            return range;
        }
        return new NumberRange<N>(type, range);
    }

    public <N extends Number> NumberRange<N> castTo(Class<N> type) throws IllegalArgumentException {
        if (this.elementType == type) {
            return this;
        }
        return new NumberRange<N>(type, this);
    }

    @Override
    Range<E>[] newArray(int length) {
        return new NumberRange[length];
    }

    public double getMinDouble() {
        Number value = (Number)this.getMinValue();
        return value != null ? value.doubleValue() : Double.NEGATIVE_INFINITY;
    }

    public double getMinDouble(boolean inclusive) {
        double value = this.getMinDouble();
        if (inclusive != this.isMinIncluded()) {
            value = NumberRange.next(this.getElementType(), value, inclusive);
        }
        return value;
    }

    public double getMaxDouble() {
        Number value = (Number)this.getMaxValue();
        return value != null ? value.doubleValue() : Double.POSITIVE_INFINITY;
    }

    public double getMaxDouble(boolean inclusive) {
        double value = this.getMaxDouble();
        if (inclusive != this.isMaxIncluded()) {
            value = NumberRange.next(this.getElementType(), value, !inclusive);
        }
        return value;
    }

    public double getMedian() {
        return this.medianOrSpan(true);
    }

    public double getSpan() {
        return this.medianOrSpan(false);
    }

    private double medianOrSpan(boolean median) {
        if (this.minValue == null) {
            if (median) {
                return this.maxValue == null ? Double.NaN : Double.NEGATIVE_INFINITY;
            }
            return Double.POSITIVE_INFINITY;
        }
        if (this.maxValue == null) {
            return Double.POSITIVE_INFINITY;
        }
        if (Numbers.isInteger(this.getElementType())) {
            long min2 = ((Number)((Object)this.minValue)).longValue();
            long max2 = ((Number)((Object)this.maxValue)).longValue();
            if (!this.isMinIncluded) {
                ++min2;
            }
            if (!this.isMaxIncluded) {
                --max2;
            }
            if (min2 <= max2) {
                return median ? MathFunctions.average(min2, max2) : Numerics.toUnsignedDouble(max2 - min2);
            }
        } else {
            double max3;
            double min3 = ((Number)((Object)this.minValue)).doubleValue();
            if (min3 <= (max3 = ((Number)((Object)this.maxValue)).doubleValue())) {
                return median ? (min3 + max3) * 0.5 : max3 - min3;
            }
            if (Double.isNaN(min3) && (this.isMinIncluded || !Double.isNaN(max3))) {
                return min3;
            }
            if (Double.isNaN(max3)) {
                return max3;
            }
        }
        return median ? Double.NaN : 0.0;
    }

    private static double next(Class<?> type, double value, boolean up) {
        if (Numbers.isInteger(type)) {
            value = up ? (value += 1.0) : (value -= 1.0);
        } else if (type.equals(Float.class)) {
            float fv = (float)value;
            value = up ? (double)Math.nextUp(fv) : (double)Math.nextDown(fv);
        } else if (type.equals(Double.class)) {
            value = up ? Math.nextUp(value) : Math.nextDown(value);
        } else {
            throw new IllegalStateException(Errors.format((short)111, type));
        }
        return value;
    }

    public boolean containsAny(Number value) throws IllegalArgumentException {
        int c;
        if (value == null) {
            return false;
        }
        Class<? extends Number> type = Numbers.widestClass(this.elementType, value.getClass());
        value = Numbers.cast(value, type);
        if (this.minValue != null) {
            c = ((Comparable)((Object)Numbers.cast((Number)((Object)this.minValue), type))).compareTo(value);
            if (this.isMinIncluded ? c > 0 : c >= 0) {
                return false;
            }
        }
        if (this.maxValue != null) {
            c = ((Comparable)((Object)Numbers.cast((Number)((Object)this.maxValue), type))).compareTo(value);
            if (this.isMaxIncluded ? c < 0 : c <= 0) {
                return false;
            }
        }
        return true;
    }

    public boolean containsAny(NumberRange<?> range) throws IllegalArgumentException {
        Class<? extends Number> type = Numbers.widestClass(this.elementType, range.elementType);
        return this.castTo(type).contains(this.convertAndCast(range, type));
    }

    public boolean intersectsAny(NumberRange<?> range) throws IllegalArgumentException {
        Class<? extends Number> type = Numbers.widestClass(this.elementType, range.elementType);
        return this.castTo(type).intersects(this.convertAndCast(range, type));
    }

    public NumberRange<?> intersectAny(NumberRange<?> range) throws IllegalArgumentException {
        Class<? extends Number> type = Numbers.widestClass(this.elementType, range.elementType);
        NumberRange<? extends Number> intersect = NumberRange.castOrCopy(this.castTo(type).intersect(this.convertAndCast(range, type)));
        type = Numbers.narrowestClass(this.elementType, range.elementType);
        type = Numbers.widestClass(type, Numbers.narrowestClass((Number)((Object)intersect.minValue)));
        type = Numbers.widestClass(type, Numbers.narrowestClass((Number)((Object)intersect.maxValue)));
        return intersect.castTo(type);
    }

    public NumberRange<?> unionAny(NumberRange<?> range) throws IllegalArgumentException {
        Class<? extends Number> type = Numbers.widestClass(this.elementType, range.elementType);
        return NumberRange.castOrCopy(this.castTo(type).union(this.convertAndCast(range, type)));
    }

    public NumberRange<?>[] subtractAny(NumberRange<?> range) throws IllegalArgumentException {
        Class<? extends Number> type = Numbers.widestClass(this.elementType, range.elementType);
        return (NumberRange[])this.castTo(type).subtract(this.convertAndCast(range, type));
    }

    public NumberRange<?> transform(MathTransform1D converter) throws TransformException {
        double lower = this.getMinDouble();
        double upper = this.getMaxDouble();
        double min2 = converter.transform(lower);
        double max2 = converter.transform(upper);
        if (Double.doubleToLongBits(min2) != Double.doubleToLongBits(lower) || Double.doubleToLongBits(max2) != Double.doubleToLongBits(upper)) {
            if (min2 > max2) {
                return NumberRange.create(max2, this.isMaxIncluded, min2, this.isMinIncluded);
            }
            return NumberRange.create(min2, this.isMinIncluded, max2, this.isMaxIncluded);
        }
        return this;
    }
}

