/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.implementation.jts;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateXY;
import org.locationtech.jts.geom.CoordinateXYM;
import org.locationtech.jts.geom.CoordinateXYZM;

public enum CoordinateSequenceDimensions {
    XY,
    XYZ,
    XYZM,
    XYM;


    public static final CoordinateSequenceDimensions find(Coordinate coordinate) {
        if (coordinate instanceof CoordinateXY) {
            return XY;
        }
        if (coordinate instanceof CoordinateXYM) {
            return XYM;
        }
        if (coordinate instanceof CoordinateXYZM) {
            return XYZM;
        }
        if (Double.isNaN(coordinate.getZ())) {
            return XY;
        }
        return XYZ;
    }

    public static CoordinateSequenceDimensions find(int srsDimension) {
        switch (srsDimension) {
            case 4: {
                return XYZM;
            }
            case 3: {
                return XYZ;
            }
        }
        return XY;
    }

    public static String convertDimensions(CoordinateSequenceDimensions dimensions) {
        switch (dimensions) {
            case XYZ: {
                return " Z";
            }
            case XYM: {
                return " M";
            }
            case XYZM: {
                return " ZM";
            }
        }
        return "";
    }

    public static int convertToInt(CoordinateSequenceDimensions dimensions) {
        switch (dimensions) {
            case XYZ: {
                return 3;
            }
            case XYM: {
                return 3;
            }
            case XYZM: {
                return 4;
            }
        }
        return 2;
    }
}

