/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.TimerTask;
import javax.transaction.xa.XAException;
import org.apache.derby.iapi.services.context.ContextImpl;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.timer.TimerFactory;
import org.apache.derby.iapi.store.access.xa.XAXactId;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedXAResource;
import org.apache.derby.shared.common.error.ExceptionUtil;
import org.apache.derby.shared.common.error.StandardException;

final class XATransactionState
extends ContextImpl {
    static final int TRO_TIMEOUT = -3;
    static final int TRO_DEADLOCK = -2;
    static final int TRO_FAIL = -1;
    static final int T0_NOT_ASSOCIATED = 0;
    static final int T1_ASSOCIATED = 1;
    static final int TC_COMPLETED = 3;
    final EmbedConnection conn;
    final EmbedXAResource creatingResource;
    private EmbedXAResource associatedResource;
    final XAXactId xid;
    CleanupOrCancelMonitor cleanupOrCancelMonitor = new CleanupOrCancelMonitor();
    HashMap<EmbedXAResource, XATransactionState> suspendedList;
    int associationState;
    int rollbackOnlyCode;
    boolean isPrepared;
    boolean performTimeoutRollback;
    CancelXATransactionTask timeoutTask = null;

    private static TimerFactory getTimerFactory() {
        return XATransactionState.getMonitor().getTimerFactory();
    }

    XATransactionState(ContextManager contextManager, EmbedConnection embedConnection, EmbedXAResource embedXAResource, XAXactId xAXactId) {
        super(contextManager, "XATransactionState");
        this.conn = embedConnection;
        this.associatedResource = embedXAResource;
        this.creatingResource = embedXAResource;
        this.associationState = 1;
        this.xid = xAXactId;
        this.performTimeoutRollback = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupOnError(Throwable throwable) {
        if (this.cleanupOrCancelMonitor.okToCleanup() && throwable instanceof StandardException) {
            StandardException standardException = (StandardException)throwable;
            if (standardException.getSeverity() >= 40000) {
                this.popMe();
                return;
            }
            if (standardException.getSeverity() == 30000) {
                XATransactionState xATransactionState = this;
                synchronized (xATransactionState) {
                    this.notifyAll();
                    this.associationState = -1;
                    this.rollbackOnlyCode = "40001".equals(standardException.getMessageId()) ? 102 : (standardException.isLockTimeout() ? 106 : 104);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start(EmbedXAResource embedXAResource, int n) throws XAException {
        XATransactionState xATransactionState = this;
        synchronized (xATransactionState) {
            boolean bl;
            if (this.associationState == -1) {
                throw new XAException(this.rollbackOnlyCode);
            }
            boolean bl2 = bl = this.suspendedList != null && this.suspendedList.get(embedXAResource) != null;
            if (n == 0x8000000 ? !bl : bl) {
                throw new XAException(-6);
            }
            while (this.associationState == 1) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new XAException(4);
                }
            }
            switch (this.associationState) {
                case 0: {
                    break;
                }
                case -3: 
                case -2: 
                case -1: {
                    throw new XAException(this.rollbackOnlyCode);
                }
                default: {
                    throw new XAException(-4);
                }
            }
            if (this.isPrepared) {
                throw new XAException(-6);
            }
            if (bl) {
                this.suspendedList.remove(embedXAResource);
            }
            this.associationState = 1;
            this.associatedResource = embedXAResource;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean end(EmbedXAResource embedXAResource, int n, boolean bl) throws XAException {
        boolean bl2 = false;
        XATransactionState xATransactionState = this;
        synchronized (xATransactionState) {
            boolean bl3;
            boolean bl4 = bl3 = this.suspendedList != null && this.suspendedList.get(embedXAResource) != null;
            if (!bl) {
                while (this.associationState == 1) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new XAException(4);
                    }
                }
            }
            switch (this.associationState) {
                case 3: {
                    throw new XAException(-4);
                }
                case -1: {
                    if (bl) {
                        n = 0x20000000;
                        break;
                    }
                    throw new XAException(this.rollbackOnlyCode);
                }
            }
            boolean bl5 = false;
            switch (n) {
                case 0x4000000: {
                    if (bl3) {
                        this.suspendedList.remove(embedXAResource);
                    } else {
                        if (embedXAResource != this.associatedResource) {
                            throw new XAException(-6);
                        }
                        this.associationState = 0;
                        this.associatedResource = null;
                        bl5 = true;
                    }
                    this.conn.setApplicationConnection(null);
                    break;
                }
                case 0x20000000: {
                    if (bl3) {
                        this.suspendedList.remove(embedXAResource);
                    } else {
                        if (embedXAResource != this.associatedResource) {
                            throw new XAException(-6);
                        }
                        this.associatedResource = null;
                    }
                    if (this.associationState != -1) {
                        this.associationState = -1;
                        this.rollbackOnlyCode = 100;
                    }
                    this.conn.setApplicationConnection(null);
                    bl5 = true;
                    bl2 = true;
                    break;
                }
                case 0x2000000: {
                    if (bl3) {
                        throw new XAException(-6);
                    }
                    if (embedXAResource != this.associatedResource) {
                        throw new XAException(-6);
                    }
                    if (this.suspendedList == null) {
                        this.suspendedList = new HashMap();
                    }
                    this.suspendedList.put(embedXAResource, this);
                    this.associationState = 0;
                    this.associatedResource = null;
                    this.conn.setApplicationConnection(null);
                    bl5 = true;
                    break;
                }
                default: {
                    throw new XAException(-5);
                }
            }
            if (bl5) {
                this.notifyAll();
            }
            return bl2;
        }
    }

    synchronized void scheduleTimeoutTask(long l) {
        this.performTimeoutRollback = true;
        if (l > 0L) {
            this.timeoutTask = new CancelXATransactionTask(this);
            XATransactionState.getTimerFactory().schedule(this.timeoutTask, l);
        } else {
            this.timeoutTask = null;
        }
    }

    synchronized void xa_rollback() throws SQLException {
        this.conn.xa_rollback();
        this.xa_finalize();
    }

    synchronized void xa_commit(boolean bl) throws SQLException {
        this.conn.xa_commit(bl);
        this.xa_finalize();
    }

    synchronized int xa_prepare() throws SQLException {
        int n;
        try {
            n = this.conn.xa_prepare();
        }
        catch (SQLException sQLException) {
            if (ExceptionUtil.isDeferredConstraintViolation((String)sQLException.getSQLState())) {
                this.xa_finalize();
            }
            throw sQLException;
        }
        if (n == 1) {
            this.xa_finalize();
        }
        return n;
    }

    private void xa_finalize() {
        if (this.timeoutTask != null) {
            XATransactionState.getTimerFactory().cancel(this.timeoutTask);
            this.timeoutTask = null;
        }
        this.performTimeoutRollback = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel(String string) throws XAException {
        if (this.cleanupOrCancelMonitor.okToCancel()) {
            XATransactionState xATransactionState = this;
            synchronized (xATransactionState) {
                this.creatingResource.removeXATransaction(this.xid);
                if (this.performTimeoutRollback) {
                    if (string != null) {
                        Monitor.logTextMessage(string, this.xid.toString());
                    }
                    if (this.associationState == 1) {
                        this.conn.cancelRunningStatement();
                        EmbedXAResource embedXAResource = this.associatedResource;
                        this.end(embedXAResource, 0x20000000, true);
                    }
                    try {
                        this.conn.xa_rollback();
                    }
                    catch (SQLException sQLException) {
                        XAException xAException = new XAException(-3);
                        xAException.initCause(sQLException);
                        throw xAException;
                    }
                    this.creatingResource.returnConnectionToResource(this, this.xid);
                }
            }
        }
    }

    private static ModuleFactory getMonitor() {
        return Monitor.getMonitor();
    }

    private static class CleanupOrCancelMonitor {
        private Long cancelThreadId;
        private Long cleanupThreadId;

        private CleanupOrCancelMonitor() {
        }

        public synchronized boolean okToCancel() {
            boolean bl = false;
            if (null == this.cancelThreadId && null == this.cleanupThreadId) {
                this.cancelThreadId = Thread.currentThread().threadId();
                bl = true;
            }
            return bl;
        }

        private synchronized boolean okToCleanup() {
            boolean bl = false;
            if (null == this.cleanupThreadId && null == this.cancelThreadId) {
                this.cleanupThreadId = Thread.currentThread().threadId();
                bl = true;
            }
            return bl;
        }
    }

    private static class CancelXATransactionTask
    extends TimerTask {
        private XATransactionState xaState;

        public CancelXATransactionTask(XATransactionState xATransactionState) {
            this.xaState = xATransactionState;
        }

        @Override
        public synchronized boolean cancel() {
            this.xaState = null;
            return super.cancel();
        }

        @Override
        public synchronized void run() {
            try {
                if (null != this.xaState) {
                    this.xaState.cancel("J135");
                }
            }
            catch (Throwable throwable) {
                Monitor.logThrowable(throwable);
            }
        }
    }
}

