/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.io.ByteSource;
import com.google.common.io.FileBackedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Content;

public class ByteSourceContent
implements Content,
Closeable {
    private static final int FILE_THRESHOLD = 102400;
    private final ByteSource byteSource;
    private final Closeable closeable;

    public static ByteSourceContent of(InputStream stream) throws IOException {
        FileBackedOutputStream out = new FileBackedOutputStream(102400);
        try {
            stream.transferTo(out);
            return new ByteSourceContent(out.asByteSource(), out::reset);
        }
        catch (IOException ioException) {
            out.reset();
            throw ioException;
        }
    }

    public ByteSourceContent(ByteSource byteSource, Closeable closeable) {
        this.byteSource = byteSource;
        this.closeable = closeable;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.byteSource.openStream();
    }

    @Override
    public long size() throws MailboxException {
        try {
            return this.byteSource.size();
        }
        catch (IOException ioException) {
            throw new MailboxException("Cannot compute size", ioException);
        }
    }

    @Override
    public void close() throws IOException {
        this.closeable.close();
    }
}

