/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.payload.evolvable.batch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.batch.PipeTransferBatchReqBuilder;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.IoTDBDataRegionAsyncConnector;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeDynamicMemoryBlock;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryBlockType;
import org.apache.iotdb.db.pipe.resource.memory.PipeModelFixedMemoryBlock;
import org.apache.iotdb.db.storageengine.dataregion.wal.exception.WALPipeException;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipeTabletEventBatch
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTabletEventBatch.class);
    private static PipeModelFixedMemoryBlock pipeModelFixedMemoryBlock = null;
    protected final List<EnrichedEvent> events = new ArrayList<EnrichedEvent>();
    private final int maxDelayInMs;
    private long firstEventProcessingTime = Long.MIN_VALUE;
    protected long totalBufferSize = 0L;
    private final PipeDynamicMemoryBlock allocatedMemoryBlock;
    protected volatile boolean isClosed = false;

    protected PipeTabletEventBatch(int maxDelayInMs, long requestMaxBatchSizeInBytes) {
        if (pipeModelFixedMemoryBlock == null) {
            PipeTabletEventBatch.init();
        }
        this.maxDelayInMs = maxDelayInMs;
        this.allocatedMemoryBlock = pipeModelFixedMemoryBlock.registerPipeBatchMemoryBlock(requestMaxBatchSizeInBytes);
        if (this.getMaxBatchSizeInBytes() != this.allocatedMemoryBlock.getMemoryUsageInBytes()) {
            LOGGER.info("PipeTabletEventBatch: the max batch size is adjusted from {} to {} due to the memory restriction", (Object)requestMaxBatchSizeInBytes, (Object)this.getMaxBatchSizeInBytes());
        }
    }

    public synchronized boolean onEvent(TabletInsertionEvent event) throws WALPipeException, IOException {
        if (this.isClosed || !(event instanceof EnrichedEvent)) {
            return false;
        }
        if (this.events.isEmpty() || !Objects.equals(this.events.get(this.events.size() - 1), event)) {
            if (((EnrichedEvent)event).increaseReferenceCount(PipeTransferBatchReqBuilder.class.getName())) {
                try {
                    if (this.constructBatch(event)) {
                        this.events.add((EnrichedEvent)event);
                    }
                }
                catch (Exception e) {
                    ((EnrichedEvent)event).decreaseReferenceCount(PipeTransferBatchReqBuilder.class.getName(), false);
                    throw e;
                }
                if (this.firstEventProcessingTime == Long.MIN_VALUE) {
                    this.firstEventProcessingTime = System.currentTimeMillis();
                }
            } else {
                LOGGER.warn("Cannot increase reference count for event: {}, ignore it in batch.", (Object)event);
            }
        }
        return this.shouldEmit();
    }

    protected abstract boolean constructBatch(TabletInsertionEvent var1) throws WALPipeException, IOException;

    public boolean shouldEmit() {
        long diff = System.currentTimeMillis() - this.firstEventProcessingTime;
        if (this.totalBufferSize >= this.getMaxBatchSizeInBytes() || diff >= (long)this.maxDelayInMs) {
            this.allocatedMemoryBlock.updateCurrentMemoryEfficiencyAdjustMem((double)diff / (double)this.maxDelayInMs);
            this.recordMetric(diff, this.totalBufferSize);
            return true;
        }
        return false;
    }

    protected abstract void recordMetric(long var1, long var3);

    private long getMaxBatchSizeInBytes() {
        return this.allocatedMemoryBlock.getMemoryUsageInBytes();
    }

    public synchronized void onSuccess() {
        this.events.clear();
        this.totalBufferSize = 0L;
        this.firstEventProcessingTime = Long.MIN_VALUE;
    }

    @Override
    public synchronized void close() {
        this.isClosed = true;
        this.clearEventsReferenceCount(PipeTabletEventBatch.class.getName());
        this.events.clear();
        if (this.allocatedMemoryBlock != null) {
            this.allocatedMemoryBlock.close();
        }
    }

    public synchronized void discardEventsOfPipe(String pipeNameToDrop, int regionId) {
        this.events.removeIf(event -> {
            if (pipeNameToDrop.equals(event.getPipeName()) && regionId == event.getRegionId()) {
                event.clearReferenceCount(IoTDBDataRegionAsyncConnector.class.getName());
                return true;
            }
            return false;
        });
    }

    public synchronized void decreaseEventsReferenceCount(String holderMessage, boolean shouldReport) {
        this.events.forEach(event -> event.decreaseReferenceCount(holderMessage, shouldReport));
    }

    private void clearEventsReferenceCount(String holderMessage) {
        this.events.forEach(event -> event.clearReferenceCount(holderMessage));
    }

    public List<EnrichedEvent> deepCopyEvents() {
        return new ArrayList<EnrichedEvent>(this.events);
    }

    public boolean isEmpty() {
        return this.events.isEmpty();
    }

    public static void init() {
        if (pipeModelFixedMemoryBlock != null) {
            return;
        }
        try {
            long batchSize;
            for (long i = batchSize = PipeDataNodeResourceManager.memory().getAllocatedMemorySizeInBytesOfBatch(); i > 0L; i /= 2L) {
                try {
                    pipeModelFixedMemoryBlock = PipeDataNodeResourceManager.memory().forceAllocateForModelFixedMemoryBlock(i, PipeMemoryBlockType.BATCH);
                    LOGGER.info("pipe model fixed memory block initialized with size: {} bytes", (Object)i);
                    return;
                }
                catch (Exception ignore) {
                    LOGGER.info("pipe model fixed memory block initialized with size: {} bytes failed, try smaller size", (Object)i);
                    continue;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("init pipe model fixed memory block failed", (Throwable)e);
            pipeModelFixedMemoryBlock = PipeDataNodeResourceManager.memory().forceAllocateForModelFixedMemoryBlock(0L, PipeMemoryBlockType.BATCH);
        }
    }
}

