/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.graph;

import java.util.Map;
import java.util.UUID;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.JsonUtil;

public abstract class GraphAPI
extends API {
    private static final String PATH = "graphspaces/%s/graphs/%s/graph/%s";
    private final String batchPath;

    public GraphAPI(RestClient client, String graphSpace, String graph) {
        super(client);
        this.path(PATH, graphSpace, graph, this.type());
        this.batchPath = String.join((CharSequence)"/", this.path(), "batch");
    }

    public static String formatVertexId(Object id) {
        return GraphAPI.formatVertexId(id, false);
    }

    public static String formatVertexId(Object id, boolean allowNull) {
        if (!allowNull) {
            E.checkArgumentNotNull((Object)id, (String)"The vertex id can't be null", (Object[])new Object[0]);
        } else if (id == null) {
            return null;
        }
        boolean uuid = id instanceof UUID;
        if (uuid) {
            id = id.toString();
        }
        E.checkArgument((id instanceof String || id instanceof Number ? 1 : 0) != 0, (String)"The vertex id must be either String or Number, but got '%s'", (Object[])new Object[]{id});
        return (uuid ? "U" : "") + JsonUtil.toJson(id);
    }

    public static String formatProperties(Map<String, Object> properties) {
        if (properties == null) {
            return null;
        }
        return JsonUtil.toJson(properties);
    }

    public String batchPath() {
        return this.batchPath;
    }
}

